/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.graphs;

import com.pnfsoftware.jeb.core.output.code.coordinates.ICodeCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.InstructionCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.MethodCoordinates;
import com.pnfsoftware.jeb.core.units.code.ICodeClass;
import com.pnfsoftware.jeb.core.units.code.ICodeItem;
import com.pnfsoftware.jeb.core.units.code.ICodeMethod;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.model.Digraph;
import com.pnfsoftware.jeb.rcpclient.parts.units.graphs.ICallgraphBuilder;
import com.pnfsoftware.jeb.util.collect.MultiMap;
import com.pnfsoftware.jeb.util.collect.WeakIdentityHashMap;
import com.pnfsoftware.jeb.util.collect.WeakValueMap;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class DalvikCallgraphBuilder
implements ICallgraphBuilder {
    private ICodeUnit unit;
    private Digraph model;
    private WeakValueMap<Integer, ICodeMethod> vertexIdToMethodObject;
    private WeakIdentityHashMap<ICodeMethod, Integer> methodObjectToVertexId;
    private String rawfilter;
    private int fltCount;
    private Set<String> wlFltFull = new HashSet<String>();
    private List<String> wlFltStart = new ArrayList<String>();
    private Set<String> blFltFull = new HashSet<String>();
    private List<String> blFltStart = new ArrayList<String>();

    public DalvikCallgraphBuilder(ICodeUnit unit) {
        this.unit = unit;
    }

    @Override
    public Digraph buildModel() {
        MultiMap<Integer, Integer> typeToInternalMethods = new MultiMap<Integer, Integer>();
        HashMap<Integer, Integer> methodToType = new HashMap<Integer, Integer>();
        HashMap<Integer, TreeSet<Integer>> methodToMethods = new HashMap<Integer, TreeSet<Integer>>();
        int edgecnt = 0;
        TreeMap<Integer, ICodeMethod> internal_methods = new TreeMap<Integer, ICodeMethod>();
        for (ICodeMethod iCodeMethod : this.unit.getMethods()) {
            if (!iCodeMethod.isInternal() || !this.filter(iCodeMethod)) continue;
            internal_methods.put(iCodeMethod.getIndex(), iCodeMethod);
        }
        for (ICodeClass iCodeClass : this.unit.getClasses()) {
            if ((iCodeClass.getGenericFlags() & 0x100000) != 0 || !this.filter(iCodeClass)) continue;
            int typeIndex = iCodeClass.getClassType().getIndex();
            if (iCodeClass.getMethods() == null) continue;
            for (ICodeMethod iCodeMethod : iCodeClass.getMethods()) {
                int methodIndex = iCodeMethod.getIndex();
                typeToInternalMethods.put(typeIndex, methodIndex);
                methodToType.put(methodIndex, typeIndex);
                List<? extends IInstruction> instructions = iCodeMethod.getInstructions();
                if (instructions == null) continue;
                for (IInstruction iInstruction : instructions) {
                    String s = iInstruction.format(null);
                    int refMethodIndex = DalvikCallgraphBuilder.extractMethodIndex(s);
                    if (refMethodIndex < 0 || !internal_methods.containsKey(refMethodIndex)) continue;
                    TreeSet<Integer> set = (TreeSet<Integer>)methodToMethods.get(methodIndex);
                    if (set == null) {
                        set = new TreeSet<Integer>();
                        methodToMethods.put(methodIndex, set);
                    }
                    if (!set.add(refMethodIndex)) continue;
                    ++edgecnt;
                }
            }
        }
        this.model = new Digraph();
        this.vertexIdToMethodObject = new WeakValueMap();
        this.methodObjectToVertexId = new WeakIdentityHashMap();
        for (ICodeMethod iCodeMethod : internal_methods.values()) {
            String name = iCodeMethod.getClassType().getName(true) + "." + iCodeMethod.getName(true);
            int insncount = iCodeMethod.getInstructions() == null ? 0 : iCodeMethod.getInstructions().size();
            this.model.v(iCodeMethod.getIndex(), Double.valueOf(insncount), name);
            this.vertexIdToMethodObject.put(iCodeMethod.getIndex(), iCodeMethod);
            this.methodObjectToVertexId.put(iCodeMethod, iCodeMethod.getIndex());
        }
        Iterator<ICodeItem> iterator = methodToMethods.keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)((Object)iterator.next());
            Iterator iterator2 = ((Set)methodToMethods.get(n)).iterator();
            while (iterator2.hasNext()) {
                int i1 = (Integer)iterator2.next();
                this.model.e(n, i1);
            }
        }
        return this.model;
    }

    private static int extractMethodIndex(String s) {
        int i;
        if (s.startsWith("invoke") && (i = s.indexOf("method@")) >= 0) {
            int j = s.indexOf(",", i += 7);
            if (j < 0) {
                j = s.length();
            }
            return Integer.parseInt(s.substring(i, j));
        }
        return -1;
    }

    @Override
    public String getAddressForVertexId(int vertexId) {
        ICodeMethod m;
        ICodeMethod iCodeMethod = m = this.vertexIdToMethodObject == null ? null : this.vertexIdToMethodObject.get(vertexId);
        if (m == null) {
            return null;
        }
        return m.getAddress();
    }

    @Override
    public Integer getVertexIdForAddress(String address) {
        ICodeCoordinates cc = this.unit.getCodeCoordinatesFromAddress(address);
        Integer index = null;
        if (cc instanceof InstructionCoordinates) {
            index = ((InstructionCoordinates)cc).getMethodId();
        } else if (cc instanceof MethodCoordinates) {
            index = ((MethodCoordinates)cc).getMethodId();
        } else {
            return null;
        }
        ICodeMethod m = this.unit.getMethods().get(index);
        if (m == null) {
            return null;
        }
        return this.methodObjectToVertexId.get(m);
    }

    public String getFilter() {
        return this.rawfilter;
    }

    public void setFilter(String filter) {
        this.rawfilter = filter;
        this.wlFltStart.clear();
        this.blFltStart.clear();
        if (this.rawfilter == null) {
            return;
        }
        this.fltCount = 0;
        for (String line : Strings.splitLines(this.rawfilter)) {
            if ((line = Strings.trim(line)).isEmpty() || line.startsWith("#")) continue;
            boolean blacklisted = false;
            if (line.startsWith("-")) {
                if ((line = line.substring(1)).isEmpty()) continue;
                blacklisted = true;
            }
            if (line.endsWith("*")) {
                line = line.substring(0, line.length() - 1);
                if (blacklisted) {
                    this.blFltStart.add(line);
                } else {
                    this.wlFltStart.add(line);
                }
            } else if (blacklisted) {
                this.blFltFull.add(line);
            } else {
                this.wlFltFull.add(line);
            }
            ++this.fltCount;
        }
    }

    private boolean filter(ICodeItem item) {
        if (this.fltCount == 0) {
            return true;
        }
        String sig = item.getSignature(true);
        if (sig == null) {
            return false;
        }
        int pos = sig.indexOf(";");
        if (pos < 2) {
            return false;
        }
        String pname = sig.substring(1, pos).replace('/', '.');
        if (!(this.wlFltFull.isEmpty() && this.wlFltStart.isEmpty() || this.wlFltFull.contains(pname))) {
            boolean proceed = false;
            for (String f : this.wlFltStart) {
                if (!pname.startsWith(f)) continue;
                proceed = true;
                break;
            }
            if (!proceed) {
                return false;
            }
        }
        if (this.blFltFull.contains(pname)) {
            return false;
        }
        for (String f : this.blFltStart) {
            if (!pname.startsWith(f)) continue;
            return false;
        }
        return true;
    }
}

