/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.graphs;

import com.pnfsoftware.jeb.client.api.OperationRequest;
import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.events.PropertyChangeNotification;
import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.rcpclient.AllHandlers;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.dialogs.FindTextDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.JumpToDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.Graph;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.GraphNode;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.GraphPlaceholder;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.IGraphController;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.IGraphNodeContents;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.NodeContentsInteractiveTextFactory;
import com.pnfsoftware.jeb.rcpclient.extensions.search.FindTextOptions;
import com.pnfsoftware.jeb.rcpclient.extensions.search.GraphicalTextFinder;
import com.pnfsoftware.jeb.rcpclient.extensions.search.IFindTextImpl;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.ITextDocumentViewer;
import com.pnfsoftware.jeb.rcpclient.iviewers.text.InteractiveTextFindResult;
import com.pnfsoftware.jeb.rcpclient.operations.ContextMenu;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitView;
import com.pnfsoftware.jeb.rcpclient.parts.units.graphs.NodeContentsTextFragment;
import com.pnfsoftware.jeb.rcpclient.util.TextHistory;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.List;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractLocalGraphFragment<T extends IUnit>
extends AbstractUnitFragment<T>
implements IGraphController {
    private static final ILogger logger = GlobalLog.getLogger(AbstractLocalGraphFragment.class);
    protected IPropertyManager pm;
    private IEventListener pmListener;
    protected GraphPlaceholder<Graph> gp;
    private boolean inUse;
    private GraphicalTextFinder<InteractiveTextFindResult> finder;
    protected NodeContentsInteractiveTextFactory contentsFactory;

    public AbstractLocalGraphFragment(Composite parent, int style, T unit, IRcpUnitView unitView, RcpClientContext context) {
        super(parent, style, unit, unitView, context);
        this.setLayout((Layout)new FillLayout());
        this.setBackground(UIAssetManager.getInstance().getColor(0xFFFFFF));
        this.newGraphWithControls();
        this.pm = context.getPropertyManager();
        this.pmListener = new IEventListener(){

            @Override
            public void onEvent(IEvent e) {
                if (e.getType() == J.PropertyChange && e.getData() instanceof PropertyChangeNotification) {
                    AbstractLocalGraphFragment.this.onClientPropertyChange((PropertyChangeNotification)e.getData());
                }
            }
        };
        this.pm.addListener(this.pmListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AbstractLocalGraphFragment.this.pm.removeListener(AbstractLocalGraphFragment.this.pmListener);
            }
        });
    }

    protected void onClientPropertyChange(PropertyChangeNotification n) {
    }

    protected final void newGraphWithControls() {
        this.gp = new GraphPlaceholder<Graph>((Composite)this, 0, true, false){

            @Override
            protected Graph createGraph(GraphPlaceholder<Graph> gp, Graph previousGraph) {
                boolean keyboardControls = true;
                boolean mouseControls = true;
                boolean zoomingAllowed = true;
                int zoomLevel = 0;
                if (previousGraph != null) {
                    keyboardControls = previousGraph.isKeyboardControls();
                    mouseControls = previousGraph.isMouseControls();
                    zoomingAllowed = previousGraph.isZoomingAllowed();
                    zoomLevel = previousGraph.getZoomLevel();
                }
                Graph g = new Graph(gp, 0);
                g.setKeyboardControls(keyboardControls);
                g.setMouseControls(mouseControls);
                g.setZoomingAllowed(zoomingAllowed);
                g.setInitialZoomLevel(zoomLevel);
                return g;
            }
        };
        this.prepareCanvas();
    }

    protected final void prepareCanvas() {
        new ContextMenu((Control)this.gp.getGraph()).addContextMenu(new IContextMenu(){

            @Override
            public void fillContextMenu(IMenuManager menuMgr) {
                if (AbstractLocalGraphFragment.this.getContext() == null) {
                    return;
                }
                AllHandlers.getInstance().fillManager(menuMgr, 4);
            }
        });
    }

    public GraphPlaceholder<Graph> getGraphWithControls() {
        return this.gp;
    }

    public Graph getGraph() {
        return this.gp.getGraph();
    }

    public boolean setFocus() {
        return this.gp.setFocus();
    }

    protected final void reset(boolean markInUse) {
        if (this.inUse) {
            this.gp.reset();
            this.inUse = false;
        }
        if (!this.inUse && markInUse) {
            this.prepareCanvas();
            this.inUse = true;
        }
    }

    public boolean isValidGraph() {
        return this.inUse && this.getGraph().getNodeCount() >= 1;
    }

    protected void newContentsFactory() {
        this.contentsFactory = new NodeContentsInteractiveTextFactory(this.getDisplay(), this.context.getFontManager(), this.context.getStyleManager(), this.unit, this.context.getStatusIndicator(), this, this, this.context);
    }

    protected void notifyContentsCreated() {
    }

    protected NodeContentsTextFragment getActiveContents() {
        if (!this.inUse) {
            return null;
        }
        GraphNode node = this.gp.getGraph().getActiveNode();
        if (node == null) {
            return null;
        }
        return (NodeContentsTextFragment)node.getContents();
    }

    protected NodeContentsTextFragment getContentsForNode(int index) {
        if (!this.inUse) {
            return null;
        }
        GraphNode node = this.gp.getGraph().getNodes().get(index);
        if (node == null) {
            return null;
        }
        return (NodeContentsTextFragment)node.getContents();
    }

    @Override
    public String getActiveAddress() {
        NodeContentsTextFragment contents = this.getActiveContents();
        return contents == null ? null : contents.getActiveAddress();
    }

    @Override
    public IItem getActiveItem() {
        NodeContentsTextFragment contents = this.getActiveContents();
        return contents == null ? null : contents.getActiveItem();
    }

    @Override
    public String getActiveItemAsText() {
        NodeContentsTextFragment contents = this.getActiveContents();
        return contents == null ? null : contents.getActiveItemAsText();
    }

    @Override
    public boolean verifyOperation(OperationRequest req) {
        if (!this.isValidGraph()) {
            return false;
        }
        NodeContentsTextFragment contents = this.getActiveContents();
        if (contents != null && contents.verifyOperation(req)) {
            return true;
        }
        switch (req.getOperation()) {
            case FIND: {
                return true;
            }
            case FIND_NEXT: {
                return this.finder != null;
            }
            case JUMP_TO: 
            case ITEM_FOLLOW: {
                return true;
            }
            case CENTER: {
                return true;
            }
            case ZOOM_IN: {
                return this.getGraph().isZoomingAllowed();
            }
            case ZOOM_OUT: {
                return this.getGraph().isZoomingAllowed();
            }
            case ZOOM_RESET: {
                return this.getGraph().isZoomingAllowed() && this.getGraph().getZoomLevel() != 0;
            }
        }
        return false;
    }

    @Override
    public boolean doOperation(OperationRequest req) {
        if (!this.isValidGraph()) {
            return false;
        }
        NodeContentsTextFragment contents = this.getActiveContents();
        if (contents != null) {
            if (contents.doOperation(req)) {
                return true;
            }
            if (!req.proceed()) {
                return false;
            }
        }
        if (contents == null && (contents = this.getContentsForNode(0)) == null) {
            return false;
        }
        switch (req.getOperation()) {
            case FIND: {
                String selection;
                ITextDocumentViewer iviewer = contents.getViewer();
                this.finder = new GraphicalTextFinder<InteractiveTextFindResult>(new FindTextInGraphImpl(), this.context);
                FindTextDialog dlg = FindTextDialog.getInstance(this);
                if (dlg != null) {
                    dlg.setFocus();
                    return true;
                }
                FindTextOptions opt = iviewer.getFindTextOptions(true);
                if (Strings.isBlank(opt.getSearchString()) && (selection = iviewer.getTextWidget().getSelectionText()) != null) {
                    int endline = selection.indexOf("\n");
                    if (endline == 0) {
                        endline = selection.indexOf("\n", 1);
                        selection = endline >= 0 ? selection.substring(1, endline) : selection.substring(1);
                    } else if (endline > 0) {
                        selection = selection.substring(0, endline);
                    }
                    opt.setSearchString(selection);
                }
                TextHistory history = RcpClientContext.getStandardFindTextHistory(this.context);
                dlg = new FindTextDialog(this.getShell(), this.finder, history, false, (Control)this, this.getUnit().getName());
                dlg.open(this);
                return true;
            }
            case FIND_NEXT: {
                this.finder.search(null);
                return true;
            }
            case JUMP_TO: {
                return this.doJumpTo();
            }
            case ITEM_FOLLOW: {
                return this.doItemFollow();
            }
            case CENTER: {
                this.getGraph().centerGraph(0);
                return true;
            }
            case ZOOM_IN: {
                this.getGraph().applyZoom(1, false);
                return true;
            }
            case ZOOM_OUT: {
                this.getGraph().applyZoom(-1, false);
                return true;
            }
            case ZOOM_RESET: {
                this.getGraph().applyZoom(0, false);
                return true;
            }
        }
        return false;
    }

    @Override
    public abstract boolean setActiveAddress(String var1, Object var2, boolean var3);

    protected boolean doJumpTo() {
        JumpToDialog dlg = new JumpToDialog(this.getShell(), RcpClientContext.getStandardAddressHistory(this.context));
        String address = dlg.open();
        if (address == null) {
            return false;
        }
        return this.setActiveAddress(address);
    }

    protected abstract boolean doItemFollow();

    public boolean canDisplayAtAddress(String address) {
        return true;
    }

    @Override
    public void onNodeBreakoutAttempt(IGraphNodeContents nodeContents, int direction) {
    }

    private class FindTextInGraphImpl
    implements IFindTextImpl<InteractiveTextFindResult> {
        final int startIndex;
        int index;
        GraphNode currentNode;
        NodeContentsTextFragment currentNodeContents;
        ITextDocumentViewer currentNodeViewer;
        FindTextOptions findOptions;
        boolean end;

        public FindTextInGraphImpl() {
            List<GraphNode> nodes = AbstractLocalGraphFragment.this.gp.getGraph().getNodes();
            GraphNode node = AbstractLocalGraphFragment.this.gp.getGraph().getActiveNode();
            if (node != null) {
                this.index = nodes.indexOf(node);
            } else {
                this.index = 0;
                node = nodes.get(0);
            }
            this.startIndex = this.index;
            this.currentNode = node;
            this.currentNodeContents = (NodeContentsTextFragment)node.getContents();
            this.currentNodeViewer = this.currentNodeContents.getViewer();
        }

        private boolean nextNode() {
            int nodecnt = AbstractLocalGraphFragment.this.gp.getGraph().getNodeCount();
            this.index = (this.index + 1) % nodecnt;
            this.currentNode = AbstractLocalGraphFragment.this.gp.getGraph().getNode(this.index);
            this.currentNodeContents = (NodeContentsTextFragment)this.currentNode.getContents();
            this.currentNodeViewer = this.currentNodeContents.getViewer();
            this.currentNodeViewer.resetFindTextOptions();
            return this.index != this.startIndex;
        }

        @Override
        public boolean supportReverseSearch() {
            return false;
        }

        @Override
        public void resetFindTextOptions() {
            this.currentNodeViewer.resetFindTextOptions();
        }

        @Override
        public void setFindTextOptions(FindTextOptions options) {
            this.findOptions = options;
        }

        @Override
        public FindTextOptions getFindTextOptions(boolean update) {
            if (this.findOptions == null) {
                this.findOptions = this.currentNodeViewer.getFindTextOptions(update);
            } else {
                this.currentNodeViewer.setFindTextOptions(this.findOptions);
            }
            this.currentNodeViewer.getFindTextOptions(update);
            return this.findOptions;
        }

        @Override
        public InteractiveTextFindResult findText(FindTextOptions opt) {
            InteractiveTextFindResult r;
            FindTextOptions options;
            FindTextOptions findTextOptions = options = opt != null ? opt : this.findOptions;
            if (options == null) {
                return null;
            }
            if (this.end) {
                if (!options.isWrapAround()) {
                    return null;
                }
                this.end = false;
            }
            do {
                FindTextOptions inNodeOptions = options.clone();
                inNodeOptions.setWrapAround(false);
                r = (InteractiveTextFindResult)this.currentNodeViewer.findText(inNodeOptions);
                if (r == null) {
                    return null;
                }
                if (r.isEndOfSearch()) continue;
                return r;
            } while (this.nextNode());
            this.end = true;
            return r;
        }

        @Override
        public void processFindResult(InteractiveTextFindResult r) {
            AbstractLocalGraphFragment.this.getGraph().showNode(this.currentNode, true);
            this.currentNode.setFocus();
            this.currentNodeViewer.processFindResult(r);
        }

        @Override
        public void clearFindResult() {
            this.currentNodeViewer.clearFindResult();
        }
    }
}

