/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.debuggers;

import com.pnfsoftware.jeb.client.api.OperationRequest;
import com.pnfsoftware.jeb.core.exceptions.DebuggerException;
import com.pnfsoftware.jeb.core.units.code.debug.DebuggerThreadStatus;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerThread;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerThreadStackFrame;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.extensions.UIExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.UIRunnable;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.PatternTreeView;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTreeViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTreeContentProvider;
import com.pnfsoftware.jeb.rcpclient.operations.ContextMenu;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import com.pnfsoftware.jeb.rcpclient.util.regex.IValueProvider;
import com.pnfsoftware.jeb.rcpclient.util.regex.SimplePatternMatcher;
import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class DbgThreadsFragment
extends AbstractUnitFragment<IDebuggerUnit>
implements IContextMenu {
    private static final ILogger logger = GlobalLog.getLogger(DbgThreadsFragment.class);
    private PatternTreeView ftv;
    private FilteredTreeViewer viewer;
    private LabelProvider labelProvider;
    private Object lastSelectedNode;
    private String lastAddress;

    public DbgThreadsFragment(Composite parent, int flags, IRcpClientContext context, IDebuggerUnit unit) {
        super(parent, flags, unit, null, context);
        this.setLayout((Layout)new FillLayout());
        this.labelProvider = new LabelProvider();
        SimplePatternMatcher patternMatcher = new SimplePatternMatcher(this.labelProvider);
        boolean expandAfterFilter = context.getPropertyManager().getBoolean(".ui.ExpandTreeNodesOnFiltering");
        String[] titleColumns = new String[]{"Thread ID", "State", "Name"};
        this.ftv = new PatternTreeView(this, 65536, titleColumns, null, patternMatcher, expandAfterFilter);
        this.viewer = this.ftv.getTreeViewer();
        Tree tree = this.ftv.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        tree.addListener(17, new Listener(){

            public void handleEvent(Event event) {
                DbgThreadsFragment.this.expandTree((TreeItem)event.item);
            }
        });
        tree.addListener(18, new Listener(){

            public void handleEvent(Event event) {
                DbgThreadsFragment.this.collapseTree((TreeItem)event.item);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            @Override
            public void doubleClick(DoubleClickEvent event) {
                DbgThreadsFragment.this.handleDoubleClick();
            }
        });
        this.viewer.setContentProvider(new TreeContentProvider());
        this.viewer.setLabelProvider(this.labelProvider);
        this.viewer.setInput(unit);
        this.packColumns(true);
        new ContextMenu((Control)tree).addContextMenu(this);
    }

    public void packColumns(boolean force) {
        TreeColumn[] cols;
        for (TreeColumn col : cols = this.ftv.getTree().getColumns()) {
            if (!force && col.getWidth() != 0) continue;
            col.pack();
        }
    }

    private void expandTree(TreeItem root) {
        IDebuggerThread t = (IDebuggerThread)root.getData();
        Object[] frames = DbgThreadsFragment.getData(t);
        TreeItem[] items = root.getItems();
        if (items != null && items.length > 1) {
            this.collapseTree(root);
        }
        int i = 0;
        for (Object frame : frames) {
            TreeItem item = new TreeItem(root, 0, i);
            item.setData(frame);
            item.setText(this.labelProvider.getStringArray(frame));
            ++i;
        }
        items = root.getItems();
        if (items != null && items.length > 1) {
            items[items.length - 1].dispose();
        }
    }

    private void collapseTree(TreeItem root) {
        TreeItem[] items = root.getItems();
        for (int i = 0; i < items.length - 1; ++i) {
            items[i].dispose();
        }
    }

    private void handleDoubleClick() {
        Object node = this.getSelectedNode();
        if (node instanceof IDebuggerThread) {
            IDebuggerThread thread = (IDebuggerThread)node;
            IDebuggerThread currentThread = ((IDebuggerUnit)this.getUnit()).getDefaultThread();
            if (currentThread == null || currentThread.getId() != thread.getId()) {
                ((IDebuggerUnit)this.getUnit()).setDefaultThread(thread.getId());
            }
        }
    }

    public Object getSelectedNode() {
        ITreeSelection treesel = (ITreeSelection)this.viewer.getSelection();
        if (treesel.isEmpty()) {
            return null;
        }
        return treesel.getFirstElement();
    }

    public TreeViewer getJfaceViewer() {
        return (TreeViewer)this.viewer.getViewer();
    }

    @Override
    public void fillContextMenu(IMenuManager menuMgr) {
        Object elt = this.getSelectedNode();
        if (elt instanceof IDebuggerThread) {
            final IDebuggerThread t = (IDebuggerThread)elt;
            menuMgr.add(new Action("Set as default thread"){

                @Override
                public void run() {
                    ((IDebuggerUnit)DbgThreadsFragment.this.getUnit()).setDefaultThread(t.getId());
                }

                @Override
                public boolean isEnabled() {
                    return ((IDebuggerUnit)DbgThreadsFragment.this.getUnit()).getDefaultThread() != t;
                }
            });
            menuMgr.add(new Action("Resume"){

                @Override
                public void run() {
                    t.resume();
                }

                @Override
                public boolean isEnabled() {
                    return t.getStatus() == DebuggerThreadStatus.PAUSED;
                }
            });
            menuMgr.add(new Action("Suspend"){

                @Override
                public void run() {
                    t.suspend();
                }

                @Override
                public boolean isEnabled() {
                    return t.getStatus() != DebuggerThreadStatus.PAUSED;
                }
            });
        }
        this.addOperationsToContextMenu(menuMgr);
    }

    private static Object[] getData(IDebuggerThread t) {
        if (t.getStatus() == DebuggerThreadStatus.PAUSED) {
            try {
                List<? extends IDebuggerThreadStackFrame> frames = t.getFrames();
                if (frames != null) {
                    return frames.toArray();
                }
            }
            catch (DebuggerException debuggerException) {
                // empty catch block
            }
        }
        return ArrayUtil.NO_OBJECT;
    }

    @Override
    public boolean verifyOperation(OperationRequest req) {
        switch (req.getOperation()) {
            case FIND: {
                return true;
            }
            case COPY: {
                return this.getSelectedNode() != null;
            }
        }
        return false;
    }

    @Override
    public boolean doOperation(OperationRequest req) {
        switch (req.getOperation()) {
            case FIND: {
                this.ftv.setFilterVisibility(true, true);
                return true;
            }
            case COPY: {
                return this.copyObjectToClipboard(this.getSelectedNode());
            }
        }
        return false;
    }

    private boolean copyObjectToClipboard(Object obj) {
        String s;
        if (obj != null && (s = obj.toString()) != null) {
            UIUtil.copyTextToClipboard(s);
            return true;
        }
        return false;
    }

    @Override
    public String getActiveAddress() {
        Object selectedNode = this.getSelectedNode();
        if (this.lastSelectedNode == selectedNode && this.lastAddress != null) {
            return this.lastAddress;
        }
        String address = null;
        if (selectedNode instanceof IDebuggerThread) {
            address = ((IDebuggerThread)selectedNode).getLocation();
        }
        if (selectedNode instanceof IDebuggerThreadStackFrame) {
            address = ((IDebuggerThreadStackFrame)selectedNode).getAddress();
        }
        this.lastSelectedNode = selectedNode;
        this.lastAddress = address;
        return address;
    }

    @Override
    public byte[] export() {
        return Strings.encodeUTF8(this.viewer.exportToString());
    }

    @Override
    public AbstractUnitFragment.FragmentType getFragmentType() {
        return AbstractUnitFragment.FragmentType.TREE;
    }

    class LabelProvider
    extends StyledCellLabelProvider
    implements IValueProvider {
        LabelProvider() {
        }

        @Override
        public void update(ViewerCell cell) {
            Object elt = cell.getElement();
            int index = cell.getColumnIndex();
            String text = this.getStringAt(elt, index);
            if (elt instanceof IDebuggerThread) {
                long tid = ((IDebuggerThread)elt).getId();
                if (((IDebuggerUnit)DbgThreadsFragment.this.getUnit()).getDefaultThread() != null && ((IDebuggerUnit)DbgThreadsFragment.this.getUnit()).getDefaultThread().getId() == tid) {
                    cell.setForeground(UIAssetManager.getInstance().getColor(255, 0, 0));
                } else {
                    cell.setForeground(null);
                }
            }
            cell.setText(text);
            super.update(cell);
        }

        @Override
        public String getStringAt(Object element, int key) {
            if (element instanceof IDebuggerThread) {
                IDebuggerThread e = (IDebuggerThread)element;
                if (key == 0) {
                    return Long.toString(e.getId());
                }
                if (key == 1) {
                    return "" + (Object)((Object)e.getStatus());
                }
                if (key == 2) {
                    return e.getName();
                }
            } else if (element instanceof IDebuggerThreadStackFrame) {
                IDebuggerThreadStackFrame e = (IDebuggerThreadStackFrame)element;
                if (key == 0) {
                    return Long.toString(e.getId());
                }
                if (key == 1) {
                    return "";
                }
                if (key == 2) {
                    return e.getAddress();
                }
            }
            return null;
        }

        private String[] getStringArray(Object element) {
            return new String[]{this.getStringAt(element, 0), this.getStringAt(element, 1), this.getStringAt(element, 2)};
        }

        @Override
        public String getString(Object element) {
            return Strings.join(",", Arrays.asList(this.getStringArray(element)));
        }
    }

    public class TreeContentProvider
    implements IFilteredTreeContentProvider {
        IDebuggerUnit dbg;
        IEventListener listener;

        @Override
        public void dispose() {
        }

        @Override
        public void inputChanged(final Viewer viewer, Object oldInput, Object newInput) {
            if (oldInput != null && this.listener != null) {
                ((IDebuggerUnit)oldInput).removeListener(this.listener);
                this.listener = null;
            }
            this.dbg = (IDebuggerUnit)newInput;
            if (this.dbg == null) {
                return;
            }
            this.listener = new IEventListener(){

                @Override
                public void onEvent(IEvent e) {
                    logger.i("Event: %s", e);
                    if (TreeContentProvider.this.dbg != null && e.getSource() == TreeContentProvider.this.dbg) {
                        UIExecutor.async((Widget)viewer.getControl(), new UIRunnable(){

                            @Override
                            public void runi() {
                                if (TreeContentProvider.this.dbg != null && !viewer.getControl().isDisposed()) {
                                    logger.i("Refreshing threads list...", new Object[0]);
                                    List expanded = TreeContentProvider.this.getExpandedTreeItems();
                                    viewer.refresh();
                                    DbgThreadsFragment.this.packColumns(false);
                                    TreeContentProvider.this.expandTreeItems(expanded);
                                }
                            }
                        });
                    }
                }
            };
            this.dbg.addListener(this.listener);
        }

        private List<Integer> getExpandedTreeItems() {
            TreeItem[] treeItems = DbgThreadsFragment.this.ftv.getTree().getItems();
            ArrayList<Integer> expanded = new ArrayList<Integer>();
            if (treeItems != null) {
                for (int i = 0; i < treeItems.length; ++i) {
                    TreeItem item = treeItems[i];
                    if (!item.getExpanded()) continue;
                    expanded.add(i);
                }
            }
            return expanded;
        }

        private void expandTreeItems(List<Integer> expanded) {
            for (int i : expanded) {
                TreeItem[] treeItems;
                if (i >= (treeItems = DbgThreadsFragment.this.ftv.getTree().getItems()).length) continue;
                treeItems[i].setExpanded(true);
                DbgThreadsFragment.this.expandTree(treeItems[i]);
            }
        }

        @Override
        public Object[] getElements(Object inputElement) {
            IDebuggerUnit unit = (IDebuggerUnit)inputElement;
            try {
                List<? extends IDebuggerThread> threads;
                if (unit.isAttached() && (threads = unit.getThreads()) != null) {
                    return threads.toArray();
                }
            }
            catch (DebuggerException debuggerException) {
                // empty catch block
            }
            return ArrayUtil.NO_OBJECT;
        }

        @Override
        public Object getParent(Object element) {
            return null;
        }

        @Override
        public boolean hasChildren(Object element) {
            return this.getChildren(element) != null;
        }

        @Override
        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IDebuggerThread) {
                return new Object[]{new Object()};
            }
            return null;
        }

        public String getString(Object element) {
            if (element instanceof IDebuggerThread) {
                IDebuggerThread t = (IDebuggerThread)element;
                return Strings.join(",", Arrays.asList(t.getName(), t.getId()));
            }
            return null;
        }

        @Override
        public Object[] getRowElements(Object row) {
            return new Object[]{this.getString(row)};
        }
    }
}

