/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.code;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IEOptimizerInfo;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeSourceUnit;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.FilteredTableView;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.ITableEventListener;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultCellLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultCheckStateProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTableViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTableContentProvider;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import java.util.IdentityHashMap;
import java.util.List;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class DecompDynamicOptionsView
extends Composite {
    INativeSourceUnit src;
    String address;
    FilteredTableView ft;
    IdentityHashMap<IEOptimizerInfo, Boolean> changes = new IdentityHashMap();

    public DecompDynamicOptionsView(Composite parent, int style, INativeSourceUnit src, String address) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        if (src == null) {
            throw new NullPointerException();
        }
        this.src = src;
        this.address = address;
        this.ft = new FilteredTableView(this, 160, new String[]{S.s(591), S.s(268)});
        this.ft.setLayoutData(UIUtil.createGridDataFill(true, true));
        FilteredTableViewer ftv = new FilteredTableViewer(this.ft);
        ContentProviderListener p = new ContentProviderListener();
        ftv.setContentProvider(p);
        ftv.setCheckStateProvider(new DefaultCheckStateProvider(p));
        ftv.setLabelProvider(new DefaultCellLabelProvider(p));
        this.ft.addTableEventListener(p);
        ftv.setInput(src);
    }

    public IdentityHashMap<IEOptimizerInfo, Boolean> getChanges() {
        return this.changes;
    }

    class ContentProviderListener
    implements ITableEventListener,
    IFilteredTableContentProvider {
        private INativeSourceUnit input;

        ContentProviderListener() {
        }

        @Override
        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.input = (INativeSourceUnit)newInput;
        }

        @Override
        public void dispose() {
        }

        @Override
        public Object[] getElements(Object elt) {
            Assert.a(this.input == elt);
            if (this.input != null) {
                List<IEOptimizerInfo> optInfoList = this.input.getDecompiler().getOnDemandIROptimizers(DecompDynamicOptionsView.this.address);
                return optInfoList.toArray();
            }
            return ArrayUtil.NO_OBJECT;
        }

        @Override
        public Object[] getRowElements(Object row) {
            if (row instanceof IEOptimizerInfo) {
                IEOptimizerInfo e = (IEOptimizerInfo)row;
                String name = e.getInformation().getName();
                String description = e.getInformation().getDescription();
                return new Object[]{name, description};
            }
            return ArrayUtil.NO_OBJECT;
        }

        @Override
        public boolean isChecked(Object row) {
            if (row instanceof IEOptimizerInfo) {
                IEOptimizerInfo e = (IEOptimizerInfo)row;
                Boolean value = DecompDynamicOptionsView.this.changes.get(e);
                if (value == null) {
                    return e.isEnabled();
                }
                return value;
            }
            return false;
        }

        @Override
        public void onTableEvent(Object row, boolean isSelected, boolean isChecked) {
            if (row instanceof IEOptimizerInfo) {
                IEOptimizerInfo e = (IEOptimizerInfo)row;
                boolean original = e.isEnabled();
                if (original != isChecked) {
                    DecompDynamicOptionsView.this.changes.put(e, isChecked);
                } else {
                    DecompDynamicOptionsView.this.changes.remove(e);
                }
            }
        }
    }
}

