/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units;

import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.DataFrameView;
import com.pnfsoftware.jeb.rcpclient.extensions.export.ExportUtil;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractTableFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitView;
import com.pnfsoftware.jeb.rcpclient.util.DataFrame;
import com.pnfsoftware.jeb.util.format.Strings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractDataFrameFragment<T extends IUnit>
extends AbstractTableFragment<T, DataFrame.Row> {
    private DataFrame df;
    private DataFrameView dfv;

    public AbstractDataFrameFragment(Composite parent, int style, T unit, IRcpUnitView unitView, RcpClientContext context) {
        super(parent, style, unit, unitView, context);
    }

    public DataFrameView buildSimple(Composite parent, String ... labels) {
        this.df = new DataFrame(labels);
        this.initDataFrame(this.df);
        this.dfv = new DataFrameView(parent, this.df, false);
        return this.dfv;
    }

    protected abstract void initDataFrame(DataFrame var1);

    @Override
    public DataFrame.Row getSelectedRow() {
        IStructuredSelection sel = (IStructuredSelection)this.dfv.getTableViewer().getSelection();
        if (sel.isEmpty()) {
            return null;
        }
        Object o = sel.getFirstElement();
        if (o instanceof DataFrame.Row) {
            return (DataFrame.Row)o;
        }
        return null;
    }

    @Override
    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.dfv.getTableViewer().getSelection();
    }

    @Override
    public String exportElementToString(Object obj) {
        if (obj instanceof DataFrame.Row) {
            return this.exportRowToString((DataFrame.Row)obj);
        }
        return null;
    }

    protected String exportRowToString(DataFrame.Row obj) {
        Object[] row = this.dfv.getProvider().getRowElements(obj);
        return ExportUtil.buildCsvLine(this.dfv.getLabelProvider(), obj, row.length);
    }

    @Override
    public boolean isActiveItem(IItem item) {
        return item != null && this.getActiveItem() == item;
    }

    @Override
    public byte[] export() {
        return Strings.encodeUTF8(this.dfv.exportToString());
    }
}

