/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts;

import com.pnfsoftware.jeb.client.api.IUnitFragment;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnitAddress;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.android.IApkUnit;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ICodeObjectUnit;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.ShellActivationTracker;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPart;
import com.pnfsoftware.jeb.rcpclient.handlers.HandlerUtil;
import com.pnfsoftware.jeb.rcpclient.parts.PartManager;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitFragment;
import com.pnfsoftware.jeb.util.base.Couple;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;

public class AddressNavigator {
    private IRcpClientContext context;
    private StructuredViewer viewer;
    private IRcpUnitFragment nav;
    private IUnit managedUnit;

    public AddressNavigator(IRcpClientContext context, StructuredViewer viewer, IRcpUnitFragment nav, IUnit managedUnit) {
        this.context = context;
        this.viewer = viewer;
        this.nav = nav;
        this.managedUnit = managedUnit;
        this.setup();
    }

    private void setup() {
        if (this.viewer != null) {
            this.viewer.addDoubleClickListener(new IDoubleClickListener(){

                @Override
                public void doubleClick(DoubleClickEvent event) {
                    AddressNavigator.this.navigate(null, true);
                }
            });
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                @Override
                public void selectionChanged(SelectionChangedEvent event) {
                    AddressNavigator.this.context.refreshHandlersStates();
                }
            });
        }
    }

    public void forceNavigation(String address) {
        this.navigate(address, true);
    }

    private void navigate(String address, boolean createPartIfNotExist) {
        IUnitFragment fragment;
        UnitPartManager object;
        if (address == null && (address = this.nav.getActiveAddress()) == null) {
            return;
        }
        PartManager pman = this.context.getPartManager();
        TreeMap<Integer, List<Couple<IMPart, IRcpUnitFragment>>> toFocus = new TreeMap<Integer, List<Couple<IMPart, IRcpUnitFragment>>>();
        List<IMPart> parts = pman.getPartsForUnit(this.managedUnit, 1);
        for (IMPart iMPart : parts) {
            object = pman.getUnitPartManager(iMPart);
            if (object == null || (fragment = object.getActiveFragment()) == null || fragment == this.nav || fragment.getFocusPriority() == 0 || !this.isValidAddress((IRcpUnitFragment)fragment, address)) continue;
            this.add(toFocus, new Couple<IMPart, IUnitFragment>(iMPart, fragment));
        }
        if (!toFocus.isEmpty()) {
            if (this.focus(pman, toFocus, address, false)) {
                return;
            }
            toFocus.clear();
        }
        parts = pman.getPartsForUnitFamily(this.managedUnit, 1);
        for (IMPart iMPart : parts) {
            object = pman.getUnitPartManager(iMPart);
            if (object == null || (fragment = object.getActiveFragment()) == null || fragment == this.nav || object.getUnit() == this.managedUnit || fragment.getFocusPriority() == 0 || !this.isValidAddress((IRcpUnitFragment)fragment, address)) continue;
            this.add(toFocus, new Couple<IMPart, IUnitFragment>(iMPart, fragment));
        }
        if (!toFocus.isEmpty()) {
            if (this.focus(pman, toFocus, address, false)) {
                return;
            }
            toFocus.clear();
        }
        for (IMPart iMPart : parts) {
            object = pman.getUnitPartManager(iMPart);
            if (object == null) continue;
            IUnitFragment activeFragment = object.getActiveFragment();
            List<IRcpUnitFragment> fragments = this.getFragmentsDefaultFirst(object);
            for (IRcpUnitFragment fragment2 : fragments) {
                if (fragment2 == null || fragment2 == this.nav || fragment2 == activeFragment || fragment2.getFocusPriority() == 0 || !this.isValidAddress(fragment2, address)) continue;
                this.add(toFocus, new Couple<IMPart, IRcpUnitFragment>(iMPart, fragment2));
            }
        }
        if (!toFocus.isEmpty()) {
            if (this.focus(pman, toFocus, address, true)) {
                return;
            }
            toFocus.clear();
        }
        parts = pman.getPartsForUnitFamily(this.managedUnit, 2);
        parts.addAll(0, pman.restoreMissingParts(this.managedUnit));
        IUnit mainUnit = this.getMainUnitForAddress(address);
        if (mainUnit != null) {
            parts.addAll(0, pman.restoreMissingParts(mainUnit));
        }
        for (IMPart part : parts) {
            UnitPartManager object2 = pman.getUnitPartManager(part);
            if (object2 == null) continue;
            IUnitFragment selectedFragment = object2.getActiveFragment();
            if (selectedFragment != null && selectedFragment != this.nav && this.isValidAddress((IRcpUnitFragment)selectedFragment, address)) {
                this.add(toFocus, new Couple<IMPart, IUnitFragment>(part, selectedFragment));
            }
            List<IRcpUnitFragment> fragments = this.getFragmentsDefaultFirst(object2);
            for (IRcpUnitFragment fragment3 : fragments) {
                if (fragment3 == null || fragment3 == this.nav || fragment3 == selectedFragment || fragment3.getFocusPriority() == 0 || !this.isValidAddress(fragment3, address)) continue;
                this.add(toFocus, new Couple<IMPart, IRcpUnitFragment>(part, fragment3));
            }
        }
        if (!toFocus.isEmpty() && this.focus(pman, toFocus, address, true)) {
            return;
        }
        if (createPartIfNotExist && this.managedUnit instanceof ICodeObjectUnit) {
            List<INativeCodeUnit> list = UnitUtil.findChildrenByType(this.managedUnit, INativeCodeUnit.class, false);
            if (list != null && list.size() == 1) {
                INativeCodeUnit nativeUnit = list.get(0);
                if (!nativeUnit.isProcessed()) {
                    ShellActivationTracker tracker = UI.getShellTracker();
                    boolean r = UI.question(tracker.get(), "Process Unit?", "The native code of " + this.managedUnit.getName() + " is not processed.\n\nDo you want to process now?");
                    if (!r) {
                        return;
                    }
                    this.context.getTelemetry().record("navigateOpenUnit", "unitType", list.get(0).getFormatType());
                    if (!HandlerUtil.processUnit(tracker.get(), this.context, list.get(0), true)) {
                        return;
                    }
                }
                pman.create(nativeUnit, true);
                this.navigate(address, false);
            }
        } else {
            String string = this.nav.getActiveAddress(AddressConversionPrecision.COARSE);
            if (string != null && !address.equals(string)) {
                this.navigate(string, createPartIfNotExist);
            }
        }
    }

    private void add(TreeMap<Integer, List<Couple<IMPart, IRcpUnitFragment>>> toFocus, Couple<IMPart, IRcpUnitFragment> couple) {
        int priority = couple.getSecond().getFocusPriority();
        List<Couple<IMPart, IRcpUnitFragment>> list = toFocus.get(priority);
        if (list == null) {
            list = new ArrayList<Couple<IMPart, IRcpUnitFragment>>();
            toFocus.put(priority, list);
        }
        list.add(couple);
    }

    private boolean isValidAddress(IRcpUnitFragment fragment, String address) {
        return fragment.isValidActiveAddress(address, null);
    }

    private boolean focus(PartManager pman, TreeMap<Integer, List<Couple<IMPart, IRcpUnitFragment>>> toFocus, String address, boolean setActiveFragment) {
        IMPart activePart0 = pman.getActivePart();
        for (Map.Entry e : toFocus.descendingMap().entrySet()) {
            for (Couple e2 : (List)e.getValue()) {
                IMPart part = (IMPart)e2.getFirst();
                IRcpUnitFragment fragment = (IRcpUnitFragment)e2.getSecond();
                if (!fragment.setActiveAddress(address, null, false)) continue;
                if (pman.getActivePart() == activePart0) {
                    pman.focus(part);
                }
                if (setActiveFragment) {
                    pman.getUnitPartManager(part).setActiveFragment(fragment);
                }
                return true;
            }
        }
        return false;
    }

    private List<IRcpUnitFragment> getFragmentsDefaultFirst(UnitPartManager object) {
        List<IRcpUnitFragment> fragments = object.getFragments();
        for (int i = 0; i < fragments.size(); ++i) {
            if (!fragments.get(i).isDefaultFragment()) continue;
            fragments.add(0, fragments.remove(i));
            break;
        }
        return fragments;
    }

    private IUnit getMainUnitForAddress(String address) {
        if (this.managedUnit instanceof IApkUnit) {
            IApkUnit apkUnit = (IApkUnit)this.managedUnit;
            for (IUnit iUnit : apkUnit.getChildren()) {
                if (!(iUnit instanceof IDebuggerUnit)) continue;
                UnitAddress<ICodeUnit> newAddress = ((IDebuggerUnit)iUnit).convertToUnitAddress(address);
                if (newAddress != null) {
                    return newAddress.getUnit();
                }
                for (IUnit iUnit2 : iUnit.getChildren()) {
                    if (!(iUnit2 instanceof IDebuggerUnit) || (newAddress = ((IDebuggerUnit)iUnit2).convertToUnitAddress(address)) == null) continue;
                    return newAddress.getUnit();
                }
            }
        }
        return null;
    }
}

