/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.iviewers;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.client.events.JC;
import com.pnfsoftware.jeb.client.events.JebClientEvent;
import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.output.text.IItemStyleInfoProvider;
import com.pnfsoftware.jeb.core.output.text.StyleInfo;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.extensions.themes.IThemeChangeListener;
import com.pnfsoftware.jeb.rcpclient.extensions.themes.Theme;
import com.pnfsoftware.jeb.rcpclient.extensions.themes.ThemeManager;
import com.pnfsoftware.jeb.rcpclient.iviewers.Style;
import com.pnfsoftware.jeb.util.events.EventSource;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.IAsciiable;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class StyleManager
extends EventSource
implements IItemStyleInfoProvider,
IThemeChangeListener,
IAsciiable {
    private static final ILogger logger = GlobalLog.getLogger(StyleManager.class);
    private static Display display;
    private static UIAssetManager aman;
    private static Color black;
    private static Color white;
    private static Color red;
    private static Color green;
    private static Color darkgreen;
    private static Color blue;
    private static Color yellow;
    private static Color darkgray;
    private static Color darkred;
    private static Color cyan;
    private static Color c_lightblue;
    private static Color c_yellow;
    private static Color c_greenblue;
    private static Color c_orange;
    private static Color c_darkorange;
    private static Color c_darkgreen;
    private static Color c_brightgreen;
    private static Color c_purple;
    private static Color c_darkblue;
    private static Color c_lightgray;
    private static Color c_bluepurple;
    private static Color c_lightgreen;
    private static Color c_purple2;
    private static Color c_blue2;
    private static Color c_darkblue2;
    private static Color solarized_base03;
    private static Color solarized_base02;
    private static Color solarized_base01;
    private static Color solarized_base00;
    private static Color solarized_base0;
    private static Color solarized_base1;
    private static Color solarized_base2;
    private static Color solarized_base3;
    private static Color solarized_yellow;
    private static Color solarized_orange;
    private static Color solarized_red;
    private static Color solarized_magenta;
    private static Color solarized_violet;
    private static Color solarized_blue;
    private static Color solarized_cyan;
    private static Color solarized_green;
    public static final String SCHEME_DEFAULT = "default";
    public static final String SCHEME_DARK = "dark";
    private ThemeManager themeManager;
    private Map<String, ColorScheme> schemes = new HashMap<String, ColorScheme>();
    private String activeSchemeName = "default";

    public StyleManager(String styleData, ThemeManager themeManager) {
        this.activeSchemeName = SCHEME_DEFAULT;
        this.themeManager = themeManager;
        if (themeManager != null) {
            themeManager.addThemeChangeListener(this);
            if (themeManager.isDarkTheme()) {
                this.activeSchemeName = SCHEME_DARK;
            }
        }
        this.resetDefaults(false);
        if (styleData != null && !styleData.isEmpty() && !styleData.equals("<default>")) {
            this.decode(styleData);
        }
    }

    private StyleManager() {
    }

    public StyleManager clone() {
        StyleManager dst = new StyleManager();
        dst.themeManager = this.themeManager;
        dst.schemes = new HashMap<String, ColorScheme>(this.schemes.size());
        for (Map.Entry<String, ColorScheme> e : this.schemes.entrySet()) {
            dst.schemes.put(e.getKey(), new ColorScheme(e.getValue()));
        }
        return dst;
    }

    public void restore(StyleManager styleman, boolean notify) {
        this.themeManager = styleman.themeManager;
        this.schemes = new HashMap<String, ColorScheme>(styleman.schemes.size());
        for (Map.Entry<String, ColorScheme> e : styleman.schemes.entrySet()) {
            this.schemes.put(e.getKey(), new ColorScheme(e.getValue()));
        }
        if (notify) {
            this.onStyleChanged();
        }
    }

    public static Display getDisplay() {
        return display;
    }

    @Override
    public void onThemeChange(Theme theme) {
        String themeId = theme.getId();
        if ("theme.dark".equals(themeId)) {
            this.updateScheme(SCHEME_DARK);
        } else {
            this.updateScheme(SCHEME_DEFAULT);
        }
    }

    private boolean updateScheme(String name) {
        if (name == null) {
            name = SCHEME_DEFAULT;
        } else if (!name.equals(SCHEME_DEFAULT) && !name.equals(SCHEME_DARK)) {
            return false;
        }
        if (Strings.equals(name, this.activeSchemeName)) {
            return false;
        }
        this.getScheme(name);
        this.activeSchemeName = name;
        return true;
    }

    public List<String> getSchemeNames() {
        return Arrays.asList(SCHEME_DEFAULT, SCHEME_DARK);
    }

    private ColorScheme getScheme(String name) {
        ColorScheme themeStyles = this.schemes.get(name);
        if (themeStyles == null) {
            themeStyles = new ColorScheme();
            this.schemes.put(name, themeStyles);
        }
        return themeStyles;
    }

    private ColorScheme getActiveScheme() {
        return this.getScheme(this.activeSchemeName);
    }

    public void resetDefaults(boolean notify) {
        for (String t : this.getSchemeNames()) {
            ColorScheme ts = this.getScheme(t);
            ts.defstyle = null;
            ts.defastyle = null;
            ts.styles = new HashMap<ItemClassIdentifiers, Style>();
            ts.astyles = new HashMap<ItemClassIdentifiers, Style>();
            ts.defaultActiveLineColor = null;
            ts.defaultFontColor = null;
            ts.defaultActiveBgcolor = null;
            if (t.equals(SCHEME_DEFAULT)) {
                ts.defaultActiveLineColor = aman.getColor(230, 230, 250);
                ts.defaultFontColor = black;
                ts.defaultActiveBgcolor = c_yellow;
                ts.defstyle = new Style(this, ts.defaultFontColor);
                ts.defastyle = new Style(this, ts.defaultFontColor, ts.defaultActiveBgcolor);
                this.add(ts, ItemClassIdentifiers.DEFAULT, ts.defstyle, ts.defastyle);
                this.add(ts, ItemClassIdentifiers.ARTIFACT, new Style(this, blue));
                this.add(ts, ItemClassIdentifiers.INFO_USELESS, new Style(this, white, c_lightgray));
                this.add(ts, ItemClassIdentifiers.INFO_DEPRECATED, new Style(this, black, c_lightgray));
                this.add(ts, ItemClassIdentifiers.INFO_DEBUG, new Style(this, black, c_lightblue));
                this.add(ts, ItemClassIdentifiers.INFO_NORMAL, new Style(this, white, blue));
                this.add(ts, ItemClassIdentifiers.INFO_WARNING, new Style(this, white, c_darkorange));
                this.add(ts, ItemClassIdentifiers.INFO_ERROR, new Style(this, white, darkred));
                this.add(ts, ItemClassIdentifiers.INFO_DANGEROUS, new Style(this, c_yellow, red));
                this.add(ts, ItemClassIdentifiers.INFO_MALFORMED, new Style(this, white, black));
                this.add(ts, ItemClassIdentifiers.INFO_CORRUPT, new Style(this, white, black));
                this.add(ts, ItemClassIdentifiers.RESULT_SUCCESS, new Style(this, black, c_brightgreen));
                this.add(ts, ItemClassIdentifiers.RESULT_ERROR, new Style(this, black, c_orange));
                this.add(ts, ItemClassIdentifiers.TYPE_BYTE, null);
                this.add(ts, ItemClassIdentifiers.TYPE_SHORT, null);
                this.add(ts, ItemClassIdentifiers.TYPE_INTEGER, null);
                this.add(ts, ItemClassIdentifiers.TYPE_LONG, null);
                this.add(ts, ItemClassIdentifiers.TYPE_FLOAT, null);
                this.add(ts, ItemClassIdentifiers.TYPE_DOUBLE, null);
                this.add(ts, ItemClassIdentifiers.COMMENT, new Style(this, c_greenblue), new Style(this, c_greenblue));
                this.add(ts, ItemClassIdentifiers.ADDRESS, new Style(this, darkgray));
                this.add(ts, ItemClassIdentifiers.ADDRESS_SLACK, new Style(this, c_lightgray));
                this.add(ts, ItemClassIdentifiers.BYTECODE, new Style(this, darkgray), new Style(this, darkgray));
                this.add(ts, ItemClassIdentifiers.DIRECTIVE, new Style(this, c_purple, null, true, false));
                this.add(ts, ItemClassIdentifiers.KEYWORD, new Style(this, c_purple, null, true, false));
                this.add(ts, ItemClassIdentifiers.MNEMONIC, new Style(this, ts.defaultFontColor));
                this.add(ts, ItemClassIdentifiers.OPCODE, new Style(this, ts.defaultFontColor));
                this.add(ts, ItemClassIdentifiers.LABEL, new Style(this, darkgray));
                this.add(ts, ItemClassIdentifiers.LABEL_ALTERNATE, new Style(this, c_lightgray));
                this.add(ts, ItemClassIdentifiers.LABEL_OOR, new Style(this, darkgray, aman.getColor(0xEA9999)));
                this.add(ts, ItemClassIdentifiers.PARAMETER, new Style(this, ts.defaultFontColor));
                this.add(ts, ItemClassIdentifiers.IDENTIFIER, new Style(this, ts.defaultFontColor));
                this.add(ts, ItemClassIdentifiers.NUMBER, new Style(this, c_darkgreen, null, true, false));
                this.add(ts, ItemClassIdentifiers.CHARACTER, new Style(this, c_darkorange, null, true, false));
                this.add(ts, ItemClassIdentifiers.STRING, new Style(this, c_darkorange, null, true, false));
                this.add(ts, ItemClassIdentifiers.CLASS_NAME, new Style(this, blue));
                this.add(ts, ItemClassIdentifiers.FIELD_NAME, new Style(this, c_darkblue, null, false, true));
                this.add(ts, ItemClassIdentifiers.METHOD_NAME, new Style(this, c_darkblue));
                this.add(ts, ItemClassIdentifiers.EXTERNAL_CLASS_NAME, new Style(this, c_bluepurple));
                this.add(ts, ItemClassIdentifiers.EXTERNAL_FIELD_NAME, new Style(this, c_bluepurple));
                this.add(ts, ItemClassIdentifiers.EXTERNAL_METHOD_NAME, new Style(this, c_bluepurple));
                this.add(ts, ItemClassIdentifiers.PACKAGE_NAME, new Style(this, ts.defaultFontColor));
                this.add(ts, ItemClassIdentifiers.REGISTER, new Style(this, ts.defaultFontColor), new Style(this, black, c_lightgreen));
                this.add(ts, ItemClassIdentifiers.IMMEDIATE, new Style(this, darkgreen, null, true, false));
                this.add(ts, ItemClassIdentifiers.ANNOTATION, new Style(this, darkgray));
                this.add(ts, ItemClassIdentifiers.CODE_UNKNOWN, new Style(this, c_lightgray));
                this.add(ts, ItemClassIdentifiers.CODE_INSTRUCTIONS, new Style(this, blue));
                this.add(ts, ItemClassIdentifiers.CODE_ROUTINE, new Style(this, c_bluepurple));
                this.add(ts, ItemClassIdentifiers.CODE_DATA, new Style(this, c_darkgreen));
                this.add(ts, ItemClassIdentifiers.CODE_LIBRARY, new Style(this, cyan));
                this.add(ts, ItemClassIdentifiers.CODE_METADATA, new Style(this, yellow));
                this.add(ts, ItemClassIdentifiers.CODE_SLACK, new Style(this, black));
                this.add(ts, ItemClassIdentifiers.MARKUP_ELEMENT, new Style(this, blue));
                this.add(ts, ItemClassIdentifiers.MARKUP_ATTRIBUTE_NAME, new Style(this, ts.defaultFontColor));
                this.add(ts, ItemClassIdentifiers.MARKUP_ATTRIBUTE_VALUE, new Style(this, c_darkorange));
                this.add(ts, ItemClassIdentifiers.MARKUP_TEXT, new Style(this, c_greenblue));
                this.add(ts, ItemClassIdentifiers.MARKUP_COMMENT, new Style(this, c_greenblue));
                continue;
            }
            if (!t.equalsIgnoreCase(SCHEME_DARK)) continue;
            ts.defaultActiveLineColor = solarized_base02;
            ts.defaultFontColor = solarized_base2;
            ts.defaultActiveBgcolor = solarized_base03;
            ts.defstyle = new Style(this, ts.defaultFontColor);
            ts.defastyle = new Style(this, ts.defaultFontColor, ts.defaultActiveBgcolor);
            this.add(ts, ItemClassIdentifiers.DEFAULT, ts.defstyle, ts.defastyle);
            this.add(ts, ItemClassIdentifiers.ARTIFACT, new Style(this, c_blue2));
            this.add(ts, ItemClassIdentifiers.INFO_USELESS, new Style(this, white, c_lightgray));
            this.add(ts, ItemClassIdentifiers.INFO_DEPRECATED, new Style(this, ts.defaultFontColor, c_lightgray));
            this.add(ts, ItemClassIdentifiers.INFO_DEBUG, new Style(this, ts.defaultFontColor, c_lightblue));
            this.add(ts, ItemClassIdentifiers.INFO_NORMAL, new Style(this, white, c_blue2));
            this.add(ts, ItemClassIdentifiers.INFO_WARNING, new Style(this, white, c_darkorange));
            this.add(ts, ItemClassIdentifiers.INFO_ERROR, new Style(this, white, darkred));
            this.add(ts, ItemClassIdentifiers.INFO_DANGEROUS, new Style(this, c_yellow, red));
            this.add(ts, ItemClassIdentifiers.INFO_MALFORMED, new Style(this, white, black));
            this.add(ts, ItemClassIdentifiers.INFO_CORRUPT, new Style(this, white, black));
            this.add(ts, ItemClassIdentifiers.RESULT_SUCCESS, new Style(this, white, c_darkgreen));
            this.add(ts, ItemClassIdentifiers.RESULT_ERROR, new Style(this, white, c_darkorange));
            this.add(ts, ItemClassIdentifiers.TYPE_BYTE, null);
            this.add(ts, ItemClassIdentifiers.TYPE_SHORT, null);
            this.add(ts, ItemClassIdentifiers.TYPE_INTEGER, null);
            this.add(ts, ItemClassIdentifiers.TYPE_LONG, null);
            this.add(ts, ItemClassIdentifiers.TYPE_FLOAT, null);
            this.add(ts, ItemClassIdentifiers.TYPE_DOUBLE, null);
            this.add(ts, ItemClassIdentifiers.ADDRESS, new Style(this, solarized_base01));
            this.add(ts, ItemClassIdentifiers.ADDRESS_SLACK, new Style(this, c_lightgray));
            this.add(ts, ItemClassIdentifiers.COMMENT, new Style(this, darkgray));
            this.add(ts, ItemClassIdentifiers.BYTECODE, new Style(this, darkgray), new Style(this, darkgray));
            this.add(ts, ItemClassIdentifiers.DIRECTIVE, new Style(this, c_purple2, null, true, false));
            this.add(ts, ItemClassIdentifiers.KEYWORD, new Style(this, solarized_magenta, null, false, true));
            this.add(ts, ItemClassIdentifiers.MNEMONIC, new Style(this, ts.defaultFontColor));
            this.add(ts, ItemClassIdentifiers.OPCODE, new Style(this, ts.defaultFontColor));
            this.add(ts, ItemClassIdentifiers.LABEL, new Style(this, solarized_green, null, false, true));
            this.add(ts, ItemClassIdentifiers.LABEL_ALTERNATE, new Style(this, c_lightgray));
            this.add(ts, ItemClassIdentifiers.LABEL_OOR, new Style(this, darkgray, aman.getColor(0xEA9999)));
            this.add(ts, ItemClassIdentifiers.PARAMETER, new Style(this, ts.defaultFontColor));
            this.add(ts, ItemClassIdentifiers.IDENTIFIER, new Style(this, ts.defaultFontColor));
            this.add(ts, ItemClassIdentifiers.NUMBER, new Style(this, solarized_yellow, null, false, false));
            this.add(ts, ItemClassIdentifiers.CHARACTER, new Style(this, c_darkorange, null, true, false));
            this.add(ts, ItemClassIdentifiers.STRING, new Style(this, c_darkorange, null, true, false));
            this.add(ts, ItemClassIdentifiers.CLASS_NAME, new Style(this, solarized_base2, null, false, false));
            this.add(ts, ItemClassIdentifiers.FIELD_NAME, new Style(this, solarized_violet, null, false, false));
            this.add(ts, ItemClassIdentifiers.METHOD_NAME, new Style(this, solarized_green, null, false, false));
            this.add(ts, ItemClassIdentifiers.EXTERNAL_CLASS_NAME, new Style(this, c_bluepurple));
            this.add(ts, ItemClassIdentifiers.EXTERNAL_FIELD_NAME, new Style(this, c_bluepurple));
            this.add(ts, ItemClassIdentifiers.EXTERNAL_METHOD_NAME, new Style(this, c_bluepurple));
            this.add(ts, ItemClassIdentifiers.PACKAGE_NAME, new Style(this, ts.defaultFontColor));
            this.add(ts, ItemClassIdentifiers.REGISTER, new Style(this, solarized_base2), new Style(this, ts.defaultFontColor, solarized_blue));
            this.add(ts, ItemClassIdentifiers.IMMEDIATE, new Style(this, solarized_yellow, null, false, false));
            this.add(ts, ItemClassIdentifiers.ANNOTATION, new Style(this, darkgray));
            this.add(ts, ItemClassIdentifiers.CODE_UNKNOWN, new Style(this, solarized_base2));
            this.add(ts, ItemClassIdentifiers.CODE_INSTRUCTIONS, new Style(this, solarized_cyan));
            this.add(ts, ItemClassIdentifiers.CODE_ROUTINE, new Style(this, c_bluepurple));
            this.add(ts, ItemClassIdentifiers.CODE_DATA, new Style(this, solarized_green));
            this.add(ts, ItemClassIdentifiers.CODE_LIBRARY, new Style(this, cyan));
            this.add(ts, ItemClassIdentifiers.CODE_METADATA, new Style(this, yellow));
            this.add(ts, ItemClassIdentifiers.CODE_SLACK, new Style(this, solarized_base02));
            this.add(ts, ItemClassIdentifiers.MARKUP_ELEMENT, new Style(this, c_blue2));
            this.add(ts, ItemClassIdentifiers.MARKUP_ATTRIBUTE_NAME, new Style(this, ts.defaultFontColor));
            this.add(ts, ItemClassIdentifiers.MARKUP_ATTRIBUTE_VALUE, new Style(this, c_darkorange));
            this.add(ts, ItemClassIdentifiers.MARKUP_TEXT, new Style(this, c_greenblue));
            this.add(ts, ItemClassIdentifiers.MARKUP_COMMENT, new Style(this, c_greenblue));
        }
        if (notify) {
            this.onStyleChanged();
        }
    }

    void onStyleChanged() {
        this.notifyListeners(new JebClientEvent(JC.ItemStyleChanged));
    }

    private void add(ColorScheme currentThemeStyles, ItemClassIdentifiers classId, Style style, Style activeStyle) {
        currentThemeStyles.styles.put(classId, style);
        currentThemeStyles.astyles.put(classId, activeStyle);
    }

    private void add(ColorScheme currentThemeStyles, ItemClassIdentifiers classId, Style style) {
        Style activeStyle = null;
        if (style != null) {
            activeStyle = new Style(style);
            if (activeStyle.getBackgroungColor() == null) {
                activeStyle.bgcolor = currentThemeStyles.defaultActiveBgcolor;
            }
            if (!activeStyle.bold) {
                activeStyle.bold = style.bold;
            }
            if (!activeStyle.italic) {
                activeStyle.italic = style.italic;
            }
        }
        this.add(currentThemeStyles, classId, style, activeStyle);
    }

    public Style getStyle(ColorScheme scheme, ItemClassIdentifiers classId, boolean active) {
        return active ? this.getActiveStyle(scheme, classId) : this.getNormalStyle(scheme, classId);
    }

    public Style getNormalStyle(ColorScheme scheme, ItemClassIdentifiers classId) {
        Style r = scheme.styles.get((Object)classId);
        if (r == null) {
            r = scheme.defstyle;
        }
        return r;
    }

    public Style getActiveStyle(ColorScheme scheme, ItemClassIdentifiers classId) {
        Style r = scheme.astyles.get((Object)classId);
        if (r == null) {
            r = scheme.defastyle;
        }
        return r;
    }

    public Style getStyle(ItemClassIdentifiers classId, boolean active) {
        return this.getStyle(this.getActiveScheme(), classId, active);
    }

    public Style getNormalStyle(ItemClassIdentifiers classId) {
        return this.getNormalStyle(this.getActiveScheme(), classId);
    }

    public Style getActiveStyle(ItemClassIdentifiers classId) {
        return this.getActiveStyle(this.getActiveScheme(), classId);
    }

    public Color getOnCaretBackground() {
        return this.getActiveScheme().defaultActiveLineColor;
    }

    private void decode(String s) {
        Map<String, String> map = Strings.decodeMap(s);
        for (String themeName : map.keySet()) {
            String themeStylesData = map.get(themeName);
            ColorScheme r = this.decodeScheme(themeStylesData);
            this.schemes.put(themeName, r);
        }
    }

    private ColorScheme decodeScheme(String s) {
        ColorScheme themeStyles = new ColorScheme();
        for (String item : s.split("\\|")) {
            String[] tmp = item.split("=");
            if (tmp.length != 2) {
                logger.warn("%s: %s", S.s(403), Formatter.escapeString(item, true));
                continue;
            }
            if (tmp[0].equals("CURRENT_LINE_BGCOLOR")) {
                themeStyles.defaultActiveLineColor = Style.parseColor(display, tmp[1]);
                continue;
            }
            if (tmp[0].equals("DEFAULT_FONT_COLOR")) {
                themeStyles.defaultFontColor = Style.parseColor(display, tmp[1]);
                continue;
            }
            if (tmp[0].equals("DEFAULT_ACTIVE_BGCOLOR")) {
                themeStyles.defaultActiveBgcolor = Style.parseColor(display, tmp[1]);
                continue;
            }
            ItemClassIdentifiers t = null;
            try {
                t = ItemClassIdentifiers.valueOf(tmp[0]);
            }
            catch (Exception e) {
                logger.warn("%s: %s", S.s(404), Formatter.escapeString(tmp[0], true));
                continue;
            }
            String[] data = tmp[1].split(";");
            if (data.length != 2) {
                logger.warn("%s: %s", S.s(403), Formatter.escapeString(tmp[1], true));
                continue;
            }
            themeStyles.styles.put(t, new Style(this, data[0]));
            themeStyles.astyles.put(t, new Style(this, data[1]));
        }
        themeStyles.defstyle = themeStyles.styles.get((Object)ItemClassIdentifiers.DEFAULT);
        if (themeStyles.defstyle == null) {
            themeStyles.defstyle = new Style(this, display.getSystemColor(2));
            themeStyles.styles.put(ItemClassIdentifiers.DEFAULT, themeStyles.defstyle);
        }
        themeStyles.defastyle = themeStyles.astyles.get((Object)ItemClassIdentifiers.DEFAULT);
        if (themeStyles.defastyle == null) {
            themeStyles.defastyle = new Style(this, display.getSystemColor(2));
            themeStyles.astyles.put(ItemClassIdentifiers.DEFAULT, themeStyles.defastyle);
        }
        return themeStyles;
    }

    @Override
    public String encode() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (Map.Entry<String, ColorScheme> e : this.schemes.entrySet()) {
            ColorScheme themeStyles = e.getValue();
            StringBuilder sb = new StringBuilder();
            sb.append("CURRENT_LINE_BGCOLOR=").append(Style.colorToString(themeStyles.defaultActiveLineColor)).append("|");
            sb.append("DEFAULT_FONT_COLOR=").append(Style.colorToString(themeStyles.defaultFontColor)).append("|");
            sb.append("DEFAULT_ACTIVE_BGCOLOR=").append(Style.colorToString(themeStyles.defaultActiveBgcolor)).append("|");
            for (ItemClassIdentifiers t : ItemClassIdentifiers.values()) {
                sb.append((Object)t).append('=').append(this.getNormalStyle(themeStyles, t)).append(';').append(this.getActiveStyle(themeStyles, t)).append("|");
            }
            map.put(e.getKey(), sb.toString());
        }
        return Strings.encodeMap(map);
    }

    @Override
    public StyleInfo getStyle(ItemClassIdentifiers id) {
        Style s = this.getNormalStyle(id);
        if (s == null) {
            return null;
        }
        return new StyleInfo(s.getColorRgb(), s.getBackgroundColorRgb(), s.isBold(), s.isItalic());
    }

    static {
        aman = UIAssetManager.getInstance();
        display = aman.getDisplay();
        black = display.getSystemColor(2);
        white = display.getSystemColor(1);
        red = display.getSystemColor(3);
        green = display.getSystemColor(5);
        darkgreen = display.getSystemColor(6);
        blue = display.getSystemColor(9);
        yellow = display.getSystemColor(7);
        darkgray = display.getSystemColor(16);
        darkred = display.getSystemColor(4);
        cyan = display.getSystemColor(13);
        c_lightblue = aman.getColor(230, 230, 250);
        c_yellow = aman.getColor(255, 255, 128);
        c_greenblue = aman.getColor(63, 127, 95);
        c_orange = aman.getColor(255, 153, 0);
        c_darkorange = aman.getColor(255, 102, 0);
        c_darkgreen = aman.getColor(0, 138, 0);
        c_purple = aman.getColor(127, 0, 85);
        c_darkblue = aman.getColor(0, 0, 85);
        c_lightgray = aman.getColor(192, 192, 192);
        c_bluepurple = aman.getColor(140, 100, 255);
        c_lightgreen = aman.getColor(133, 224, 133);
        c_brightgreen = aman.getColor(153, 255, 153);
        c_purple2 = aman.getColor(14493799);
        c_blue2 = aman.getColor(18, 144, 195);
        c_darkblue2 = aman.getColor(102, 225, 248);
        solarized_base03 = aman.getColor(11062);
        solarized_base02 = aman.getColor(472642);
        solarized_base01 = aman.getColor(5795445);
        solarized_base00 = aman.getColor(6650755);
        solarized_base0 = aman.getColor(8623254);
        solarized_base1 = aman.getColor(9675169);
        solarized_base2 = aman.getColor(15657173);
        solarized_base3 = aman.getColor(16643811);
        solarized_yellow = aman.getColor(11897088);
        solarized_orange = aman.getColor(13323030);
        solarized_red = aman.getColor(14430767);
        solarized_magenta = aman.getColor(13842050);
        solarized_violet = aman.getColor(7107012);
        solarized_blue = aman.getColor(2526162);
        solarized_cyan = aman.getColor(2793880);
        solarized_green = aman.getColor(8755456);
    }

    static class ColorScheme {
        Style defstyle;
        Style defastyle;
        Map<ItemClassIdentifiers, Style> styles;
        Map<ItemClassIdentifiers, Style> astyles;
        Color defaultActiveLineColor;
        Color defaultFontColor;
        Color defaultActiveBgcolor;

        ColorScheme() {
            this.styles = new HashMap<ItemClassIdentifiers, Style>();
            this.astyles = new HashMap<ItemClassIdentifiers, Style>();
        }

        ColorScheme(ColorScheme s) {
            this.defstyle = s.defstyle;
            this.defastyle = s.defastyle;
            this.styles = new HashMap<ItemClassIdentifiers, Style>(s.styles);
            this.astyles = new HashMap<ItemClassIdentifiers, Style>(s.astyles);
            this.defaultActiveLineColor = s.defaultActiveLineColor;
            this.defaultFontColor = s.defaultFontColor;
            this.defaultActiveBgcolor = s.defaultActiveBgcolor;
        }
    }
}

