/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.nativeactions;

import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.rcpclient.handlers.nativeactions.NativeCodeBaseHandler;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;

public class ActionNavigateToHighLevelEntryPointHandler
extends NativeCodeBaseHandler {
    public ActionNavigateToHighLevelEntryPointHandler() {
        super("gotoHighLevelEntryPoint", "Go to high-level entry-point", "The high-level entry-point is optionnaly identified and corresponds to a program's main() routine", null, 0);
    }

    @Override
    public boolean canExecute() {
        if (this.part == null) {
            return false;
        }
        INativeCodeUnit<?> pbcu = this.getNativeCodeUnit(this.part);
        return pbcu != null && pbcu.getHighLevelEntryPointAddress() != -1L;
    }

    @Override
    public void execute() {
        if (this.part == null) {
            return;
        }
        UnitPartManager upm = this.context.getPartManager().getUnitPartManager(this.part);
        if (upm == null) {
            return;
        }
        INativeCodeUnit<?> pbcu = this.getNativeCodeUnit(this.part);
        if (pbcu == null) {
            return;
        }
        long a = pbcu.getHighLevelEntryPointAddress();
        if (a == -1L) {
            return;
        }
        String address = String.format("%Xh", a);
        upm.setActiveAddress(address, null, true);
    }
}

