/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.actions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.client.api.IUnitFragment;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.IDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.ISourceUnit;
import com.pnfsoftware.jeb.core.util.DecompilerHelper;
import com.pnfsoftware.jeb.rcpclient.GlobalPosition;
import com.pnfsoftware.jeb.rcpclient.JebAddress;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.PropertiesSetterDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPart;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPartManager;
import com.pnfsoftware.jeb.rcpclient.handlers.HandlerUtil;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import com.pnfsoftware.jeb.rcpclient.parts.PartManager;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import com.pnfsoftware.jeb.rcpclient.parts.units.TextFragment;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ActionDecompileHandler
extends JebBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(ActionDecompileHandler.class);

    public ActionDecompileHandler() {
        super("decompile", S.s(475), null, "eclipse/debugt_obj.png");
        this.setAccelerator(9);
    }

    @Override
    public boolean canExecute() {
        JebAddress address;
        if (this.part == null) {
            return false;
        }
        IMPartManager object = this.part.getManager();
        if (this.isDisableHandlers(this.part)) {
            return false;
        }
        return object instanceof UnitPartManager && (address = ((UnitPartManager)object).getActiveAddress(AddressConversionPrecision.COARSE)) != null && address.getAddress() != null;
    }

    @Override
    public void execute() {
        ActionDecompileHandler.execute(this.context, this.getShell(), this.part, false);
    }

    static void execute(RcpClientContext context, Shell shell, IMPart part, boolean options) {
        UnitPartManager p;
        context.getTelemetry().record("actionDecompile");
        if (part == null) {
            return;
        }
        IMPartManager object = part.getManager();
        if (!(object instanceof UnitPartManager)) {
            return;
        }
        UnitPartManager unitPart = (UnitPartManager)object;
        IUnit unit = unitPart.getUnit();
        IUnitFragment activeFragment = unitPart.getActiveFragment();
        if (activeFragment == null) {
            logger.i("No active view", new Object[0]);
            return;
        }
        String address = activeFragment.getActiveAddress();
        if (address == null) {
            logger.info("Cannot determine where to decompile", new Object[0]);
            return;
        }
        IDecompilerUnit decompiler = DecompilerHelper.getDecompiler(unit);
        if (!(decompiler != null || unit.getParent() instanceof IUnit && ((IUnit)unit.getParent()).getName().equals("decompiler"))) {
            StringBuilder msg = new StringBuilder("Your build does not provide decompilation support for this type of code.\n\nThe decompilers available with your license type are:\n");
            msg.append(Strings.join(", ", DecompilerHelper.getAvailableDecompilerNames(context.getEnginesContext())));
            if (!UI.popupOptional(shell, 0, "Decompiler not available", msg.toString(), "dlgDecompilerNotAvailable")) {
                logger.warn("No decompiler available", new Object[0]);
            }
            return;
        }
        logger.i("decompiler= %s", decompiler);
        PartManager pman = context.getPartManager();
        IMPart targetPart = null;
        GlobalPosition pos0 = context.getViewManager().getCurrentGlobalPosition();
        if (decompiler != null) {
            List<UnitPartManager> targetParts;
            ISourceUnit c;
            try {
                c = decompiler.getDecompiledUnit(address);
            }
            catch (ClassCastException e) {
                MessageDialog.openError(shell, S.s(304), "It seems that your JDB2 database contains inconsistencies, which makes it incompatible with this version of JEB.\n\nWe apologize for this inconvenience.");
                if (context.isDevelopmentMode()) {
                    logger.catching(e);
                }
                return;
            }
            if (c == null) {
                if (options) {
                    PropertiesSetterDialog dlg = new PropertiesSetterDialog(shell, "Decompilation Options");
                    dlg.setUnit(decompiler, true, true);
                    dlg.setDescription("Customize the decompiler options:");
                    if (!dlg.open().booleanValue()) {
                        return;
                    }
                }
                logger.info("Decompiling at %s", address);
                c = HandlerUtil.decompileAsync(shell, context, decompiler, address);
                if (c == null) {
                    return;
                }
            }
            if ((targetParts = pman.getPartManagersForUnit(c)).isEmpty()) {
                targetPart = pman.create(c, true).get(0);
                pman.setOriginator(targetPart, part);
            } else {
                targetPart = pman.getFirstPartForUnit(c);
                pman.setOriginator(targetPart, part);
                pman.focus(targetPart);
            }
        } else {
            IUnitCreator parent = unit.getParent();
            if (!(parent instanceof IUnit)) {
                return;
            }
            if (!((parent = ((IUnit)parent).getParent()) instanceof IUnit)) {
                return;
            }
            IUnit disassembler = (IUnit)parent;
            List<IMPart> potentialOriginParts = pman.getPartsForUnit(disassembler);
            if (potentialOriginParts.isEmpty()) {
                targetPart = pman.create(disassembler, true).get(0);
            } else {
                targetPart = ActionDecompileHandler.findFirstPartWithTextFragment(pman, potentialOriginParts);
                if (targetPart != null) {
                    pman.setOriginator(targetPart, part);
                    pman.focus(targetPart);
                } else {
                    targetPart = pman.create(disassembler, false).get(0);
                }
            }
        }
        if (targetPart != null && (p = pman.getUnitPartManager(targetPart)) != null) {
            p.setActiveAddress(address, null, false);
        }
        if (pos0 != null) {
            context.getViewManager().recordGlobalPosition(pos0);
        }
    }

    static IMPart findFirstPartWithTextFragment(PartManager pman, List<IMPart> parts) {
        for (IMPart part : parts) {
            UnitPartManager p = pman.getUnitPartManager(part);
            if (Lists.newArrayList((Iterable)Iterables.filter(p.getFragments(), TextFragment.class)).isEmpty()) continue;
            return part;
        }
        return null;
    }
}

