/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.ui;

import com.pnfsoftware.jeb.rcpclient.extensions.SwtRegistry;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.concurrent.ThreadUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class Toast {
    private static final ILogger logger = GlobalLog.getLogger(Toast.class);
    private static final String TEXTPAD = "  ";
    private static final int MARGIN = 70;
    private int state;
    private Display display;
    private Composite topLevelContainer;
    private List<Couple<Control, PaintListener>> paintListeners = new ArrayList<Couple<Control, PaintListener>>();
    private Point toastSize;
    private Rectangle toastRectangle;
    private int position;
    private long duration;
    private String text;
    private Font font;
    private Color fgcolor;
    private Color bgcolor;
    final PaintListener paintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            if (!(e.widget instanceof Control)) {
                return;
            }
            Control ctl = (Control)e.widget;
            GC gc = e.gc;
            Rectangle r = e.display.map((Control)Toast.this.topLevelContainer, ctl, Toast.this.toastRectangle);
            Toast.this.prepareGC(gc);
            gc.drawText(Toast.this.text, r.x, r.y);
        }
    };

    public Toast(Composite topLevelContainer, String text) {
        this.topLevelContainer = topLevelContainer;
        this.display = topLevelContainer.getDisplay();
        this.setText(text);
        this.position = 1024;
        this.duration = 1500L;
    }

    public static Toast normal(Composite topLevelContainer, String text) {
        return new Toast(topLevelContainer, text);
    }

    public static Toast inverted(Composite topLevelContainer, String text) {
        return new Toast(topLevelContainer, text).setForegroundColor(topLevelContainer.getBackground()).setBackgroundColor(topLevelContainer.getForeground());
    }

    public static Toast urgent(Composite topLevelContainer, String text) {
        return new Toast(topLevelContainer, text).setForegroundColor(topLevelContainer.getDisplay().getSystemColor(3)).setBackgroundColor(topLevelContainer.getDisplay().getSystemColor(7)).setFont(SwtRegistry.getInstance().getFont(topLevelContainer.getFont(), null, (Integer)1));
    }

    public Display getDisplay() {
        return this.display;
    }

    public Composite getTopLevelContainer() {
        return this.topLevelContainer;
    }

    private void prepareGC(GC gc) {
        if (this.bgcolor != null) {
            gc.setBackground(this.bgcolor);
        }
        if (this.fgcolor != null) {
            gc.setForeground(this.fgcolor);
        }
        if (this.font != null) {
            gc.setFont(this.font);
        }
    }

    private void verifyState() {
        if (this.state != 0) {
            throw new IllegalStateException();
        }
    }

    public void show() {
        this.verifyState();
        this.state = 1;
        this.topLevelContainer.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Toast.this.updateToastBounds();
            }
        });
        this.updateToastBounds();
        this.prepare((Control)this.topLevelContainer);
        ThreadUtil.start(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(Toast.this.duration);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Toast.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Toast.this.dispose();
                    }
                });
            }
        });
        this.topLevelContainer.redraw();
    }

    public Toast setPosition(int position) {
        this.position = position;
        return this;
    }

    public Toast setDuration(long duration) {
        this.verifyState();
        this.duration = duration;
        return this;
    }

    public Toast setText(String text) {
        this.verifyState();
        this.text = TEXTPAD + Strings.safe(text) + TEXTPAD;
        return this;
    }

    public Toast setFont(Font font) {
        this.verifyState();
        this.font = font;
        return this;
    }

    public Toast setForegroundColor(Color fgcolor) {
        this.verifyState();
        this.fgcolor = fgcolor;
        return this;
    }

    public Toast setBackgroundColor(Color bgcolor) {
        this.verifyState();
        this.bgcolor = bgcolor;
        return this;
    }

    private void updateToastBounds() {
        if (this.toastSize == null) {
            GC gc = new GC((Drawable)this.topLevelContainer);
            try {
                this.prepareGC(gc);
                this.toastSize = gc.textExtent(this.text);
            }
            finally {
                gc.dispose();
            }
        }
        Rectangle containerBounds = this.topLevelContainer.getClientArea();
        int toastX = (containerBounds.width - this.toastSize.x) / 2;
        int toastY = this.position == 0x1000000 ? (containerBounds.height - this.toastSize.y) / 2 : (this.position == 128 ? 70 : containerBounds.height - this.toastSize.y - 70);
        this.toastRectangle = new Rectangle(toastX, toastY, this.toastSize.x, this.toastSize.y);
    }

    private void prepare(Control ctl) {
        ctl.addPaintListener(this.paintListener);
        this.paintListeners.add(new Couple<Control, PaintListener>(ctl, this.paintListener));
        if (ctl instanceof Composite) {
            for (Control c : ((Composite)ctl).getChildren()) {
                this.prepare(c);
            }
        }
    }

    private void redrawAll() {
        if (this.topLevelContainer != null) {
            this.redraw((Control)this.topLevelContainer);
        } else {
            for (Shell shell : this.display.getShells()) {
                this.redraw((Control)shell);
            }
        }
    }

    private void redraw(Control ctl) {
        Point size = ctl.getSize();
        ctl.redraw(0, 0, size.x, size.y, true);
        ctl.update();
    }

    private void dispose() {
        for (Couple<Control, PaintListener> e : this.paintListeners) {
            Control ctl = e.getFirst();
            PaintListener listener = e.getSecond();
            if (ctl.isDisposed()) continue;
            ctl.removePaintListener(listener);
        }
        this.redrawAll();
    }
}

