/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.graph.model;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.core.exceptions.InterruptionException;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.model.E;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.model.V;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.collect.MultiList;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public class Digraph {
    private static final ILogger logger = GlobalLog.getLogger(Digraph.class);
    private boolean done;
    private List<V> vertices = new ArrayList<V>();
    private TreeMap<Integer, V> vertexmap = new TreeMap();
    private List<E> edges = new ArrayList<E>();
    private MultiList<E> edgefrommap = new MultiList();
    private MultiList<E> edgetomap = new MultiList();
    private List<Set<Integer>> reachabilityIndices;

    public static Digraph create() {
        return new Digraph();
    }

    public List<V> copyOfVertices() {
        ArrayList<V> r = new ArrayList<V>(this.getVertexCount());
        for (V v : this.vertices) {
            r.add(v.clone());
        }
        return r;
    }

    public List<E> copyOfEdges() {
        ArrayList<E> r = new ArrayList<E>(this.getEdgeCount());
        for (E e : this.edges) {
            r.add(e.clone());
        }
        return r;
    }

    public int getVertexCount() {
        return this.vertices.size();
    }

    public List<V> getVertices() {
        return this.vertices;
    }

    public V getVertex(int id) {
        return this.vertexmap.get(id);
    }

    public V getVertexByIndex(int index) {
        return this.vertices.get(index);
    }

    public String getVertexLabel(int id) {
        return this.vertexmap.get(id).getLabel();
    }

    public void setVertexLabel(int id, String label) {
        this.vertexmap.get(id).setLabel(label);
    }

    /*
     * WARNING - void declaration
     */
    public void removeVertex(V v, boolean reconnectEdges) {
        void var5_12;
        Assert.a(this.vertices.indexOf(v) == v.index);
        ArrayList<Integer> dstids = new ArrayList<Integer>();
        for (E e2 : this.edgefrommap.get(v.index)) {
            dstids.add(e2.getDst().id);
        }
        ArrayList<Integer> srcids = new ArrayList<Integer>();
        for (E e3 : this.edgetomap.get(v.index)) {
            srcids.add(e3.getSrc().id);
        }
        for (E e0 : this.edgetomap.get(v.index)) {
            this.edgefrommap.removeMultipleElements(e0.src.index, e -> e.dst == v);
        }
        for (E e0 : this.edgefrommap.get(v.index)) {
            this.edgetomap.removeMultipleElements(e0.dst.index, e -> e.src == v);
        }
        for (E e3 : this.edgefrommap.remove(v.index)) {
            Assert.a(this.edges.remove(e3), "Edge " + e3 + " is not present");
        }
        for (E e3 : this.edgetomap.remove(v.index)) {
            Assert.a(this.edges.remove(e3), "Edge " + e3 + " is not present");
        }
        Assert.a(this.vertexmap.remove(v.id) == v);
        Assert.a(this.vertices.remove(v.index) == v);
        int n = v.index;
        while (var5_12 < this.vertices.size()) {
            --this.vertices.get((int)var5_12).index;
            ++var5_12;
        }
        if (reconnectEdges) {
            Iterator iterator = srcids.iterator();
            while (iterator.hasNext()) {
                int srcId = (Integer)iterator.next();
                Iterator iterator2 = dstids.iterator();
                while (iterator2.hasNext()) {
                    int dstId = (Integer)iterator2.next();
                    if (this.getEdge(srcId, dstId) != null) continue;
                    this.addEdge(srcId, dstId, null);
                }
            }
        }
        this.verify();
    }

    private void verify() {
        Assert.a(this.vertices.size() == this.vertexmap.size());
        Assert.a(this.edgefrommap.values().size() == this.edges.size(), this.edgefrommap.values().size() + " != " + this.edges.size());
        Assert.a(this.edgetomap.values().size() == this.edges.size(), this.edgetomap.values().size() + " != " + this.edges.size());
        if (Licensing.isReleaseBuild()) {
            return;
        }
        HashSet<Integer> idset = new HashSet<Integer>();
        int index = 0;
        for (V v : this.vertices) {
            Assert.a(v.index == index, "Unexpected index");
            ++index;
            Assert.a(this.vertexmap.get(v.id) == v, "Vertex is missing");
            Assert.a(idset.add(v.id), "Duplicate id: " + v.id);
        }
        for (E e : this.edges) {
            Assert.a(this.vertices.contains(e.src));
            Assert.a(this.vertices.contains(e.dst), "Vertex id=" + e.dst.id + " was not found");
            this.edgefrommap.get(e.src.id).contains(e);
            this.edgetomap.get(e.dst.id).contains(e);
        }
    }

    public int getEdgeCount() {
        return this.edges.size();
    }

    public List<E> getEdges() {
        return this.edges;
    }

    public E getEdge(int index) {
        return this.edges.get(index);
    }

    public void removeEdge(E e) {
        Assert.a(this.edges.remove(e));
        Assert.a(this.edgefrommap.removeElement(e.src.index, e));
        Assert.a(this.edgetomap.removeElement(e.dst.index, e));
    }

    public void removeEdge(int index) {
        E e = this.edges.remove(index);
        Assert.a(this.edgefrommap.removeElement(e.src.index, e));
        Assert.a(this.edgetomap.removeElement(e.dst.index, e));
    }

    public E getEdge(int srcId, int dstId) {
        V src = this.vertexmap.get(srcId);
        Assert.a(src != null, "Source vertex " + srcId + " does not exist");
        int srcIndex = src.index;
        for (E e : this.getEdgesFrom(srcIndex)) {
            if (e.dst.id != dstId) continue;
            return e;
        }
        return null;
    }

    List<E> getEdgesFrom(int srcIndex) {
        return this.edgefrommap.get(srcIndex);
    }

    List<E> getEdgesTo(int dstIndex) {
        return this.edgetomap.get(dstIndex);
    }

    public Digraph v(int id, Double weight, String label) {
        this.addVertex(id, weight, label, true);
        return this;
    }

    public Digraph v(int id, Double weight) {
        return this.v(id, weight, null);
    }

    public Digraph v(int id) {
        return this.v(id, null, null);
    }

    private V addVertex(int id, Double weight, String label, boolean failOnDup) {
        this.verifyNotDone();
        V v = this.vertexmap.get(id);
        if (v != null) {
            if (failOnDup) {
                throw new IllegalArgumentException("Vertex id " + id + " is already in use");
            }
        } else {
            v = new V(this.vertices.size(), id, weight, label);
            this.vertices.add(v);
            this.vertexmap.put(id, v);
        }
        return v;
    }

    private E addEdge(int srcId, int dstId, Double weight) {
        this.verifyNotDone();
        boolean checkDup = true;
        V a = this.vertexmap.get(srcId);
        if (a == null) {
            a = this.addVertex(srcId, null, null, true);
            checkDup = false;
        }
        V b0 = a;
        if (dstId != srcId && (b0 = this.vertexmap.get(dstId)) == null) {
            b0 = this.addVertex(dstId, null, null, true);
            checkDup = false;
        }
        V b = b0;
        if (checkDup) {
            Assert.a(this.edgefrommap.findFirstElement(a.index, e -> e.dst == b) == null, String.format("Edge %d->%d already exists", srcId, dstId));
        }
        E e2 = new E(a, b, weight);
        this.edges.add(e2);
        this.edgefrommap.put(a.index, e2);
        this.edgetomap.put(b.index, e2);
        return e2;
    }

    public Digraph e(int srcId, int dstId, Double weight) {
        this.addEdge(srcId, dstId, weight);
        return this;
    }

    public Digraph e(int srcId, int dstId) {
        return this.e(srcId, dstId, null);
    }

    public Digraph done() {
        this.verify();
        return this;
    }

    private void verifyNotDone() {
        if (this.done) {
            throw new IllegalStateException();
        }
    }

    public void resetEdgeBetweennessScores() {
        for (E e : this.edges) {
            e.ebscore = 0.0;
        }
        for (V v : this.vertices) {
            v.vcscore = 0.0;
        }
    }

    public List<Integer> computeEdgeBetweenness() {
        this.resetEdgeBetweennessScores();
        for (int i = 0; i < this.getVertexCount(); ++i) {
            this.computeEdgeBetweennessFromSingleNode(i);
            for (E e : this.edges) {
                if (e.score == null) continue;
                E e2 = e;
                Double.valueOf(e2.ebscore + e.score);
                e2.ebscore = e2.ebscore;
            }
            for (V v : this.vertices) {
                if (v.score == null) continue;
                V v2 = v;
                Double.valueOf(v2.vcscore + v.score);
                v2.vcscore = v2.vcscore;
            }
            if (!Thread.interrupted()) continue;
            throw new InterruptionException();
        }
        List<E> edges2 = this.copyOfEdges();
        Collections.sort(edges2, (o1, o2) -> -Double.compare(o1.ebscore, o2.ebscore));
        StringBuilder sb = new StringBuilder();
        for (E e : edges2) {
            sb.append(String.format("%s>%s:%.1f,", e.src, e.dst, e.ebscore));
        }
        logger.i("* final EB scores: %s", sb.toString());
        List<V> list = this.copyOfVertices();
        Collections.sort(list, (o1, o2) -> -Double.compare(o1.vcscore, o2.vcscore));
        sb = new StringBuilder();
        for (V v : list) {
            sb.append(String.format("%s:%.1f,", v, v.vcscore));
        }
        logger.i("* final VC scores: %s", sb.toString());
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.getEdgeCount());
        for (int i = 0; i < this.getEdgeCount(); ++i) {
            arrayList.add(i);
        }
        Collections.sort(arrayList, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return -Double.compare(((E)((Digraph)Digraph.this).edges.get((int)o1.intValue())).ebscore, ((E)((Digraph)Digraph.this).edges.get((int)o2.intValue())).ebscore);
            }
        });
        return arrayList;
    }

    public List<Integer> getEdgeIndexesByDescendingBetweenness() {
        ArrayList<Integer> r = new ArrayList<Integer>(this.getEdgeCount());
        for (int i = 0; i < this.getEdgeCount(); ++i) {
            r.add(i);
        }
        r.sort((a, b) -> -Double.compare(this.edges.get((int)a.intValue()).ebscore, this.edges.get((int)b.intValue()).ebscore));
        return r;
    }

    public List<Integer> getVertexIndexesByDescendingCentrality() {
        ArrayList<Integer> r = new ArrayList<Integer>(this.getVertexCount());
        for (int i = 0; i < this.getVertexCount(); ++i) {
            r.add(i);
        }
        r.sort((a, b) -> -Double.compare(this.vertices.get((int)a.intValue()).vcscore, this.vertices.get((int)b.intValue()).vcscore));
        return r;
    }

    private void computeEdgeBetweennessFromSingleNode(int startNodeIndex) {
        for (E e : this.edges) {
            e.score = null;
        }
        for (V v : this.vertices) {
            v.score = 0.0;
        }
        int[] vPathCounts = new int[this.getVertexCount()];
        vPathCounts[startNodeIndex] = 1;
        ArrayList levels = new ArrayList();
        HashSet seen = new HashSet();
        ArrayList<Integer> startIndexes = new ArrayList<Integer>();
        startIndexes.add(startNodeIndex);
        HashSet<Integer> nextStartIndexes = new HashSet<Integer>();
        while (!startIndexes.isEmpty()) {
            ArrayList<E> level = new ArrayList<E>();
            Iterator<Object> iterator = startIndexes.iterator();
            while (iterator.hasNext()) {
                int srcIndex = (Integer)iterator.next();
                for (E edge : this.getEdgesFrom(srcIndex)) {
                    int dstIndex = edge.dst.index;
                    if (seen.contains(dstIndex)) continue;
                    level.add(edge);
                    nextStartIndexes.add(dstIndex);
                    int n = dstIndex;
                    vPathCounts[n] = vPathCounts[n] + vPathCounts[srcIndex];
                }
            }
            if (!level.isEmpty()) {
                levels.add(level);
            }
            seen.addAll(nextStartIndexes);
            startIndexes = new ArrayList(nextStartIndexes);
            nextStartIndexes.clear();
            if (!Thread.interrupted()) continue;
            throw new InterruptionException();
        }
        for (int i = levels.size() - 1; i >= 0; --i) {
            List level = (List)levels.get(i);
            for (int j = 0; j < level.size(); ++j) {
                E e0 = (E)level.get(j);
                if (e0.score != null) continue;
                ArrayList<E> coll = new ArrayList<E>();
                coll.add(e0);
                V dst = e0.dst;
                for (int k = j + 1; k < level.size(); ++k) {
                    E e = (E)level.get(k);
                    if (e.dst != dst) continue;
                    coll.add(e);
                }
                double total = 0.0;
                for (E e : coll) {
                    total += (double)vPathCounts[e.src.index];
                }
                double s = 1.0 + this.vertices.get((int)dst.index).score;
                for (E e : coll) {
                    double score = s * ((double)vPathCounts[e.src.index] / total);
                    e.score = score;
                    V v = this.vertices.get(e.src.index);
                    Double.valueOf(v.score + score);
                    v.score = v.score;
                }
            }
            if (!Thread.interrupted()) continue;
            throw new InterruptionException();
        }
        StringBuilder sb = new StringBuilder();
        for (E e : this.edges) {
            if (e.score == null) continue;
            sb.append(String.format("%s>%s:%.1f,", e.src, e.dst, e.score));
        }
    }

    public boolean isWeaklyConnected() {
        int startNodeIndex = 0;
        HashSet<Integer> startIndexes = new HashSet<Integer>();
        startIndexes.add(startNodeIndex);
        HashSet<Integer> seen = new HashSet<Integer>(startIndexes);
        while (!startIndexes.isEmpty()) {
            HashSet<Integer> nextStartIndexes = new HashSet<Integer>();
            Iterator iterator = startIndexes.iterator();
            while (iterator.hasNext()) {
                int index;
                int startIndex = (Integer)iterator.next();
                for (E edge : this.getEdgesFrom(startIndex)) {
                    index = edge.dst.index;
                    if (seen.contains(index)) continue;
                    nextStartIndexes.add(index);
                    seen.add(index);
                }
                for (E edge : this.getEdgesTo(startIndex)) {
                    index = edge.src.index;
                    if (seen.contains(index)) continue;
                    nextStartIndexes.add(index);
                    seen.add(index);
                }
            }
            startIndexes = nextStartIndexes;
        }
        return seen.size() == this.getVertexCount();
    }

    public List<Digraph> getWeaklyConnectedComponents() {
        ArrayList<Digraph> gcomponents = new ArrayList<Digraph>();
        HashSet<Integer> left = new HashSet<Integer>(this.getVertexCount());
        for (int i = 0; i < this.getVertexCount(); ++i) {
            left.add(i);
        }
        int round = 0;
        while (!left.isEmpty()) {
            Iterator iterator;
            HashSet startIndexes = new HashSet();
            startIndexes.add(left.iterator().next());
            HashSet<Integer> seen = new HashSet<Integer>(startIndexes);
            while (!startIndexes.isEmpty()) {
                HashSet<Integer> nextStartIndexes = new HashSet<Integer>();
                iterator = startIndexes.iterator();
                while (iterator.hasNext()) {
                    int index;
                    int startIndex = (Integer)iterator.next();
                    for (E edge : this.getEdgesFrom(startIndex)) {
                        index = edge.dst.index;
                        if (seen.contains(index)) continue;
                        nextStartIndexes.add(index);
                        seen.add(index);
                    }
                    for (E edge : this.getEdgesTo(startIndex)) {
                        index = edge.src.index;
                        if (seen.contains(index)) continue;
                        nextStartIndexes.add(index);
                        seen.add(index);
                    }
                }
                startIndexes = nextStartIndexes;
            }
            if (round == 0 && left.equals(seen)) {
                gcomponents.add(this);
                break;
            }
            Digraph gs = Digraph.create();
            iterator = seen.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                V vertex = this.vertices.get(index);
                gs.addVertex(vertex.id, vertex.weight, vertex.label, false);
                for (E e : this.getEdgesFrom(index)) {
                    gs.e(e.src.id, e.dst.id, e.weight);
                }
            }
            gcomponents.add(gs.done());
            left.removeAll(seen);
            ++round;
        }
        return gcomponents;
    }

    public String toString() {
        return String.format("V=%s:E=%s", this.vertices, this.edges);
    }

    private void computeTransitiveClosure() {
        int cnt = this.getVertexCount();
        this.reachabilityIndices = new ArrayList<Set<Integer>>(cnt);
        for (int i = 0; i < cnt; ++i) {
            HashSet seen = new HashSet();
            ArrayList<Integer> startIndices = new ArrayList<Integer>();
            HashSet<Integer> nextStartIndexes = new HashSet<Integer>();
            startIndices.add(i);
            while (!startIndices.isEmpty()) {
                Iterator iterator = startIndices.iterator();
                while (iterator.hasNext()) {
                    int srcIndex = (Integer)iterator.next();
                    for (E edge : this.getEdgesFrom(srcIndex)) {
                        int dstIndex = edge.dst.index;
                        if (seen.contains(dstIndex)) continue;
                        nextStartIndexes.add(dstIndex);
                    }
                }
                seen.addAll(nextStartIndexes);
                startIndices = new ArrayList(nextStartIndexes);
                nextStartIndexes.clear();
            }
            this.reachabilityIndices.add(seen);
        }
    }

    public boolean isAdjacent(V from, V to) {
        for (E e : this.getEdgesFrom(from.index)) {
            if (e.dst != to) continue;
            return true;
        }
        return false;
    }

    public boolean canReach(V from, V to) {
        Set<Integer> indices;
        if (this.isAdjacent(from, to)) {
            return true;
        }
        if (this.reachabilityIndices == null) {
            this.computeTransitiveClosure();
        }
        if ((indices = this.reachabilityIndices.get(from.index)) == null) {
            return false;
        }
        return this.reachabilityIndices.get(from.index).contains(to.index);
    }

    public Set<Integer> getReachableVertices(int fromId) {
        V src = this.vertexmap.get(fromId);
        Assert.a(src != null, "Vertex id does not exist: " + fromId);
        if (this.reachabilityIndices == null) {
            this.computeTransitiveClosure();
        }
        Set<Integer> indices = this.reachabilityIndices.get(src.index);
        HashSet<Integer> r = new HashSet<Integer>();
        for (int index : indices) {
            r.add(this.vertices.get((int)index).id);
        }
        return r;
    }
}

