/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.graph.fast;

import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.AbstractGraph;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.GraphStyleData;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.fast.IGraphBoundsListener;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.fast.IGraphVertexListener;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.fast.L;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.fast.P;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.fast.R;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.model.ILabelProvider;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.concurrent.ThreadUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class XYGraph
extends AbstractGraph {
    private static final ILogger logger = GlobalLog.getLogger(XYGraph.class);
    public static final double DEFAULT_ZOOM_LEVEL_IN = 0.8;
    public static final double DEFAULT_ZOOM_LEVEL_OUT = 1.2;
    private static final long DEFAULT_ACTIVE_VERTEX_ANIMATION_PERIOD_MS = 600L;
    private static final long DEFAULT_DRAG_ANIMATION_PERIOD_MS = 50L;
    private List<IGraphVertexListener> vertexListeners = new ArrayList<IGraphVertexListener>();
    private List<IGraphBoundsListener> boundsListeners = new ArrayList<IGraphBoundsListener>();
    private Thread aniThread;
    private boolean directed;
    private Map<Integer, P> pointmap = new HashMap<Integer, P>();
    private List<L> lines = new ArrayList<L>();
    private P selectedVertex;
    private P hoveredVertex;
    private Collection<P> visiblePoints = new HashSet<P>();
    private Collection<L> visibleLines = new HashSet<L>();
    private Map<Integer, Point> pointsCoordMap;
    private boolean drawVertices = true;
    private boolean drawEdges = true;
    private boolean drawLabels = true;
    protected Set<P> activePoints = new HashSet<P>();
    protected Set<Integer> activeVertices = new HashSet<Integer>();
    protected Set<L> activeLines = new HashSet<L>();
    private volatile int activeState;
    private volatile boolean activeNodeAnimationEnabled = true;
    private ILabelProvider labelProvider;
    private Rectangle clientArea = new Rectangle(0, 0, 0, 0);
    private double gx;
    private double gy;
    private double gw;
    private double gh;
    private P mouseCoord = new P();
    private boolean dragging;
    private Point dragPoint = new Point(0, 0);
    private Point mouseDownPoint = new Point(0, 0);
    private Point mousePoint = new Point(0, 0);
    private boolean trackVertexHovering = true;

    public XYGraph(Composite parent) {
        super(parent, 0x20000000);
        this.setLayout(null);
        this.clientArea = this.getClientArea();
        UI.initialize();
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                XYGraph.this.clientArea = XYGraph.this.getClientArea();
                XYGraph.this.adjustGraphBounds();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Point pt;
                GC gc = e.gc;
                try {
                    gc.setAntialias(1);
                }
                catch (SWTException sWTException) {
                    // empty catch block
                }
                Map<Integer, Point> m = XYGraph.this.getVertexViewportCoordinates();
                XYGraph.this.visiblePoints = XYGraph.this.determineVisibleVertices(XYGraph.this.pointmap.values());
                XYGraph.this.visibleLines = XYGraph.this.determineVisibleEdges(XYGraph.this.visiblePoints, XYGraph.this.lines);
                XYGraph.this.preDrawing(gc);
                if (XYGraph.this.drawEdges) {
                    XYGraph.this.preEdgesDrawing(gc);
                    for (L line : XYGraph.this.visibleLines) {
                        Point a = m.get(line.getSrcId());
                        Point b = m.get(line.getDstId());
                        XYGraph.this.drawEdge(gc, line, a, b);
                    }
                    XYGraph.this.postEdgesDrawing(gc);
                }
                if (XYGraph.this.drawVertices) {
                    XYGraph.this.preVerticesDrawing(gc);
                    for (P p : XYGraph.this.visiblePoints) {
                        pt = m.get(p.getId());
                        XYGraph.this.drawVertex(gc, p, pt);
                    }
                    XYGraph.this.postVerticesDrawing(gc);
                }
                if (XYGraph.this.drawLabels) {
                    XYGraph.this.preVertexLabelsDrawing(gc);
                    for (P p : XYGraph.this.visiblePoints) {
                        pt = m.get(p.getId());
                        XYGraph.this.drawVertexLabel(gc, p, pt);
                    }
                    XYGraph.this.postVertexLabelsDrawing(gc);
                }
                XYGraph.this.postDrawing(gc);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                if (XYGraph.this.hoveredVertex != null) {
                    XYGraph.this.notifyVertexDoubleClicked(XYGraph.this.hoveredVertex);
                }
            }

            public void mouseDown(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                ((XYGraph)XYGraph.this).mouseDownPoint.x = e.x;
                ((XYGraph)XYGraph.this).mouseDownPoint.y = e.y;
                XYGraph.this.dragging = true;
                ((XYGraph)XYGraph.this).dragPoint.x = e.x;
                ((XYGraph)XYGraph.this).dragPoint.y = e.y;
            }

            public void mouseUp(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                if (XYGraph.this.mouseDownPoint != null && new Point(e.x, e.y).equals((Object)XYGraph.this.mouseDownPoint) && XYGraph.this.hoveredVertex != null) {
                    XYGraph.this.selectedVertex = XYGraph.this.hoveredVertex;
                    XYGraph.this.refreshGraph();
                    XYGraph.this.notifyVertexClicked(XYGraph.this.selectedVertex);
                }
                XYGraph.this.dragging = false;
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                ((XYGraph)XYGraph.this).mousePoint.x = e.x;
                ((XYGraph)XYGraph.this).mousePoint.y = e.y;
                XYGraph.this.mouseCoord = XYGraph.this.convertCoord(XYGraph.this.mousePoint);
                if (XYGraph.this.dragging) {
                    int deltaX = e.x - ((XYGraph)XYGraph.this).dragPoint.x;
                    int deltaY = e.y - ((XYGraph)XYGraph.this).dragPoint.y;
                    ((XYGraph)XYGraph.this).dragPoint.x = e.x;
                    ((XYGraph)XYGraph.this).dragPoint.y = e.y;
                    XYGraph.this.dragGraph(deltaX, deltaY);
                } else if (XYGraph.this.trackVertexHovering) {
                    double dist;
                    double distPx;
                    P closestVertex = XYGraph.this.findClosestVertex(XYGraph.this.mouseCoord, XYGraph.this.visiblePoints);
                    if (closestVertex != null && (distPx = (dist = closestVertex.dist(XYGraph.this.mouseCoord)) * (double)((XYGraph)XYGraph.this).clientArea.width / XYGraph.this.gw) > 20.0) {
                        closestVertex = null;
                    }
                    if (XYGraph.this.hoveredVertex != null && closestVertex != XYGraph.this.hoveredVertex) {
                        XYGraph.this.notifyVertexHoverOut(XYGraph.this.hoveredVertex);
                    }
                    XYGraph.this.hoveredVertex = null;
                    if (closestVertex != null) {
                        XYGraph.this.hoveredVertex = closestVertex;
                        XYGraph.this.notifyVertexHoverIn(XYGraph.this.hoveredVertex);
                    }
                    XYGraph.this.redraw();
                }
            }
        });
        this.aniThread = ThreadUtil.start(new Runnable(){

            @Override
            public void run() {
                while (!XYGraph.this.isDisposed()) {
                    try {
                        Thread.sleep(600L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    if (!XYGraph.this.activeNodeAnimationEnabled || XYGraph.this.activePoints.isEmpty() && XYGraph.this.activeLines.isEmpty()) continue;
                    try {
                        if (XYGraph.this.getDisplay().isDisposed()) break;
                        XYGraph.this.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!XYGraph.this.isDisposed()) {
                                    XYGraph.this.redraw();
                                    XYGraph.this.activeState = 1 - XYGraph.this.activeState;
                                }
                            }
                        });
                    }
                    catch (SWTException e) {
                        break;
                    }
                }
            }
        });
    }

    public void dispose() {
        if (this.aniThread != null) {
            this.aniThread.interrupt();
            this.aniThread = null;
        }
        super.dispose();
    }

    public void reset() {
        this.pointmap.clear();
        this.lines.clear();
        this.selectedVertex = null;
        this.hoveredVertex = null;
        this.visiblePoints.clear();
        this.visibleLines.clear();
        this.pointsCoordMap = null;
        this.activePoints.clear();
        this.activeVertices.clear();
        this.activeLines.clear();
        this.labelProvider = null;
        this.drawVertices = true;
        this.drawEdges = true;
        this.drawLabels = true;
    }

    public void setDrawVertices(boolean drawVertices) {
        this.drawVertices = drawVertices;
    }

    public boolean isDrawVertices() {
        return this.drawVertices;
    }

    public void setDrawEdges(boolean drawEdges) {
        this.drawEdges = drawEdges;
    }

    public boolean isDrawEdges() {
        return this.drawEdges;
    }

    public void setDrawLabels(boolean drawLabels) {
        this.drawLabels = drawLabels;
    }

    public boolean isDrawLabels() {
        return this.drawLabels;
    }

    @Override
    public int getVertexCount() {
        return this.pointmap.size();
    }

    public Collection<P> getPoints() {
        return this.pointmap.values();
    }

    public Collection<P> getVisiblePoints() {
        return this.visiblePoints;
    }

    public boolean isVertexVisible(int vertexId) {
        for (P p : this.visiblePoints) {
            if (p.id != vertexId) continue;
            return true;
        }
        return false;
    }

    public int getEdgeCount() {
        return this.lines.size();
    }

    public Collection<L> getLines() {
        return this.lines;
    }

    public Collection<L> getVisibleLines() {
        return this.visibleLines;
    }

    @Override
    public Rectangle getContainerArea() {
        int xmin = Integer.MAX_VALUE;
        int ymin = Integer.MAX_VALUE;
        int xmax = Integer.MIN_VALUE;
        int ymax = Integer.MIN_VALUE;
        Map<Integer, Point> m = this.getVertexViewportCoordinates();
        for (Point pt : m.values()) {
            if (pt.x < xmin) {
                xmin = pt.x;
            }
            if (pt.x > xmax) {
                xmax = pt.x;
            }
            if (pt.y < ymin) {
                ymin = pt.y;
            }
            if (pt.y <= ymax) continue;
            ymax = pt.y;
        }
        return new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    public P getSelectedPoint() {
        return this.selectedVertex;
    }

    public void setSelectedPoint(P p) {
        this.selectedVertex = p;
    }

    public Integer getSelection() {
        return this.selectedVertex == null ? null : this.selectedVertex.id;
    }

    public void setSelection(Integer vertexId) {
        this.selectedVertex = vertexId == null ? null : this.pointmap.get(vertexId);
    }

    public void setTrackVertexHovering(boolean trackVertexHovering) {
        this.trackVertexHovering = trackVertexHovering;
    }

    public boolean isTrackVertexHovering() {
        return this.trackVertexHovering;
    }

    public P getHoveredPoint() {
        return this.hoveredVertex;
    }

    public void setActiveNodeAnimationEnabled(boolean activeNodeAnimationEnabled) {
        this.activeNodeAnimationEnabled = activeNodeAnimationEnabled;
    }

    public boolean isActiveNodeAnimationEnabled() {
        return this.activeNodeAnimationEnabled;
    }

    public Collection<P> getActivePoints() {
        return this.activePoints;
    }

    public boolean getActivePointsStatus() {
        return this.activeState == 1;
    }

    public boolean isActivePoint(P p) {
        return this.activePoints.contains(p);
    }

    public boolean isActiveVertex(int id) {
        return this.activeVertices.contains(id);
    }

    public void addActivePoint(P p) {
        this.activePoints.add(p);
        if (this.activeVertices.add(p.id)) {
            this.notifyGraphChange();
        }
    }

    public void removeActivePoint(P p) {
        this.activePoints.remove(p);
        if (this.activeVertices.remove(p.id)) {
            this.notifyGraphChange();
        }
    }

    public boolean isDragging() {
        return this.dragging;
    }

    @Override
    public void dragGraph(int deltaX, int deltaY) {
        this.dragGraph(deltaX, deltaY, false);
    }

    @Override
    public void dragGraph(int deltaX, int deltaY, boolean progressive) {
        Rectangle r = this.clientArea;
        double gx1 = this.gx - this.gw * (double)deltaX / (double)r.width;
        double gy1 = this.gy + this.gh * (double)deltaY / (double)r.height;
        if (progressive) {
            int frameCount = 10;
            int incrX = deltaX / 10;
            int incrY = deltaY / 10;
            if (incrX != 0 || incrY != 0) {
                for (int i = 0; i < 9; ++i) {
                    this.gx -= this.gw * (double)incrX / (double)r.width;
                    this.gy += this.gh * (double)incrY / (double)r.height;
                    this.scroll(incrX, incrY, 0, 0, r.width, r.height, true);
                    this.refreshGraph();
                    try {
                        Thread.sleep(50L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                deltaX -= 10 * incrX;
                deltaY -= 10 * incrY;
            }
        }
        this.gx = gx1;
        this.gy = gy1;
        this.notifyBoundsChange();
        this.scroll(deltaX, deltaY, 0, 0, r.width, r.height, true);
        this.refreshGraph();
    }

    @Override
    public void refreshGraph() {
        this.pointsCoordMap = null;
        this.redraw();
        this.update();
    }

    @Override
    public void zoomGraph(int zoom) {
        this.zoomGraph(zoom, null);
    }

    @Override
    public void zoomGraph(int zoom, Point centerPoint) {
        double ratio = 1.0;
        if (zoom > 0) {
            ratio = 0.8;
        } else if (zoom < 0) {
            ratio = 1.2;
        }
        this.applyZoom(ratio, centerPoint == null ? null : this.convertCoord(centerPoint));
    }

    void applyZoom(double ratio, P centerPoint) {
        Assert.a(ratio > 0.0);
        if (ratio == 1.0) {
            return;
        }
        if (centerPoint == null) {
            centerPoint = new P(this.gx + this.gw / 2.0, this.gy + this.gh / 2.0);
        }
        double rx = (centerPoint.x - this.gx) / this.gw;
        double ry = (centerPoint.y - this.gy) / this.gh;
        this.gw = ratio * this.gw;
        this.gh = ratio * this.gh;
        this.gx = centerPoint.x - rx * this.gw;
        this.gy = centerPoint.y - ry * this.gh;
        this.notifyBoundsChange();
        this.redraw();
        this.update();
    }

    public void setParameters(Collection<P> allpoints, Collection<L> alllines, boolean directedGraph) {
        this.setParameters(allpoints, alllines, directedGraph, true);
    }

    public void setParameters(Collection<P> allpoints, Collection<L> alllines, boolean directedGraph, boolean autofit) {
        if (allpoints == null) {
            allpoints = Collections.emptyList();
        }
        if (alllines == null) {
            alllines = Collections.emptyList();
        }
        this.pointmap.clear();
        for (P p : allpoints) {
            this.pointmap.put(p.getId(), p);
        }
        this.lines.clear();
        this.lines.addAll(alllines);
        this.directed = directedGraph;
        this.hoveredVertex = null;
        this.visiblePoints = null;
        this.visibleLines = null;
        this.pointsCoordMap = null;
        if (autofit) {
            this.fitGraph(0.05, false);
            this.notifyBoundsChange();
        }
    }

    public void reportParametersUpdate() {
        this.pointsCoordMap = null;
        this.redraw();
    }

    @Override
    public void centerGraph() {
        this.fitGraph(0.1, true);
    }

    public void centerGraph(int vertexId) {
        P p = this.pointmap.get(vertexId);
        Assert.a(p != null, "Vertex id " + vertexId + " does not exist");
        this.setGraphLocation(p.x - this.gw / 2.0, p.y - this.gh / 2.0);
    }

    @Override
    public void positionGraph(double xRatio, double yRatio) {
        Rectangle container = this.getContainerArea();
        int x0 = (int)((double)container.x + xRatio * (double)container.width);
        int y0 = (int)((double)container.y + yRatio * (double)container.height);
        int deltaX = this.clientArea.width / 2 - x0;
        int deltaY = this.clientArea.height / 2 - y0;
        this.dragGraph(deltaX, deltaY);
    }

    public void centerGraph(int vertexId, int clientAnchorFlags, boolean progressive) {
        Point pt = this.getVertexViewportCoordinates().get(vertexId);
        Rectangle client = this.clientArea;
        int x0 = pt.x;
        int y0 = pt.y;
        int x1 = client.width / 2;
        int y1 = client.height / 2;
        if ((clientAnchorFlags & 0x80) != 0) {
            y1 = client.height / 10;
        } else if ((clientAnchorFlags & 0x400) != 0) {
            y1 = client.height * 9 / 10;
        }
        if ((clientAnchorFlags & 0x4000) != 0) {
            x1 = client.width / 10;
        } else if ((clientAnchorFlags & 0x20000) != 0) {
            x1 = client.width * 9 / 10;
        }
        int deltaX = x1 - x0;
        int deltaY = y1 - y0;
        this.dragGraph(deltaX, deltaY, progressive);
    }

    public void fitGraph() {
        this.fitGraph(0.05, true);
    }

    private void fitGraph(double marginRatio, boolean redraw) {
        double x = Double.MAX_VALUE;
        double xmax = -1.7976931348623157E308;
        double y = Double.MAX_VALUE;
        double ymax = -1.7976931348623157E308;
        for (P p : this.pointmap.values()) {
            if (p.getX() < x) {
                x = p.getX();
            }
            if (p.getX() > xmax) {
                xmax = p.getX();
            }
            if (p.getY() < y) {
                y = p.getY();
            }
            if (!(p.getY() > ymax)) continue;
            ymax = p.getY();
        }
        double w = xmax - x;
        double h = ymax - y;
        double dist = Math.sqrt(Math.pow(w, 2.0) + Math.pow(h, 2.0));
        double margin = dist * marginRatio;
        this.setGraphBounds(x -= margin, y -= margin, w += 2.0 * margin, h += 2.0 * margin, redraw);
    }

    private boolean setGraphBounds(R bounds, boolean redraw) {
        return this.setGraphBounds(bounds.x, bounds.y, bounds.w, bounds.h, redraw);
    }

    private boolean setGraphBounds(double x, double y, double w, double h, boolean redrawOnChange) {
        boolean changed = false;
        if (this.gx != x) {
            this.gx = x;
            changed = true;
        }
        if (this.gy != y) {
            this.gy = y;
            changed = true;
        }
        if (this.gw != w) {
            this.gw = w;
            changed = true;
        }
        if (this.gh != h) {
            this.gh = h;
            changed = true;
        }
        if (changed) {
            if (!this.adjustGraphBounds()) {
                this.notifyBoundsChange();
            }
            if (redrawOnChange) {
                this.redraw();
            }
        }
        return changed;
    }

    public boolean setGraphBounds(R bounds) {
        return this.setGraphBounds(bounds, true);
    }

    public R getGraphBounds() {
        return new R(this.gx, this.gy, this.gw, this.gh);
    }

    public void setGraphLocation(double x, double y) {
        this.setGraphBounds(new R(x, y, this.gw, this.gh));
    }

    public void setGraphSize(double w, double h) {
        this.setGraphBounds(new R(this.gx, this.gy, w, h));
    }

    private boolean adjustGraphBounds() {
        boolean changed = false;
        Rectangle r = this.clientArea;
        double graph_ratio = this.gw / this.gh;
        double viewport_ratio = (double)r.width / (double)r.height;
        if (graph_ratio > viewport_ratio) {
            double updated = this.gw * (double)r.height / (double)r.width;
            this.gy -= (updated - this.gh) / 2.0;
            this.gh = updated;
            changed = true;
        } else if (graph_ratio < viewport_ratio) {
            double updated = this.gh * (double)r.width / (double)r.height;
            this.gx -= (updated - this.gw) / 2.0;
            this.gw = updated;
            changed = true;
        }
        if (changed) {
            this.notifyBoundsChange();
        }
        return changed;
    }

    public Point convertCoord(P p) {
        Rectangle r = this.clientArea;
        int x = (int)((p.getX() - this.gx) / this.gw * (double)r.width);
        int y = r.height - (int)((p.getY() - this.gy) / this.gh * (double)r.height);
        return new Point(x, y);
    }

    public P convertCoord(Point p) {
        Rectangle r = this.clientArea;
        double x = (double)p.x / (double)r.width * this.gw + this.gx;
        double y = ((double)p.y - (double)r.height) / (double)(-r.height) * this.gh + this.gy;
        return new P(x, y);
    }

    public Map<Integer, Point> getVertexViewportCoordinates() {
        if (this.pointsCoordMap == null) {
            this.pointsCoordMap = new HashMap<Integer, Point>();
            for (P p : this.pointmap.values()) {
                Point pc = this.convertCoord(p);
                this.pointsCoordMap.put(p.getId(), pc);
            }
        }
        return this.pointsCoordMap;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public String generateLabelForVertex(P p) {
        String s;
        if (this.labelProvider != null && !Strings.isBlank(s = this.labelProvider.getLabel(p.getId()))) {
            return s;
        }
        return "" + p.getId();
    }

    protected void preDrawing(GC gc) {
    }

    protected void postDrawing(GC gc) {
    }

    protected Collection<P> determineVisibleVertices(Collection<P> points) {
        return points;
    }

    protected Collection<L> determineVisibleEdges(Collection<P> visiblePoints, Collection<L> edges) {
        return edges;
    }

    protected void preEdgesDrawing(GC gc) {
        gc.setForeground(this.getDisplay().getSystemColor(15));
    }

    protected void drawEdge(GC gc, L l, Point a, Point b) {
        gc.drawLine(a.x, a.y, b.x, b.y);
    }

    protected void postEdgesDrawing(GC gc) {
    }

    protected void preVerticesDrawing(GC gc) {
        gc.setBackground(this.getDisplay().getSystemColor(2));
    }

    protected void drawVertex(GC gc, P p, Point pt) {
        int pr = 6;
        gc.fillOval(pt.x - 3, pt.y - 3, 6, 6);
    }

    protected void postVerticesDrawing(GC gc) {
    }

    protected void preVertexLabelsDrawing(GC gc) {
        gc.setForeground(this.getDisplay().getSystemColor(4));
    }

    protected void drawVertexLabel(GC gc, P p, Point pt) {
        gc.drawText(this.generateLabelForVertex(p), pt.x, pt.y, true);
    }

    protected void postVertexLabelsDrawing(GC gc) {
    }

    public final P findClosestVertex(P p0, Collection<P> candidates) {
        if (candidates == null) {
            if (this.pointmap == null) {
                return null;
            }
            candidates = this.pointmap.values();
        }
        P closestVertex = null;
        double min = Double.MAX_VALUE;
        for (P p : candidates) {
            double sum2;
            double dy2;
            double dx2;
            double dy;
            double dx = Math.abs(p.getX() - p0.getX());
            if (dx >= min || (dy = Math.abs(p.getY() - p0.getY())) >= min || (dx2 = dx * dx) >= min || (dy2 = dy * dy) >= min || (sum2 = dx2 + dy2) >= min) continue;
            min = sum2;
            closestVertex = p;
        }
        return closestVertex;
    }

    public void addGraphVertexListener(IGraphVertexListener listener) {
        this.vertexListeners.add(listener);
    }

    public void removeGraphVertexListener(IGraphVertexListener listener) {
        this.vertexListeners.remove(listener);
    }

    private void notifyVertexHoverIn(P p) {
        for (IGraphVertexListener listener : this.vertexListeners) {
            listener.onVertexHoverIn(this, p);
        }
    }

    private void notifyVertexHoverOut(P p) {
        for (IGraphVertexListener listener : this.vertexListeners) {
            listener.onVertexHoverOut(this, p);
        }
    }

    private void notifyVertexClicked(P p) {
        for (IGraphVertexListener listener : this.vertexListeners) {
            listener.onVertexClicked(this, p);
        }
    }

    private void notifyVertexDoubleClicked(P p) {
        for (IGraphVertexListener listener : this.vertexListeners) {
            listener.onVertexDoubleClicked(this, p);
        }
    }

    public void addGraphBoundsListener(IGraphBoundsListener listener) {
        this.boundsListeners.add(listener);
    }

    public void removeGraphBoundsListener(IGraphBoundsListener listener) {
        this.boundsListeners.remove(listener);
    }

    private void notifyBoundsChange() {
        this.pointsCoordMap = null;
        for (IGraphBoundsListener listener : this.boundsListeners) {
            listener.onBoundsUpdate(this, new R(this.gx, this.gy, this.gw, this.gh));
        }
        this.notifyGraphChange();
    }

    @Override
    public Rectangle generatePreview(GC gc, Rectangle preview, GraphStyleData styleDataOverride, boolean renderEdges) {
        int offsetHeight;
        int offsetWidth;
        int usedWidth;
        Rectangle container = this.getContainerArea();
        if (container.width == 0 || container.height == 0 || preview.width == 0 || preview.height == 0) {
            return null;
        }
        GraphStyleData styles = styleDataOverride != null ? styleDataOverride : GraphStyleData.buildDefault();
        int usedHeight = Math.max(1, preview.width * container.height / container.width);
        if (usedHeight > preview.height) {
            usedWidth = Math.max(1, preview.height * container.width / container.height);
            Assert.a(usedWidth <= preview.width);
            offsetWidth = (preview.width - usedWidth) / 2;
            usedHeight = preview.height;
            offsetHeight = 0;
        } else {
            offsetHeight = (preview.height - usedHeight) / 2;
            usedWidth = preview.width;
            offsetWidth = 0;
        }
        double xRatio = (double)usedWidth / (double)container.width;
        double yRatio = (double)usedHeight / (double)container.height;
        Rectangle b = this.clientArea;
        int x = (int)((double)(b.x - container.x) * xRatio) + offsetWidth;
        int y = (int)((double)(b.y - container.y) * yRatio) + offsetHeight;
        int w = Math.max(3, (int)((double)b.width * xRatio));
        int h = Math.max(3, (int)((double)b.height * yRatio));
        gc.setBackground(styles.cCanvas);
        gc.fillRectangle(x, y, w, h);
        ArrayList<Point> activePts = new ArrayList<Point>();
        for (Map.Entry<Integer, Point> entry : this.getVertexViewportCoordinates().entrySet()) {
            int id = entry.getKey();
            Point pt = entry.getValue();
            if (this.isActiveVertex(id)) {
                activePts.add(pt);
                continue;
            }
            x = (int)((double)(pt.x - container.x) * xRatio) + offsetWidth;
            y = (int)((double)(pt.y - container.y) * yRatio) + offsetHeight;
            gc.setBackground(styles.cNode);
            gc.fillOval(x, y, 3, 3);
        }
        for (Point pt : activePts) {
            x = (int)((double)(pt.x - container.x) * xRatio) + offsetWidth;
            y = (int)((double)(pt.y - container.y) * yRatio) + offsetHeight;
            gc.setBackground(styles.cActiveNode);
            gc.fillOval(x, y, 6, 6);
        }
        return new Rectangle(offsetWidth, offsetHeight, usedWidth, usedHeight);
    }
}

