/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.controls;

import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.FilterText;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.IFilterText;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractFilteredView<T extends Composite>
extends Composite {
    private Composite container;
    private FilterText filterText;
    private String previousFilterText;
    private T mainElement;

    public AbstractFilteredView(Composite parent, int style, String[] columnNames) {
        this(parent, style, columnNames, null, false);
    }

    public AbstractFilteredView(Composite parent, int style, String[] columnNames, int[] columnWidths, boolean displayIndex) {
        super(parent, 0);
        boolean singleColumn;
        boolean filterOnTop;
        this.setLayout((Layout)new FillLayout());
        this.container = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout(1, false);
        this.container.setLayout((Layout)layout);
        boolean bl = filterOnTop = (style & 0x80) != 0;
        if (filterOnTop) {
            style &= 0xFFFFFF7F;
            this.filterText = new FilterText(this.container);
        }
        this.mainElement = this.buildElement(this.container, style);
        if (!filterOnTop) {
            this.filterText = new FilterText(this.container);
        }
        this.filterText.setLayoutData(UIUtil.createGridDataFillHorizontally());
        boolean bl2 = singleColumn = !displayIndex && columnNames != null && columnNames.length == 1;
        if (displayIndex) {
            this.buildColumn(this.mainElement, "Index", singleColumn ? 0 : 50);
        }
        if (columnNames != null) {
            int i = 0;
            for (String name : columnNames) {
                this.buildColumn(this.mainElement, name, singleColumn ? 0 : (columnWidths != null ? columnWidths[i] : 100));
                ++i;
            }
        }
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002 && filterOnTop && AbstractFilteredView.this.getItemCount() > 0) {
                    AbstractFilteredView.this.setSelection(0);
                    AbstractFilteredView.this.mainElement.setFocus();
                    e.doit = false;
                } else if (e.keyCode == 0x1000001 && !filterOnTop && AbstractFilteredView.this.getItemCount() > 0) {
                    AbstractFilteredView.this.setSelection(AbstractFilteredView.this.getItemCount() - 1);
                    AbstractFilteredView.this.mainElement.setFocus();
                    e.doit = false;
                } else if ((e.stateMask & SWT.MOD1) == SWT.MOD1 && e.keyCode == 8) {
                    AbstractFilteredView.this.filterText.setText("");
                    e.doit = false;
                } else if (e.keyCode == 27) {
                    AbstractFilteredView.this.setFilterVisibility(false, false);
                    AbstractFilteredView.this.mainElement.setFocus();
                    e.doit = false;
                }
            }
        });
        this.mainElement.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000001 && filterOnTop && AbstractFilteredView.this.getSelectionIndex() == 0 || e.keyCode == 0x1000002 && !filterOnTop && AbstractFilteredView.this.getSelectionIndex() == AbstractFilteredView.this.getItemCount() - 1) {
                    if (AbstractFilteredView.this.filterText.isVisible()) {
                        AbstractFilteredView.this.filterText.setFocus();
                        e.doit = false;
                    }
                } else if ((e.stateMask & SWT.MOD1) == SWT.MOD1 && e.keyCode == 102) {
                    AbstractFilteredView.this.setFilterVisibility(true, true);
                }
            }
        });
    }

    public IFilterText getFilterText() {
        return this.filterText;
    }

    public T getElement() {
        return this.mainElement;
    }

    public boolean setFocus() {
        return this.mainElement.setFocus();
    }

    public void setFilterVisibility(boolean visible, boolean focus) {
        if (this.filterText.isVisible() != visible) {
            Object layoutData = this.filterText.getLayoutData();
            if (layoutData instanceof GridData) {
                ((GridData)layoutData).exclude = !visible;
            }
            this.filterText.setVisible(visible);
            this.filterText.getParent().layout();
            if (!visible) {
                this.previousFilterText = this.filterText.getText();
                this.filterText.setText("");
            } else if (this.previousFilterText != null) {
                this.filterText.setText(this.previousFilterText);
                this.previousFilterText = null;
            }
        }
        if (focus) {
            this.filterText.setFocus();
            this.filterText.selectAll();
        }
    }

    public void setFilterVisibility(boolean visible) {
        this.setFilterVisibility(visible, visible);
    }

    public Composite getContainer() {
        return this.container;
    }

    int computeInnerHeight(int wHint, int hHint, boolean changed) {
        int innerHeight = 0;
        Point fTextSize = this.filterText.computeSize(wHint, hHint, changed);
        innerHeight += fTextSize.y;
        GridLayout contLayout = (GridLayout)this.container.getLayout();
        return innerHeight += contLayout.verticalSpacing * 1 + contLayout.marginTop + contLayout.marginHeight * 2 + contLayout.marginBottom;
    }

    protected abstract T buildElement(Composite var1, int var2);

    protected abstract void buildColumn(T var1, String var2, int var3);

    public abstract int getSelectionIndex();

    public abstract void setSelection(int var1);

    public abstract int getItemCount();
}

