/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.binding;

import com.pnfsoftware.jeb.rcpclient.extensions.binding.KeyShortcutsManager;
import com.pnfsoftware.jeb.util.base.OSType;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;

public abstract class ActionEx
extends Action
implements Runnable {
    private static KeyShortcutsManager ksm;
    private static OSType ostype;
    boolean hasCustomShortcut;
    List<Integer> acclist = new ArrayList<Integer>();
    String text;
    String text0;

    public static void setKeyboardShortcuts(KeyShortcutsManager manager) {
        ksm = manager;
    }

    public static KeyShortcutsManager getKeyShortcutManager() {
        return ksm;
    }

    public ActionEx(String id, String text) {
        this(id, text, 0);
    }

    public ActionEx(String id, String text, int style) {
        this(id, text, style, new int[0]);
    }

    public ActionEx(String id, String text, int style, int ... accelerators) {
        super(text, style);
        int keycode;
        this.text0 = text;
        this.setText(text);
        if (!Strings.isBlank(id)) {
            this.setId(id);
        }
        if (ksm != null && (keycode = ksm.getShortcutKeycode(this.getId())) != 0 && this.addExtraAccelerator(keycode)) {
            this.hasCustomShortcut = true;
        }
        for (int accelerator : accelerators) {
            this.setAccelerator(accelerator);
        }
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setAccelerator(int keycode) {
        if (!this.hasCustomShortcut) {
            this.addExtraAccelerator(keycode);
        }
    }

    @Override
    public int getAccelerator() {
        return 0;
    }

    public boolean addExtraAccelerator(int keycode) {
        if (ksm != null && ksm.isReserved(keycode) && !Strings.equals(this.getId(), ksm.getActionIdForKeycode(keycode))) {
            return false;
        }
        int mod = keycode & SWT.MODIFIER_MASK;
        int key = keycode & ~SWT.MODIFIER_MASK;
        if (this.acclist.contains(keycode = mod | Character.toLowerCase(key))) {
            return false;
        }
        if (this.acclist.isEmpty()) {
            String accel = KeyStroke.getInstance(mod, Character.toUpperCase(key)).toString();
            accel = this.refineAcceleratorString(accel);
            String text = ostype.isLinux() ? this.text0 + "     ( " + accel + " )" : this.text0 + "\t" + accel;
            this.setText(text);
        }
        this.acclist.add(keycode);
        return true;
    }

    private String refineAcceleratorString(String s) {
        s = s.replace("CR", "ENTER");
        StringBuilder sb = new StringBuilder();
        boolean upper = true;
        for (int i = 0; i < s.length(); ++i) {
            Character c = Character.valueOf(s.charAt(i));
            if (c.charValue() == '_') {
                c = Character.valueOf(' ');
                upper = true;
            } else if (c.charValue() == '+') {
                c = null;
                upper = true;
            } else if (upper) {
                c = Character.valueOf(Character.toUpperCase(c.charValue()));
                upper = false;
            } else {
                c = Character.valueOf(Character.toLowerCase(c.charValue()));
            }
            if (c == null) continue;
            sb.append(c);
        }
        s = sb.toString().replace("Enter", "\u21a9").replace("Tab", "\u21b9").replace("Space", "\u2423").replace("Del", "\u232b").replace("Command", "\u2318").replace("Ctrl", "\u2303").replace("Control", "\u2303").replace("Alt", "\u2325").replace("Shift", "\u21e7").replace("Arrow Left", "\u2190").replace("Arrow Up", "\u2191").replace("Arrow Right", "\u2192").replace("Arrow Down", "\u2193");
        return s;
    }

    public List<Integer> getExtraAccelerators() {
        return this.acclist;
    }

    public boolean canExecute() {
        return this.isEnabled();
    }

    public void execute() {
        this.run();
    }

    public boolean checkExecutionContext(Control ctl) {
        return this.isAllowedForControl(ctl) && !this.isForbiddenForControl(ctl);
    }

    protected boolean isAllowedForControl(Control ctl) {
        return true;
    }

    protected boolean isForbiddenForControl(Control ctl) {
        return false;
    }

    static {
        ostype = OSType.determine();
    }
}

