/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions;

import com.pnfsoftware.jeb.rcpclient.extensions.IImageSource;
import com.pnfsoftware.jeb.rcpclient.extensions.ViewerRefresher;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.ImageView;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;

public class ImageViewer
extends Viewer {
    private static final ILogger logger = GlobalLog.getLogger(ImageViewer.class);
    private IImageSource input;
    private IEventListener inputListener;
    private Composite container;
    private ImageView widget;
    private ViewerRefresher refresher = null;

    public ImageViewer(Composite parent) {
        this.container = parent;
    }

    public ImageView getControl() {
        return this.widget;
    }

    @Override
    public IImageSource getInput() {
        return this.input;
    }

    @Override
    public void refresh() {
        if (this.widget != null) {
            this.widget.dispose();
            this.widget = null;
        }
        if (this.input != null) {
            this.widget = new ImageView(this.container, this.input.getImage());
            this.container.layout();
        }
    }

    @Override
    public void setInput(Object input) {
        if (this.inputListener != null) {
            this.input.removeListener(this.inputListener);
            this.inputListener = null;
        }
        if (this.refresher == null) {
            this.refresher = new ViewerRefresher(this.container.getDisplay(), this);
        }
        this.input = (IImageSource)input;
        this.inputListener = new IEventListener(){

            @Override
            public void onEvent(IEvent e) {
                logger.i("Event received: %s", e);
                ImageViewer.this.refresher.request();
            }
        };
        this.input.addListener(this.inputListener);
        this.refresh();
    }

    @Override
    public void setSelection(ISelection selection, boolean reveal) {
    }

    @Override
    public ISelection getSelection() {
        return null;
    }
}

