/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TextDialog
extends JebDialog {
    private Text text;
    private String textLabel;
    private String input;
    private Font font;
    private int linecount = 1;
    private int colcount = 20;
    private boolean editable = true;
    private boolean selected = false;
    private boolean nowrap;
    private String initialText;
    private Integer labelOk;
    private Integer labelCancel;
    protected Button btnOk;
    protected Button btnCancel;

    public TextDialog(Shell parent, String caption, String initialText, String widgetName) {
        super(parent, caption, true, true, widgetName);
        this.initialText = initialText;
        this.labelOk = 605;
        this.labelCancel = 105;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setInitialText(String text) {
        this.initialText = text;
    }

    public void setTextLabel(String label) {
        this.textLabel = label;
    }

    public void setLineCount(int linecount) {
        this.linecount = linecount;
    }

    public void setColumnCount(int colcount) {
        this.colcount = colcount;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void setNoWordWrap(boolean nowordwrap) {
        this.nowrap = nowordwrap;
    }

    public void setOkLabelId(Integer labelId) {
        this.labelOk = labelId;
    }

    public void setCancelLabelId(Integer labelId) {
        this.labelCancel = labelId;
    }

    @Override
    public String open() {
        super.open();
        return this.input;
    }

    public String getInputText() {
        return this.input;
    }

    @Override
    public final void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent);
        this.createBeforeText(parent);
        this.createText(parent);
        this.createAfterText(parent);
        this.createButtons(parent);
    }

    protected void createBeforeText(Composite parent) {
    }

    protected void createAfterText(Composite parent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createText(Composite parent) {
        if (this.textLabel != null) {
            new Label(parent, 0).setText(this.textLabel + ": ");
        }
        GridData data = new GridData();
        this.text = this.linecount >= 2 ? (!this.nowrap ? new Text(parent, 2626) : new Text(parent, 2818)) : new Text(parent, 2052);
        this.text.setFont(this.font);
        GC gc = new GC((Drawable)this.text);
        try {
            gc.setFont(this.text.getFont());
            FontMetrics fm = gc.getFontMetrics();
            data = new GridData((int)((double)this.colcount * fm.getAverageCharacterWidth()), this.linecount * fm.getHeight());
        }
        finally {
            gc.dispose();
        }
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 4;
        this.text.setLayoutData((Object)data);
        this.text.setEditable(this.editable);
        if (this.initialText != null) {
            this.text.setText(this.initialText);
            if (this.selected) {
                this.text.selectAll();
            }
        }
        UIUtil.disableTabOutput((Control)this.text);
    }

    protected void createButtons(Composite parent) {
        ArrayList<JebDialog.Btn> buttons = new ArrayList<JebDialog.Btn>();
        if (this.labelOk != null) {
            buttons.add(new JebDialog.Btn(32, this.labelOk == -1 ? 605 : this.labelOk));
        }
        if (this.labelCancel != null) {
            buttons.add(new JebDialog.Btn(256, this.labelCancel == -1 ? 105 : this.labelCancel));
        }
        this.createButtons(parent, 0, buttons, 32);
    }

    @Override
    protected void onConfirm() {
        this.input = this.text.getText();
        super.onConfirm();
    }
}

