/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.android.IApkUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerMachineInformation;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerProcessInformation;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerTargetEnumerator;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnitIdentifier;
import com.pnfsoftware.jeb.core.units.code.debug.impl.DebuggerSetupInformation;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.DataFrameView;
import com.pnfsoftware.jeb.rcpclient.handlers.help.HelpUserManualHandler;
import com.pnfsoftware.jeb.rcpclient.util.CTabFolderUtils;
import com.pnfsoftware.jeb.rcpclient.util.DataFrame;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class DbgAttachDialog
extends JebDialog {
    private static final ILogger logger = GlobalLog.getLogger(DbgAttachDialog.class);
    private RcpClientContext context;
    private IDebuggerUnit dbg;
    private IUnit target;
    private List<IDebuggerUnitIdentifier> idents = new ArrayList<IDebuggerUnitIdentifier>();
    private IApkUnit apkunit;
    private List<IDebuggerUnitIdentifier> identifiers = new ArrayList<IDebuggerUnitIdentifier>();
    private List<IDebuggerMachineInformation> machines = new ArrayList<IDebuggerMachineInformation>();
    private DataFrame dfMachines;
    private DataFrameView dfvMachines;
    private List<? extends IDebuggerProcessInformation> processes = new ArrayList<IDebuggerProcessInformation>();
    private DataFrame dfProcesses;
    private DataFrameView dfvProcesses;
    private CTabFolder debugTab;
    private Text widgetHostname;
    private Text widgetPort;
    private Button btnSuspendThreads;
    private Button btnUseChildren;
    private Button btnRefresh;
    private DbgAttachInfo result;

    public DbgAttachDialog(Shell parent, RcpClientContext context, IDebuggerUnit optionalDebuggerUnit, IUnit optionalTargetUnit) {
        super(parent, S.s(234), true, true);
        this.scrolledContainer = true;
        this.setVisualBounds(30, -1, -1, 70);
        this.context = context;
        this.dbg = optionalDebuggerUnit;
        if (this.dbg == null && context != null) {
            this.idents = context.getEnginesContext().getDebuggerUnitIdentifiers();
        }
        for (IUnit unit = this.target = optionalTargetUnit; unit != null; unit = (IUnit)unit.getParent()) {
            if (unit instanceof IApkUnit) {
                this.apkunit = (IApkUnit)unit;
                break;
            }
            if (!(unit.getParent() instanceof IUnit)) break;
        }
    }

    int updateMachinesList() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                block4: {
                    block3: {
                        DbgAttachDialog.this.identifiers.clear();
                        DbgAttachDialog.this.machines.clear();
                        if (DbgAttachDialog.this.dbg == null) break block3;
                        IDebuggerTargetEnumerator ta = DbgAttachDialog.this.dbg.getTargetEnumerator();
                        if (ta == null) break block4;
                        for (IDebuggerMachineInformation iDebuggerMachineInformation : ta.listMachines()) {
                            DbgAttachDialog.this.identifiers.add(null);
                            DbgAttachDialog.this.machines.add(iDebuggerMachineInformation);
                        }
                        break block4;
                    }
                    for (IDebuggerUnitIdentifier ident : DbgAttachDialog.this.idents) {
                        IDebuggerTargetEnumerator iDebuggerTargetEnumerator = ident.getTargetEnumerator();
                        if (iDebuggerTargetEnumerator == null) continue;
                        for (IDebuggerMachineInformation iDebuggerMachineInformation : iDebuggerTargetEnumerator.listMachines()) {
                            DbgAttachDialog.this.identifiers.add(ident);
                            DbgAttachDialog.this.machines.add(iDebuggerMachineInformation);
                        }
                    }
                }
            }
        };
        if (this.context != null) {
            this.context.executeTaskWithPopupDelay(500, "Please wait while debugger information is being gathered...", false, r);
        } else {
            BusyIndicator.showWhile((Display)this.shell.getDisplay(), (Runnable)r);
        }
        return this.machines.size();
    }

    int updateProcessesList(final IDebuggerMachineInformation machine) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                DbgAttachDialog.this.processes = machine.getProcesses();
            }
        };
        if (this.context != null) {
            this.context.executeTaskWithPopupDelay(500, "Please wait while processes information is being gathered...", false, r);
        } else {
            BusyIndicator.showWhile((Display)this.shell.getDisplay(), (Runnable)r);
        }
        return this.processes.size();
    }

    void onTabSelected() {
        this.btnRefresh.setVisible(this.debugTab.getSelectionIndex() == 0);
    }

    void prepareMachineList() {
        if (this.dfMachines == null) {
            this.dfMachines = new DataFrame(S.s(591), S.s(447), S.s(351), S.s(387));
        } else {
            this.dfMachines.clear();
        }
        if (this.updateMachinesList() == 0 && this.apkunit != null) {
            String msg = "No Android device detected!\n\nMake sure that:\n- Your device is connected / emulator is running\n- The Android Debug Bridge tool (adb) is installed and accessible.\n  It is recommended to install the Android SDK or Android Studio with the SDK.\n\nOpen a command prompt and run 'adb devices' to verify the connectivity and status or your Android device(s).";
            UI.warnOptional(this.shell, "Warning", "No Android device detected!\n\nMake sure that:\n- Your device is connected / emulator is running\n- The Android Debug Bridge tool (adb) is installed and accessible.\n  It is recommended to install the Android SDK or Android Studio with the SDK.\n\nOpen a command prompt and run 'adb devices' to verify the connectivity and status or your Android device(s).", "popupDebugAndroidNoDeviceFound");
        }
        for (IDebuggerMachineInformation machine : this.machines) {
            int flags = machine.getFlags();
            String ff = "";
            ff = (flags & 1) != 0 ? ff + "Online" : ff + "Offline";
            this.dfMachines.addRow(machine.getName(), machine.getLocation(), ff, machine.getInformation());
        }
    }

    /*
     * WARNING - void declaration
     */
    String prepareProcessList(IDebuggerMachineInformation machine) {
        void var3_5;
        String pname;
        if (this.dfProcesses == null) {
            this.dfProcesses = new DataFrame(S.s(376), S.s(591), S.s(351));
        } else {
            this.dfProcesses.clear();
        }
        if (machine != null) {
            if (this.updateProcessesList(machine) == 0 && this.apkunit != null) {
                String msg = "No Android process/app was gathered!\n\nMake sure that:\n- Your device is connected / emulator is running\n- The Android Debug Bridge tool (adb) is installed and accessible. It is recommended to install the Android SDK or Android Studio with the SDK.\n\nOpen a command prompt and run 'adb devices' to verify the connectivity and status or your Android device(s).";
                UI.warnOptional(this.shell, "Warning", "No Android process/app was gathered!\n\nMake sure that:\n- Your device is connected / emulator is running\n- The Android Debug Bridge tool (adb) is installed and accessible. It is recommended to install the Android SDK or Android Studio with the SDK.\n\nOpen a command prompt and run 'adb devices' to verify the connectivity and status or your Android device(s).", "popupDebugAndroidNoProcessFound");
            }
            for (IDebuggerProcessInformation iDebuggerProcessInformation : this.processes) {
                int flags = iDebuggerProcessInformation.getFlags();
                String ff = "";
                if ((flags & 1) != 0) {
                    ff = ff + "D";
                }
                this.dfProcesses.addRow(iDebuggerProcessInformation.getId(), iDebuggerProcessInformation.getName(), ff);
            }
        }
        if (this.apkunit != null && !Strings.isBlank(pname = this.apkunit.getPackageName())) {
            return pname;
        }
        StringBuilder suggestedFilter = new StringBuilder();
        IUnit iUnit = this.target;
        while (var3_5 != null) {
            if (!Strings.isBlank(var3_5.getName())) {
                if (suggestedFilter.length() > 0) {
                    suggestedFilter.append("|");
                }
                suggestedFilter.append(var3_5.getName());
            }
            if (!(var3_5.getParent() instanceof IUnit)) break;
            IUnit iUnit2 = (IUnit)var3_5.getParent();
        }
        return suggestedFilter.toString();
    }

    void refreshMachineList() {
        int index = this.dfvMachines.getSelectedRow();
        this.prepareMachineList();
        this.dfvMachines.refresh();
        if (index < this.dfvMachines.getItemCount() && index >= 0) {
            this.dfvMachines.setSelection(index);
        } else if (this.dfvMachines.getItemCount() > 0) {
            this.dfvMachines.setSelection(0);
        }
    }

    void refreshProcessList() {
        int index = this.dfvMachines.getSelectedRow();
        String suggFilter = this.prepareProcessList(index < 0 || index >= this.machines.size() ? null : this.machines.get(index));
        this.dfvProcesses.refresh();
        this.tryAutoSelectProcess(suggFilter);
    }

    @Override
    public DbgAttachInfo open() {
        super.open();
        return this.result;
    }

    @Override
    protected void createContents(Composite parent) {
        this.shell.setMinimumSize(600, 500);
        int autoInitDone = 0;
        UIUtil.setStandardLayout(parent, 3);
        this.debugTab = new CTabFolder(parent, 2048);
        this.debugTab.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(3, true, true));
        CTabFolderUtils.setCTabFolderHeight(this.debugTab, -1);
        CTabItem item = new CTabItem(this.debugTab, 0, 0);
        item.setText(" Debug ");
        Composite tabComposite = new Composite((Composite)this.debugTab, 0);
        UIUtil.setStandardLayout(tabComposite, 3);
        item.setControl((Control)tabComposite);
        autoInitDone = this.createDebugOptions(tabComposite);
        CTabItem item2 = new CTabItem(this.debugTab, 0, 1);
        item2.setText(" Remote Debug ");
        Composite tabComposite2 = new Composite((Composite)this.debugTab, 0);
        UIUtil.setStandardLayout(tabComposite2, 3);
        item2.setControl((Control)tabComposite2);
        this.createRemoteDebugOptions(tabComposite2);
        this.debugTab.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DbgAttachDialog.this.onTabSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.target instanceof IApkUnit || this.target instanceof IDexUnit) {
            this.debugTab.setSelection(0);
        } else if (this.target instanceof INativeCodeUnit) {
            this.debugTab.setSelection(1);
        } else {
            this.debugTab.setSelection(0);
        }
        Group g3 = new Group(parent, 0);
        g3.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(3, true, false));
        g3.setLayout((Layout)new GridLayout(1, false));
        g3.setText("Options");
        this.btnSuspendThreads = UIUtil.createCheckbox((Composite)g3, S.s(760), null);
        this.btnSuspendThreads.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(1, true, false));
        this.btnUseChildren = UIUtil.createCheckbox((Composite)g3, "Allow children debuggers (for Android apps, provide Native debugging)", null);
        this.btnUseChildren.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(1, true, false));
        this.btnUseChildren.setToolTipText("Example: when debugging an Android app with native code, the native code debugger will be a child of the bytecode debugger");
        Composite btns = new Composite(parent, 0);
        btns.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(3, true, false));
        btns.setLayout((Layout)new GridLayout(4, false));
        Button btnAttach = UIUtil.createPushbox(btns, S.s(83), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (DbgAttachDialog.this.tryAttach()) {
                    DbgAttachDialog.this.shell.close();
                }
            }
        });
        UIUtil.createPushbox(btns, S.s(201), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DbgAttachDialog.this.shell.close();
            }
        });
        UIUtil.createPushbox(btns, S.s(365), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                HelpUserManualHandler.openManualPage(DbgAttachDialog.this.context.getBaseDirectory(), DbgAttachDialog.this.apkunit == null ? "debugging" : "android-debugging", false);
            }
        });
        this.btnRefresh = UIUtil.createPushbox(btns, "Refresh Machines List", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DbgAttachDialog.this.refreshMachineList();
                DbgAttachDialog.this.refreshProcessList();
            }
        });
        this.onTabSelected();
        if (autoInitDone == 2) {
            btnAttach.setFocus();
        }
        this.shell.setDefaultButton(btnAttach);
    }

    private int createDebugOptions(Composite parent) {
        int autoInitDone = 0;
        Composite c = new Composite(parent, 0);
        c.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(3, true, true));
        c.setLayout((Layout)new GridLayout(1, false));
        this.prepareMachineList();
        IDebuggerMachineInformation machine = this.machines.isEmpty() ? null : this.machines.get(0);
        String suggestedFilter = this.prepareProcessList(machine);
        Group g0 = new Group(c, 0);
        g0.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        g0.setLayout((Layout)new GridLayout(1, false));
        g0.setText(String.format("%s / %s", S.s(449), S.s(273)));
        this.dfvMachines = new DataFrameView((Composite)g0, this.dfMachines, true);
        this.dfvMachines.addExtraEntriesToContextMenu();
        this.dfvMachines.setLayoutData(UIUtil.createGridDataFillHorizontally());
        if (machine != null) {
            this.dfvMachines.setSelection(0);
            ++autoInitDone;
        }
        Group g1 = new Group(c, 0);
        g1.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(1, true, true));
        g1.setLayout((Layout)new GridLayout(1, false));
        g1.setText(S.s(663));
        this.dfvProcesses = new DataFrameView((Composite)g1, this.dfProcesses, true);
        this.dfvProcesses.addExtraEntriesToContextMenu();
        if (this.tryAutoSelectProcess(suggestedFilter)) {
            ++autoInitDone;
        }
        this.dfvProcesses.setLayoutData(UIUtil.createGridDataSpanHorizontally(1, true, true));
        this.dfvProcesses.refresh();
        this.dfvMachines.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = DbgAttachDialog.this.dfvMachines.getSelectedRow();
                logger.i("Selected: %d", index);
                DbgAttachDialog.this.refreshProcessList();
            }
        });
        this.dfvProcesses.getTableViewer().addDoubleClickListener(new IDoubleClickListener(){

            @Override
            public void doubleClick(DoubleClickEvent event) {
                if (DbgAttachDialog.this.tryAttach()) {
                    DbgAttachDialog.this.shell.close();
                }
            }
        });
        return autoInitDone;
    }

    private void createRemoteDebugOptions(Composite parent) {
        Group g2 = new Group(parent, 0);
        g2.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(3, true, false));
        g2.setLayout((Layout)new GridLayout(2, false));
        g2.setText("Remote Debugging");
        new Label((Composite)g2, 0).setText(S.s(670) + ": ");
        this.widgetHostname = new Text((Composite)g2, 2052);
        this.widgetHostname.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        new Label((Composite)g2, 0).setText(S.s(671) + ": ");
        this.widgetPort = new Text((Composite)g2, 2052);
        this.widgetPort.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
    }

    private boolean tryAutoSelectProcess(String suggestedFilter) {
        String msg;
        if (this.machines.isEmpty()) {
            return false;
        }
        int candcnt = 0;
        if (!Strings.isBlank(suggestedFilter)) {
            this.dfvProcesses.forceFilter(suggestedFilter);
            TableItem[] items = this.dfvProcesses.getTable().getItems();
            for (int i = 0; i < items.length; ++i) {
                if (candcnt == 0) {
                    this.dfvProcesses.setSelection(i);
                }
                ++candcnt;
            }
        }
        if (candcnt == 0 && this.apkunit != null) {
            msg = "No matching Android application was found running on the selected device!\n\nSteps to get you started:\n- If the app is installed on your device, launch it (eg, via the App Drawer) or start one of its components via 'adb shell am'\n  (the Activity Manager also lets you start an app in a suspended mode that waits for the debugger connection before executing)\n- If the app is not installed on your device, install it via 'adb install APPFILE'\n\nDebuggability:\n- If your app is debuggable, you should be able to install, run, and debug it on any device\n- If your app is not debuggable, you will need an emulator or a rooted device to debug it (necessary but not sufficient,\n  there are more caveats to consider when debugging a non-debuggable app, such as the API level - refer to the user manual)\n- An alternative is to let JEB regenarate and sign a debuggable version of the APK.\n  Refer to the --makeapkdebug start-up script option to generate a debuggable version of an APK.";
            UI.warnOptional(this.shell, "Warning", msg, "popupDebugAndroidNoMatchingAppFound");
        }
        if (candcnt == 1 && this.apkunit != null && !this.apkunit.isDebuggable()) {
            msg = "Heads up! The APK loaded in JEB is marked non-debuggable. What about the one running on your device?\n\nIf that same APK is installed and running on your device, you may encounter difficulties debugging it, unless you\nare working with an emulator or rooted device - even then, several caveats apply.\n\nGuidelines on debugging an APK marked non-debuggable:\n- Since your app is not debuggable, you will need an emulator or a rooted device to debug it (necessary but not sufficient,\n  there are more caveats to consider when debugging a non-debuggable app, such as the API level - refer to the user manual)\n- An alternative is to let JEB regenarate and sign a debuggable version of the APK.\n  Refer to the --makeapkdebug start-up script option to generate a debuggable version of an APK.";
            UI.infoOptional(this.shell, "APK Debuggability", msg, "popupDebugAndroidNoDebuggableMatchingAppFound");
        }
        return candcnt == 1;
    }

    private boolean tryAttach() {
        boolean isRemote;
        this.result = null;
        boolean bl = isRemote = this.debugTab.getSelectionIndex() != 0;
        if (!isRemote) {
            int index = this.dfvMachines.getSelectedRow();
            if (index >= 0 && index < this.machines.size()) {
                IDebuggerMachineInformation machine = this.machines.get(index);
                IDebuggerUnitIdentifier ident = this.identifiers.get(index);
                index = this.dfvProcesses.getSelectedRow();
                if (index >= 0 && index < this.processes.size()) {
                    IDebuggerProcessInformation process = this.processes.get(index);
                    this.result = new DbgAttachInfo(DebuggerSetupInformation.create(machine, process), ident);
                }
            }
        } else {
            int port;
            String hostname = this.widgetHostname.getText();
            if (hostname.isEmpty()) {
                hostname = "localhost";
                this.widgetHostname.setText(hostname);
            }
            if ((port = Conversion.stringToInt(this.widgetPort.getText())) != 0) {
                this.result = new DbgAttachInfo(DebuggerSetupInformation.create(hostname, port), null);
            }
        }
        if (this.result == null) {
            MessageDialog.openWarning(this.shell, S.s(405), S.s(406));
            return false;
        }
        this.result.info.setSuspendThreads(this.btnSuspendThreads.getSelection());
        this.result.info.setUseChildrenDebuggers(this.btnUseChildren.getSelection());
        return true;
    }

    public static class DbgAttachInfo {
        public DebuggerSetupInformation info;
        public IDebuggerUnitIdentifier ident;

        DbgAttachInfo(DebuggerSetupInformation info, IDebuggerUnitIdentifier ident) {
            this.info = info;
            this.ident = ident;
        }

        public String toString() {
            return String.format("info=%s,ident=%s", this.info, this.ident);
        }
    }
}

