/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.androsig.gen;

import com.pnf.androsig.gen.DexProcessor;
import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.RuntimeProjectUtil;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethod;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class LibraryGenerator {
    private static final ILogger logger = GlobalLog.getLogger(LibraryGenerator.class);
    private static final int androidSigFileVersion = 1;
    private static final boolean verbose = false;

    public static void generate(IRuntimeProject prj, File sigFolder, String libname) {
        StringBuilder sb = new StringBuilder();
        DexProcessor proc = new DexProcessor();
        LibraryGenerator.record(sb, ";comment=JEB signature file");
        LibraryGenerator.record(sb, ";author=" + Licensing.user_name);
        LibraryGenerator.record(sb, ";version=1");
        LibraryGenerator.record(sb, ";libname=" + libname);
        List dexlist = RuntimeProjectUtil.findUnitsByType((IRuntimeProject)prj, IDexUnit.class, (boolean)false);
        ArrayList<String> lines = new ArrayList<String>();
        for (IDexUnit dex : dexlist) {
            proc.processDex(dex);
            for (Map.Entry<Integer, String> each : proc.getSigMap().entrySet()) {
                if (proc.getAllCallerLists().containsKey(each.getKey())) {
                    lines.add(each.getValue() + "," + LibraryGenerator.transferIndexToName(dex, proc.getAllCallerLists().get(each.getKey())));
                    continue;
                }
                lines.add(each.getValue() + ",");
            }
            for (Map.Entry<Integer, String> each : proc.getHierarchyMap().entrySet()) {
                lines.add(each.getValue());
            }
        }
        Collections.sort(lines);
        for (String line : lines) {
            LibraryGenerator.record(sb, line);
        }
        if (proc.getMethodCount() >= 1) {
            File f = new File(sigFolder, LibraryGenerator.sanitizeFilename(libname) + ".sig");
            logger.info("Saving signatures to file: %s", new Object[]{f});
            try {
                byte[] data = sb.toString().getBytes("UTF-8");
                if (!IO.writeFileSafe((File)f, (byte[])data, (boolean)true)) {
                    logger.error("Could not write signature file!", new Object[0]);
                }
            }
            catch (UnsupportedEncodingException e) {
                logger.catching((Throwable)e);
            }
        }
    }

    private static void record(StringBuilder sb, CharSequence s) {
        sb.append(s);
        sb.append('\n');
    }

    public static String sanitizeFilename(String s) {
        String s2 = "";
        for (int i = 0; i < s.length(); ++i) {
            int c = s.charAt(i);
            s2 = s2 + (char)(c == 45 || Character.isJavaIdentifierPart((char)c) ? c : 95);
        }
        return s2;
    }

    private static String transferIndexToName(IDexUnit dex, Map<Integer, Integer> inputs) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Integer, Integer> each : inputs.entrySet()) {
            sb.append(((IDexMethod)dex.getMethods().get(each.getKey())).getSignature(false)).append("=").append(each.getValue()).append("|");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}

