/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.androsig.apply.model;

import com.pnf.androsig.apply.model.ISignatureFile;
import com.pnf.androsig.apply.model.IndexedSignatureFile;
import com.pnf.androsig.apply.model.SignatureFile;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SignatureFileFactory {
    private final ILogger logger = GlobalLog.getLogger(SignatureFileFactory.class);
    private static final int LIMIT_LOAD = 200;
    private Map<String, ISignatureFile> sigLinePerFilename = new HashMap<String, ISignatureFile>();
    private List<String> loadOrder = new ArrayList<String>();

    public static boolean populate(File sigFile, Map<String, Set<String>> allTightHashcodes, Map<String, Set<String>> allLooseHashcodes, Map<String, Set<String>> allClasses) {
        return IndexedSignatureFile.populate(sigFile, allTightHashcodes, allLooseHashcodes, allClasses);
    }

    private static ISignatureFile getSignatureFile(File sigF) {
        ISignatureFile newSigFile;
        File indexFile = IndexedSignatureFile.getIndexFile(sigF);
        if (indexFile.exists() && ((IndexedSignatureFile)(newSigFile = new IndexedSignatureFile())).loadSignatures(sigF)) {
            return newSigFile;
        }
        newSigFile = new SignatureFile();
        if (((SignatureFile)newSigFile).loadSignatures(sigF)) {
            return newSigFile;
        }
        return null;
    }

    public ISignatureFile getSignatureFile(String file) {
        ISignatureFile sigFile = this.sigLinePerFilename.get(file);
        if (sigFile == null) {
            if (this.loadOrder.size() >= 200) {
                int deleted = 100;
                for (int i = 0; i < deleted; ++i) {
                    this.sigLinePerFilename.remove(this.loadOrder.remove(0));
                }
            }
            File sigF = new File(file);
            sigFile = SignatureFileFactory.getSignatureFile(sigF);
            this.sigLinePerFilename.put(file, sigFile);
        }
        if (sigFile instanceof SignatureFile) {
            this.loadOrder.remove(file);
            this.loadOrder.add(file);
        }
        return sigFile;
    }

    public Map<String, ISignatureFile> getLoadedSignatureFiles() {
        return this.sigLinePerFilename;
    }

    public void close() {
        for (ISignatureFile sig : this.sigLinePerFilename.values()) {
            try {
                sig.close();
            }
            catch (IOException e) {
                this.logger.catchingSilent((Throwable)e);
            }
        }
    }
}

