/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.androsig.apply.model;

import com.pnf.androsig.common.SignatureHandler;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexClass;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexCodeItem;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethod;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethodData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DexHashcodeList {
    private static final String[] EMPTY = new String[]{null, null};
    private Map<Integer, String[]> methodHashcodes = new HashMap<Integer, String[]>();

    public void loadAPKHashcodes(IDexUnit unit) {
        List classes = unit.getClasses();
        if (classes == null || classes.size() == 0) {
            return;
        }
        for (IDexClass eClass : classes) {
            List methods = eClass.getMethods();
            if (methods == null || methods.size() == 0) continue;
            for (IDexMethod m : methods) {
                IDexMethodData md;
                if (!m.isInternal() || (md = m.getData()) == null) continue;
                IDexCodeItem ci = md.getCodeItem();
                if (ci == null) {
                    this.methodHashcodes.put(m.getIndex(), EMPTY);
                    continue;
                }
                this.methodHashcodes.put(m.getIndex(), new String[]{SignatureHandler.generateTightHashcode(ci), SignatureHandler.generateLooseHashcode(ci)});
            }
        }
    }

    public String getTightHashcode(IDexMethod method) {
        String[] hashcodes = this.methodHashcodes.get(method.getIndex());
        return hashcodes == null ? null : hashcodes[0];
    }

    public String getLooseHashcode(IDexMethod method) {
        String[] hashcodes = this.methodHashcodes.get(method.getIndex());
        return hashcodes == null ? null : hashcodes[1];
    }
}

