/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.androsig.apply.matcher;

import com.pnf.androsig.apply.model.MethodSignature;
import com.pnfsoftware.jeb.util.collect.CollectionUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class DatabaseReferenceFile {
    private final ILogger logger = GlobalLog.getLogger(DatabaseReferenceFile.class);
    public String file;
    private Map<String, Integer> versions;
    private List<String> merged = new ArrayList<String>();

    public DatabaseReferenceFile(String file, Map<String, Integer> versions) {
        this.file = file;
        this.versions = versions;
    }

    void mergeVersions(Collection<MethodSignature> values) {
        if (this.versions == null) {
            this.versions = new HashMap<String, Integer>();
        }
        for (MethodSignature value : values) {
            String[] versionsArray = value.getVersions();
            if (versionsArray == null) {
                DatabaseReferenceFile.increment(this.versions, "all");
                continue;
            }
            List<String> versionsList = Arrays.asList(versionsArray);
            if (this.versions.isEmpty()) {
                this.merged.addAll(versionsList);
            } else {
                ArrayList<String> tmp = new ArrayList<String>(CollectionUtil.intersect(versionsList, this.merged));
                if (tmp.isEmpty()) {
                    this.logger.warn("Method %s->%s %s can not be found for current version", new Object[]{value.getCname(), value.getMname(), value.getShorty()});
                } else {
                    this.merged = tmp;
                }
            }
            for (String v : versionsArray) {
                DatabaseReferenceFile.increment(this.versions, v);
            }
        }
    }

    static void increment(Map<String, Integer> versionOccurences, String key) {
        Integer val = versionOccurences.get(key);
        if (val == null) {
            versionOccurences.put(key, 1);
        } else {
            versionOccurences.put(key, val + 1);
        }
    }

    boolean hasNoVersion() {
        return this.versions == null || this.versions.size() == 1 && this.versions.containsKey("all");
    }

    public List<String> getMergedVersions() {
        return this.merged;
    }

    public Set<String> getAvailableVersions() {
        if (this.merged != null && !this.merged.isEmpty()) {
            return new HashSet<String>(this.merged);
        }
        if (this.hasNoVersion()) {
            return null;
        }
        return this.versions.keySet();
    }

    List<List<String>> getOrderedVersions() {
        if (this.hasNoVersion()) {
            return new ArrayList<List<String>>();
        }
        Map versionsRev = this.versions.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toList())));
        versionsRev = new TreeMap(versionsRev);
        ArrayList<List<String>> ordered = new ArrayList<List<String>>();
        VersionComparator vsCmp = new VersionComparator();
        for (Map.Entry entry : versionsRev.entrySet()) {
            ArrayList vs = new ArrayList(entry.getValue());
            Collections.sort(vs, vsCmp);
            Collections.reverse(vs);
            ordered.add(vs);
        }
        Collections.reverse(ordered);
        return ordered;
    }

    public Set<String> getReducedVersions() {
        TreeSet<String> versionList = new TreeSet<String>(new VersionComparator());
        for (String v : this.merged) {
            versionList.add(v.replace("_d8r", "").replace("_d8d", "").replace("_d8", ""));
        }
        return versionList;
    }

    private static class VersionComparator
    implements Comparator<String> {
        private VersionComparator() {
        }

        @Override
        public int compare(String v1, String v2) {
            boolean v1Test = Strings.contains((String)v1.toLowerCase(), (String[])new String[]{"rc", "alpha", "beta", "snapshot"});
            boolean v2Test = Strings.contains((String)v1.toLowerCase(), (String[])new String[]{"rc", "alpha", "beta", "snapshot"});
            if (v1Test) {
                return v2Test ? v1.compareTo(v2) : 1;
            }
            return v2Test ? -1 : v1.compareTo(v2);
        }
    }
}

