/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.installer;

import com.pnfsoftware.jeb.installer.IO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IniFileEditor {
    File file;
    List<String> lines;

    public IniFileEditor(File file) throws IOException {
        this.file = file;
        this.load();
    }

    private void load() throws IOException {
        this.lines = IO.readLines(new FileInputStream(this.file), Charset.defaultCharset());
    }

    public void update() throws IOException {
        this.write(this.file);
    }

    public void write(File newFile) throws IOException {
        IO.writeLines(new FileOutputStream(newFile), this.lines, Charset.defaultCharset());
    }

    public List<String> getSectionNames() {
        ArrayList<String> r = new ArrayList<String>();
        for (int i = 0; i < this.lines.size(); ++i) {
            String line = this.lines.get(i).trim();
            if (!line.startsWith("[") || !line.endsWith("]")) continue;
            r.add(line.substring(1, line.length() - 1));
        }
        return r;
    }

    public List<String> getSectionContents(String sectionName) {
        int[] linenums = this.getSection(sectionName, false);
        if (linenums == null) {
            return Collections.emptyList();
        }
        ArrayList<String> r = new ArrayList<String>();
        for (String line : this.lines.subList(linenums[0], linenums[1])) {
            if ((line = line.trim()).isEmpty()) continue;
            r.add(line);
        }
        return r;
    }

    public void setSectionContents(String sectionName, List<String> contents) {
        int[] linenums = this.getSection(sectionName, true);
        int start = linenums[0];
        int end = linenums[1];
        if (start < this.lines.size()) {
            int cnt = end - start;
            while (cnt-- > 0) {
                this.lines.remove(start);
            }
        }
        for (String line : contents) {
            if ((line = line.trim()).isEmpty()) continue;
            this.lines.add(start, line);
            ++start;
        }
        this.lines.add(start, "");
    }

    private int[] getSection(String sectionName, boolean createIfNotExist) {
        String line;
        int i;
        String target = "[" + sectionName + "]";
        int start = -1;
        int end = -1;
        for (i = 0; i < this.lines.size(); ++i) {
            line = this.lines.get(i).trim();
            if (!line.equals(target)) continue;
            start = i + 1;
            break;
        }
        if (start < 0) {
            if (!createIfNotExist) {
                return null;
            }
            this.lines.add(target);
            start = this.lines.size();
        }
        for (i = start; i < this.lines.size(); ++i) {
            line = this.lines.get(i).trim();
            if (!line.startsWith("[")) continue;
            end = i;
            break;
        }
        if (end < 0) {
            end = this.lines.size();
        }
        return new int[]{start, end};
    }

    public String getValue(String sectionName, String keyName) {
        return this.getValue(sectionName, keyName, "=");
    }

    public String getValue(String sectionName, String keyName, String delimiter) {
        for (String line : this.getSectionContents(sectionName)) {
            String key;
            int pos = line.indexOf(delimiter);
            if (pos < 0 || !(key = line.substring(0, pos).trim()).equals(keyName)) continue;
            return line.substring(pos + delimiter.length()).trim();
        }
        return null;
    }

    public boolean setValue(String sectionName, String keyName, String value) {
        return this.setValue(sectionName, keyName, value, "=");
    }

    public boolean setValue(String sectionName, String keyName, String value, String delimiter) {
        int i;
        List<String> contents = this.getSectionContents(sectionName);
        for (i = 0; i < contents.size(); ++i) {
            String key;
            String line = contents.get(i);
            int pos = line.indexOf(delimiter);
            if (pos < 0 || !(key = line.substring(0, pos).trim()).equals(keyName)) continue;
            String currentValue = line.substring(pos + delimiter.length()).trim();
            if (currentValue.equals(value)) {
                return false;
            }
            contents.set(i, keyName + delimiter + value);
            break;
        }
        if (i >= contents.size()) {
            contents.add(keyName + delimiter + value);
        }
        this.setSectionContents(sectionName, contents);
        return true;
    }
}

