/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.installer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.Date;

public class Formatter {
    public static String formatBinaryBlock(byte[] data, int offset, int size, int offset_delta) {
        int sizeproc;
        StringBuilder sb = new StringBuilder();
        int pos = offset;
        for (int sizeleft = size; sizeleft > 0; sizeleft -= sizeproc) {
            int j;
            sb.append(String.format("%08X  ", pos - offset_delta));
            for (j = 0; j < 16 && j < sizeleft; ++j) {
                sb.append(String.format("%02X ", data[pos + j]));
            }
            sizeproc = j;
            while (j < 16) {
                sb.append("   ");
                ++j;
            }
            sb.append(" ");
            for (j = 0; j < sizeproc; ++j) {
                byte b = data[pos + j];
                if (b >= 32 && b < 127) {
                    sb.append((char)b);
                    continue;
                }
                sb.append(".");
            }
            sb.append("\n");
            pos += sizeproc;
        }
        return sb.toString();
    }

    public static String formatBinaryBlock(byte[] data, int offset, int size) {
        return Formatter.formatBinaryBlock(data, offset, size, 0);
    }

    public static String formatBinaryBlock(byte[] data) {
        return Formatter.formatBinaryBlock(data, 0, data.length, 0);
    }

    public static String formatBinaryLine(byte[] data, int offset, int size, int padding) {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < size; ++i) {
            sb.append(String.format("%02X ", data[offset + i]));
        }
        while (i < padding) {
            sb.append("   ");
            ++i;
        }
        return sb.toString();
    }

    public static String formatBinaryLine(byte[] data) {
        return Formatter.formatBinaryLine(data, 0, data.length, 0);
    }

    public static String byteArrayToHexString(byte[] data) {
        return Formatter.byteArrayToHexString(data, 0, data.length);
    }

    public static String byteArrayToHexString(byte[] data, int pos) {
        return Formatter.byteArrayToHexString(data, pos, data.length);
    }

    public static String byteArrayToHexString(byte[] data, int pos, int end) {
        if (data == null || pos < 0 || end > data.length || pos > end) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = pos; i < end; ++i) {
            sb.append(String.format("%02X", data[i]));
        }
        return sb.toString();
    }

    public static byte[] hexStringToByteArray(String s) {
        if (s.length() % 2 != 0) {
            return null;
        }
        int n = s.length() / 2;
        byte[] r = new byte[n];
        for (int i = 0; i < n; ++i) {
            try {
                int v = Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16);
                r[i] = (byte)v;
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return r;
    }

    public static boolean isPrintableChar(char c) {
        if (!Character.isISOControl(c)) {
            Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
            return block != null && block != Character.UnicodeBlock.SPECIALS;
        }
        return false;
    }

    public static String escapeCharacter(char c, boolean keep_unicode_printables) {
        if (c == '\'') {
            return "\\'";
        }
        if (c == '\"') {
            return "\\\"";
        }
        if (c == '\\') {
            return "\\\\";
        }
        if (keep_unicode_printables && Formatter.isPrintableChar(c)) {
            return Character.toString(c);
        }
        if (c >= '\u007f') {
            return String.format("\\u%04X", (short)c);
        }
        if (c >= ' ') {
            return Character.toString(c);
        }
        if (c == '\n') {
            return "\\n";
        }
        if (c == '\r') {
            return "\\r";
        }
        if (c == '\t') {
            return "\\t";
        }
        if (c == '\b') {
            return "\\b";
        }
        if (c == '\f') {
            return "\\f";
        }
        return String.format("\\u%04X", (short)c);
    }

    public static String escapeString(String s, boolean keep_unicode_printables) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            sb.append(Formatter.escapeCharacter(c, keep_unicode_printables));
        }
        return sb.toString();
    }

    public static String formatTimestamp(long unix_timestamp_ms) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(unix_timestamp_ms));
        return String.format("%04d/%02d/%02d-%02d:%02d:%02d", cal.get(1), 1 + cal.get(2), cal.get(5), cal.get(11), cal.get(12), cal.get(13));
    }

    public static String formatTimestampDelta(long delta_ms) {
        long v;
        long t;
        String s = "";
        if (delta_ms < 0L) {
            s = "-";
            delta_ms = -delta_ms;
        }
        if ((t = delta_ms / 1000L) >= 86400L) {
            v = t / 86400L;
            t %= 86400L;
            s = s + String.format("%dd ", v);
        }
        if (t >= 3600L) {
            v = t / 3600L;
            t %= 3600L;
            s = s + String.format("%dh ", v);
        }
        if (t >= 60L) {
            v = t / 60L;
            t %= 60L;
            s = s + String.format("%dm ", v);
        }
        s = s + String.format("%ds", t);
        return s;
    }

    public static String formatStacktrace(Throwable t) {
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        t.printStackTrace(out);
        return ((Object)writer).toString();
    }
}

