/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.revisions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.text.source.ILineRange;

public final class RevisionRange
implements ILineRange {
    private final Revision fRevision;
    private final int fStartLine;
    private final int fNumberOfLines;

    RevisionRange(Revision revision, ILineRange range) {
        Assert.isLegal(revision != null);
        this.fRevision = revision;
        this.fStartLine = range.getStartLine();
        this.fNumberOfLines = range.getNumberOfLines();
    }

    public Revision getRevision() {
        return this.fRevision;
    }

    @Override
    public int getStartLine() {
        return this.fStartLine;
    }

    @Override
    public int getNumberOfLines() {
        return this.fNumberOfLines;
    }

    public String toString() {
        return "RevisionRange [" + this.fRevision.toString() + ", [" + this.getStartLine() + "+" + this.getNumberOfLines() + ")]";
    }
}

