/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.internal.InternalPolicy;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageFileNameProvider;

class FileImageDescriptor
extends ImageDescriptor {
    private Class<?> location;
    private String name;

    FileImageDescriptor(Class<?> clazz, String filename) {
        this.location = clazz;
        this.name = filename;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FileImageDescriptor)) {
            return false;
        }
        FileImageDescriptor other = (FileImageDescriptor)o;
        if (this.location != null ? !this.location.equals(other.location) : other.location != null) {
            return false;
        }
        return this.name.equals(other.name);
    }

    @Override
    public ImageData getImageData(int zoom) {
        ImageData result;
        block13: {
            InputStream in = this.getStream(zoom);
            result = null;
            if (in != null) {
                try {
                    try {
                        result = new ImageData(in);
                    }
                    catch (SWTException e) {
                        if (e.code != 40) {
                            throw e;
                        }
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    private InputStream getStream(int zoom) {
        String xName = FileImageDescriptor.getxName(this.name, zoom);
        if (xName == null) {
            return null;
        }
        InputStream is = null;
        if (this.location != null) {
            is = this.location.getResourceAsStream(xName);
        } else {
            try {
                is = new FileInputStream(xName);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        if (is == null) {
            return null;
        }
        return new BufferedInputStream(is);
    }

    static String getxName(String name, int zoom) {
        if (zoom == 100) {
            return name;
        }
        int dot = name.lastIndexOf(46);
        if (dot != -1 && (zoom == 150 || zoom == 200)) {
            String lead = name.substring(0, dot);
            String tail = name.substring(dot);
            if (InternalPolicy.DEBUG_LOAD_URL_IMAGE_DESCRIPTOR_2x_PNG_FOR_GIF && ".gif".equalsIgnoreCase(tail)) {
                tail = ".png";
            }
            String x = zoom == 150 ? "@1.5x" : "@2x";
            String file = String.valueOf(lead) + x + tail;
            return file;
        }
        return null;
    }

    public int hashCode() {
        int code = this.name.hashCode();
        if (this.location != null) {
            code += this.location.hashCode();
        }
        return code;
    }

    public String toString() {
        return "FileImageDescriptor(location=" + this.location + ", name=" + this.name + ")";
    }

    @Override
    public Image createImage(boolean returnMissingImageOnError, Device device) {
        String path;
        if (InternalPolicy.DEBUG_LOAD_URL_IMAGE_DESCRIPTOR_2x) {
            try {
                return new Image(device, (ImageFileNameProvider)new ImageProvider());
            }
            catch (SWTException sWTException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if ((path = this.getFilePath(this.name, true)) == null) {
            return this.createDefaultImage(returnMissingImageOnError, device);
        }
        try {
            return new Image(device, path);
        }
        catch (SWTException sWTException) {
            return super.createImage(returnMissingImageOnError, device);
        }
    }

    private Image createDefaultImage(boolean returnMissingImageOnError, Device device) {
        try {
            if (returnMissingImageOnError) {
                return new Image(device, DEFAULT_IMAGE_DATA);
            }
        }
        catch (SWTException sWTException) {
            return null;
        }
        return null;
    }

    String getFilePath(String name, boolean logIOException) {
        if (this.location == null) {
            return new Path(name).toOSString();
        }
        URL resource = this.location.getResource(name);
        if (resource == null) {
            return null;
        }
        try {
            if (!InternalPolicy.OSGI_AVAILABLE) {
                return new Path(resource.getFile()).toOSString();
            }
            return new Path(FileLocator.toFileURL(resource).getPath()).toOSString();
        }
        catch (IOException e) {
            if (logIOException) {
                Policy.logException(e);
            } else if (InternalPolicy.DEBUG_LOG_URL_IMAGE_DESCRIPTOR_MISSING_2x && (name.endsWith("@2x.png") || name.endsWith("@1.5x.png"))) {
                String message = "High-resolution image missing: " + this.location + ' ' + name;
                Policy.getLog().log(new Status(2, "org.eclipse.jface", message, e));
            }
            return null;
        }
    }

    private class ImageProvider
    implements ImageFileNameProvider {
        private ImageProvider() {
        }

        public String getImagePath(int zoom) {
            String xName = FileImageDescriptor.getxName(FileImageDescriptor.this.name, zoom);
            if (xName != null) {
                return FileImageDescriptor.this.getFilePath(xName, zoom == 100);
            }
            return null;
        }
    }
}

