/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.property.value;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.list.AbstractObservableList;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IPropertyObservable;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.SimplePropertyEvent;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;
import org.eclipse.core.internal.databinding.identity.IdentityMap;
import org.eclipse.core.internal.databinding.identity.IdentityObservableSet;
import org.eclipse.core.internal.databinding.identity.IdentitySet;
import org.eclipse.core.internal.databinding.property.Util;

public class ListSimpleValueObservableList<S, M extends S, T>
extends AbstractObservableList<T>
implements IPropertyObservable<SimpleValueProperty<S, T>> {
    private IObservableList<M> masterList;
    private SimpleValueProperty<S, T> detailProperty;
    private IObservableSet<M> knownMasterElements;
    private Map<M, T> cachedValues;
    private Set<M> staleElements;
    private boolean updating;
    private IListChangeListener<M> masterListener = new IListChangeListener<M>(){

        @Override
        public void handleListChange(ListChangeEvent<? extends M> event) {
            if (!ListSimpleValueObservableList.this.isDisposed()) {
                this.updateKnownElements();
                ListSimpleValueObservableList.this.fireListChange(this.convertDiff(event.diff));
            }
        }

        private void updateKnownElements() {
            IdentitySet identityKnownElements = new IdentitySet(ListSimpleValueObservableList.this.masterList);
            ListSimpleValueObservableList.this.knownMasterElements.retainAll(identityKnownElements);
            ListSimpleValueObservableList.this.knownMasterElements.addAll(identityKnownElements);
        }

        private ListDiff<T> convertDiff(ListDiff<? extends M> diff) {
            ListDiffEntry<? extends M>[] masterEntries = diff.getDifferences();
            ArrayList detailEntries = new ArrayList(masterEntries.length);
            ListDiffEntry<? extends M>[] listDiffEntryArray = masterEntries;
            int n = masterEntries.length;
            int n2 = 0;
            while (n2 < n) {
                ListDiffEntry masterDifference = listDiffEntryArray[n2];
                int index = masterDifference.getPosition();
                boolean addition = masterDifference.isAddition();
                Object masterElement = masterDifference.getElement();
                Object elementDetailValue = ListSimpleValueObservableList.this.detailProperty.getValue(masterElement);
                detailEntries.add(Diffs.createListDiffEntry(index, addition, elementDetailValue));
                ++n2;
            }
            return Diffs.createListDiff(detailEntries);
        }
    };
    private IStaleListener staleListener = staleEvent -> this.fireStale();
    private INativePropertyListener<S> detailListener;

    public ListSimpleValueObservableList(IObservableList<M> masterList, SimpleValueProperty<S, T> valueProperty) {
        super(masterList.getRealm());
        this.masterList = masterList;
        this.detailProperty = valueProperty;
        ISimplePropertyListener listener = event -> {
            if (!this.isDisposed() && !this.updating) {
                this.getRealm().exec(() -> {
                    Object source = event.getSource();
                    if (simplePropertyEvent.type == SimplePropertyEvent.CHANGE) {
                        this.notifyIfChanged(source);
                    } else if (simplePropertyEvent.type == SimplePropertyEvent.STALE) {
                        boolean wasStale = !this.staleElements.isEmpty();
                        this.staleElements.add(source);
                        if (!wasStale) {
                            this.fireStale();
                        }
                    }
                });
            }
        };
        this.detailListener = this.detailProperty.adaptListener(listener);
    }

    @Override
    protected void firstListenerAdded() {
        ObservableTracker.setIgnore(true);
        try {
            this.knownMasterElements = new IdentityObservableSet<M>(this.getRealm(), null);
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
        this.cachedValues = new IdentityMap<M, T>();
        this.staleElements = new IdentitySet<M>();
        this.knownMasterElements.addSetChangeListener(event -> {
            for (Object key1 : event.diff.getRemovals()) {
                if (this.detailListener != null) {
                    this.detailListener.removeFrom(key1);
                }
                this.cachedValues.remove(key1);
                this.staleElements.remove(key1);
            }
            for (Object key2 : event.diff.getAdditions()) {
                this.cachedValues.put(key2, this.detailProperty.getValue(key2));
                if (this.detailListener == null) continue;
                this.detailListener.addTo(key2);
            }
        });
        this.getRealm().exec(() -> {
            this.knownMasterElements.addAll(this.masterList);
            this.masterList.addListChangeListener(this.masterListener);
            this.masterList.addStaleListener(this.staleListener);
        });
    }

    @Override
    protected void lastListenerRemoved() {
        if (this.masterList != null) {
            this.masterList.removeListChangeListener(this.masterListener);
            this.masterList.removeStaleListener(this.staleListener);
        }
        if (this.knownMasterElements != null) {
            this.knownMasterElements.dispose();
            this.knownMasterElements = null;
        }
        if (this.cachedValues != null) {
            this.cachedValues.clear();
            this.cachedValues = null;
        }
        if (this.staleElements != null) {
            this.staleElements.clear();
            this.staleElements = null;
        }
    }

    @Override
    protected int doGetSize() {
        this.getterCalled();
        return this.masterList.size();
    }

    private void getterCalled() {
        ObservableTracker.getterCalled(this);
    }

    @Override
    public Object getElementType() {
        return this.detailProperty.getValueType();
    }

    @Override
    public T get(int index) {
        this.getterCalled();
        M masterElement = this.masterList.get(index);
        return this.detailProperty.getValue(masterElement);
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        this.getterCalled();
        for (M m : this.masterList) {
            if (!Util.equals(this.detailProperty.getValue(m), o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        this.getterCalled();
        return this.masterList.isEmpty();
    }

    @Override
    public boolean isStale() {
        this.getterCalled();
        return this.masterList.isStale() || this.staleElements != null && !this.staleElements.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        this.getterCalled();
        return new Iterator<T>(){
            Iterator<M> it;
            {
                this.it = ListSimpleValueObservableList.this.masterList.iterator();
            }

            @Override
            public boolean hasNext() {
                ListSimpleValueObservableList.this.getterCalled();
                return this.it.hasNext();
            }

            @Override
            public T next() {
                ListSimpleValueObservableList.this.getterCalled();
                Object masterElement = this.it.next();
                return ListSimpleValueObservableList.this.detailProperty.getValue(masterElement);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public T move(int oldIndex, int newIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        this.getterCalled();
        Object[] masterElements = this.masterList.toArray();
        Object[] result = new Object[masterElements.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.detailProperty.getValue(masterElements[i]);
            ++i;
        }
        return result;
    }

    @Override
    public <V> V[] toArray(V[] a) {
        this.getterCalled();
        Object[] masterElements = this.masterList.toArray();
        if (a.length < masterElements.length) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), masterElements.length);
        }
        int i = 0;
        while (i < masterElements.length) {
            a[i] = this.detailProperty.getValue(masterElements[i]);
            ++i;
        }
        return a;
    }

    @Override
    public void add(int index, Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        this.getterCalled();
        return new ListIterator<T>(index){
            ListIterator<M> it;
            M lastMasterElement;
            T lastElement;
            boolean haveIterated;
            {
                this.it = ListSimpleValueObservableList.this.masterList.listIterator(n);
                this.haveIterated = false;
            }

            @Override
            public void add(Object arg0) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                ListSimpleValueObservableList.this.getterCalled();
                return this.it.hasNext();
            }

            @Override
            public boolean hasPrevious() {
                ListSimpleValueObservableList.this.getterCalled();
                return this.it.hasPrevious();
            }

            @Override
            public T next() {
                ListSimpleValueObservableList.this.getterCalled();
                this.lastMasterElement = this.it.next();
                this.lastElement = ListSimpleValueObservableList.this.detailProperty.getValue(this.lastMasterElement);
                this.haveIterated = true;
                return this.lastElement;
            }

            @Override
            public int nextIndex() {
                ListSimpleValueObservableList.this.getterCalled();
                return this.it.nextIndex();
            }

            @Override
            public T previous() {
                ListSimpleValueObservableList.this.getterCalled();
                this.lastMasterElement = this.it.previous();
                this.lastElement = ListSimpleValueObservableList.this.detailProperty.getValue(this.lastMasterElement);
                this.haveIterated = true;
                return this.lastElement;
            }

            @Override
            public int previousIndex() {
                ListSimpleValueObservableList.this.getterCalled();
                return this.it.previousIndex();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(T o) {
                ListSimpleValueObservableList.this.checkRealm();
                if (!this.haveIterated) {
                    throw new IllegalStateException();
                }
                boolean wasUpdating = ListSimpleValueObservableList.this.updating;
                ListSimpleValueObservableList.this.updating = true;
                try {
                    ListSimpleValueObservableList.this.detailProperty.setValue(this.lastMasterElement, o);
                }
                finally {
                    ListSimpleValueObservableList.this.updating = wasUpdating;
                }
                ListSimpleValueObservableList.this.notifyIfChanged(this.lastMasterElement);
                this.lastElement = o;
            }
        };
    }

    private void notifyIfChanged(M masterElement) {
        Object newValue;
        T oldValue;
        if (this.cachedValues != null && (!Util.equals(oldValue = this.cachedValues.get(masterElement), newValue = this.detailProperty.getValue(masterElement)) || this.staleElements.contains(masterElement))) {
            this.cachedValues.put(masterElement, newValue);
            this.staleElements.remove(masterElement);
            this.fireListChange(this.indicesOf(masterElement), oldValue, newValue);
        }
    }

    private int[] indicesOf(Object masterElement) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        ListIterator<M> it = this.masterList.listIterator();
        while (it.hasNext()) {
            if (masterElement != it.next()) continue;
            indices.add(it.previousIndex());
        }
        int[] result = new int[indices.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (Integer)indices.get(i);
            ++i;
        }
        return result;
    }

    private void fireListChange(int[] indices, T oldValue, T newValue) {
        ArrayList<ListDiffEntry<ListDiffEntry<T>>> differences = new ArrayList<ListDiffEntry<ListDiffEntry<T>>>(indices.length * 2);
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            differences.add(Diffs.createListDiffEntry(index, false, oldValue));
            differences.add(Diffs.createListDiffEntry(index, true, newValue));
            ++n2;
        }
        this.fireListChange(Diffs.createListDiff(differences));
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T set(int index, T o) {
        this.checkRealm();
        M masterElement = this.masterList.get(index);
        Object oldValue = this.detailProperty.getValue(masterElement);
        boolean wasUpdating = this.updating;
        this.updating = true;
        try {
            this.detailProperty.setValue(masterElement, o);
        }
        finally {
            this.updating = wasUpdating;
        }
        this.notifyIfChanged(masterElement);
        return oldValue;
    }

    @Override
    public Object getObserved() {
        return this.masterList;
    }

    @Override
    public SimpleValueProperty<S, T> getProperty() {
        return this.detailProperty;
    }

    @Override
    public synchronized void dispose() {
        if (this.knownMasterElements != null) {
            this.knownMasterElements.clear();
            this.knownMasterElements.dispose();
            this.knownMasterElements = null;
        }
        if (this.masterList != null) {
            this.masterList.removeListChangeListener(this.masterListener);
            this.masterList = null;
        }
        this.masterListener = null;
        this.detailListener = null;
        this.detailProperty = null;
        this.cachedValues = null;
        this.staleElements = null;
        super.dispose();
    }
}

