/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.BindingStatus;
import org.eclipse.core.internal.databinding.Util;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

class ValueBinding<M, T>
extends Binding {
    private final UpdateValueStrategy<? super T, ? extends M> targetToModel;
    private final UpdateValueStrategy<? super M, ? extends T> modelToTarget;
    private WritableValue<IStatus> validationStatusObservable;
    private IObservableValue<T> target;
    private IObservableValue<M> model;
    private boolean updatingTarget;
    private boolean updatingModel;
    private IValueChangeListener<T> targetChangeListener = new IValueChangeListener<T>(){

        @Override
        public void handleValueChange(ValueChangeEvent<? extends T> event) {
            if (!ValueBinding.this.updatingTarget && !Util.equals(event.diff.getOldValue(), event.diff.getNewValue())) {
                ValueBinding.this.doUpdate(ValueBinding.this.target, ValueBinding.this.model, ValueBinding.this.targetToModel, false, false);
            }
        }
    };
    private IValueChangeListener<M> modelChangeListener = new IValueChangeListener<M>(){

        @Override
        public void handleValueChange(ValueChangeEvent<? extends M> event) {
            if (!ValueBinding.this.updatingModel && !Util.equals(event.diff.getOldValue(), event.diff.getNewValue())) {
                ValueBinding.this.doUpdate(ValueBinding.this.model, ValueBinding.this.target, ValueBinding.this.modelToTarget, false, false);
            }
        }
    };

    public ValueBinding(IObservableValue<T> targetObservableValue, IObservableValue<M> modelObservableValue, UpdateValueStrategy<? super T, ? extends M> targetToModel, UpdateValueStrategy<? super M, ? extends T> modelToTarget) {
        super(targetObservableValue, modelObservableValue);
        this.target = targetObservableValue;
        this.model = modelObservableValue;
        this.targetToModel = targetToModel;
        this.modelToTarget = modelToTarget;
    }

    @Override
    protected void preInit() {
        ObservableTracker.setIgnore(true);
        try {
            this.validationStatusObservable = new WritableValue<IStatus>(this.context.getValidationRealm(), Status.OK_STATUS, IStatus.class);
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
    }

    @Override
    protected void postInit() {
        if (this.modelToTarget.getUpdatePolicy() == UpdateValueStrategy.POLICY_UPDATE) {
            this.model.addValueChangeListener(this.modelChangeListener);
            this.updateModelToTarget();
        } else if (this.modelToTarget.getUpdatePolicy() == UpdateValueStrategy.POLICY_CONVERT) {
            this.model.addValueChangeListener(this.modelChangeListener);
            this.validateModelToTarget();
        } else {
            this.modelChangeListener = null;
        }
        if (this.targetToModel.getUpdatePolicy() == UpdateValueStrategy.POLICY_UPDATE) {
            this.target.addValueChangeListener(this.targetChangeListener);
            if (this.modelToTarget.getUpdatePolicy() == UpdateValueStrategy.POLICY_NEVER) {
                this.updateTargetToModel();
            } else {
                this.validateTargetToModel();
            }
        } else if (this.targetToModel.getUpdatePolicy() == UpdateValueStrategy.POLICY_CONVERT) {
            this.target.addValueChangeListener(this.targetChangeListener);
            this.validateTargetToModel();
        } else {
            this.targetChangeListener = null;
        }
    }

    @Override
    public IObservableValue<IStatus> getValidationStatus() {
        return this.validationStatusObservable;
    }

    @Override
    public void updateTargetToModel() {
        this.doUpdate(this.target, this.model, this.targetToModel, true, false);
    }

    @Override
    public void updateModelToTarget() {
        this.doUpdate(this.model, this.target, this.modelToTarget, true, false);
    }

    boolean mergeStatus(MultiStatus multiStatus, IStatus newStatus) {
        if (!newStatus.isOK()) {
            multiStatus.add(newStatus);
            return multiStatus.getSeverity() < 4;
        }
        return true;
    }

    private <S, D1, D2 extends D1> void doUpdate(IObservableValue<S> source, IObservableValue<D1> destination, UpdateValueStrategy<? super S, D2> updateValueStrategy, boolean explicit, boolean validateOnly) {
        int policy = updateValueStrategy.getUpdatePolicy();
        if (policy == UpdateValueStrategy.POLICY_NEVER) {
            return;
        }
        if (policy == UpdateValueStrategy.POLICY_ON_REQUEST && !explicit) {
            return;
        }
        source.getRealm().exec(() -> {
            boolean destinationRealmReached = false;
            BindingStatus multiStatus = BindingStatus.ok();
            try {
                Object value = source.getValue();
                IStatus status = updateValueStrategy.validateAfterGet(value);
                if (!this.mergeStatus(multiStatus, status)) {
                    return;
                }
                Object convertedValue = updateValueStrategy.convert(value);
                status = updateValueStrategy.validateAfterConvert(convertedValue);
                if (!this.mergeStatus(multiStatus, status)) {
                    return;
                }
                if (policy == UpdateValueStrategy.POLICY_CONVERT && !explicit) {
                    return;
                }
                status = updateValueStrategy.validateBeforeSet(convertedValue);
                if (!this.mergeStatus(multiStatus, status)) {
                    return;
                }
                if (validateOnly) {
                    return;
                }
                try {
                    destinationRealmReached = true;
                    destination.getRealm().exec(() -> {
                        if (destination == this.target) {
                            this.updatingTarget = true;
                        } else {
                            this.updatingModel = true;
                        }
                        try {
                            IStatus setterStatus = updateValueStrategy.doSet(destination, convertedValue);
                            this.mergeStatus(multiStatus, setterStatus);
                        }
                        finally {
                            if (destination == this.target) {
                                this.updatingTarget = false;
                            } else {
                                this.updatingModel = false;
                            }
                            this.setValidationStatus(multiStatus);
                        }
                    });
                }
                catch (Exception ex) {
                    String message = ex.getMessage() != null ? ex.getMessage() : "";
                    this.mergeStatus(multiStatus, new Status(4, "org.eclipse.core.databinding", 4, message, ex));
                }
            }
            finally {
                if (!destinationRealmReached) {
                    this.setValidationStatus(multiStatus);
                }
            }
        });
    }

    @Override
    public void validateModelToTarget() {
        this.doUpdate(this.model, this.target, this.modelToTarget, true, true);
    }

    @Override
    public void validateTargetToModel() {
        this.doUpdate(this.target, this.model, this.targetToModel, true, true);
    }

    private void setValidationStatus(IStatus status) {
        this.validationStatusObservable.getRealm().exec(() -> this.validationStatusObservable.setValue(status));
    }

    @Override
    public void dispose() {
        if (this.targetChangeListener != null) {
            this.target.removeValueChangeListener(this.targetChangeListener);
            this.targetChangeListener = null;
        }
        if (this.modelChangeListener != null) {
            this.model.removeValueChangeListener(this.modelChangeListener);
            this.modelChangeListener = null;
        }
        this.target = null;
        this.model = null;
        super.dispose();
    }
}

