/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jebglobal;

import com.pnfsoftware.jeb.core.exceptions.InterruptionException;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.INativeCodeAdvancedAnalyzer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.NativeDecompilationStage;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.TargetProperties;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.exceptions.UnsupportedConversionException;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodDataItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.util.concurrent.ACLock;
import com.pnfsoftware.jeb.util.format.TimeFormatter;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import com.pnfsoftware.jebglobal.Qn;
import com.pnfsoftware.jebglobal.Sk;
import com.pnfsoftware.jebglobal.WI;
import com.pnfsoftware.jebglobal.Yo;
import com.pnfsoftware.jebglobal.kL;
import com.pnfsoftware.jebglobal.xs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

@Ser
public class x<InsnType extends IInstruction>
implements INativeCodeAdvancedAnalyzer<InsnType> {
    private static final ILogger lS = GlobalLog.getLogger(x.class);
    @SerId(value=1)
    Yo<InsnType> eO;
    @SerId(value=2)
    Qn<InsnType> Le;
    @SerTransient
    volatile boolean Qx;

    public x(Yo<InsnType> yo, Qn<InsnType> qn2) {
        this.eO = yo;
        this.Le = qn2;
    }

    @Override
    public void perform() {
        List<xs> list = this.eO.getInternalMethods();
        this.analyzeRoutines(list);
    }

    @Override
    public void analyzeRoutines(Collection<? extends INativeMethodItem> collection) {
        ArrayList<WI> arrayList = new ArrayList<WI>();
        for (INativeMethodItem iNativeMethodItem : collection) {
            if (iNativeMethodItem.getData() == null) continue;
            arrayList.add((WI)iNativeMethodItem.getData());
        }
        this.analyzeInternalRoutines(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void analyzeInternalRoutines(Collection<? extends INativeMethodDataItem> collection) {
        try (ACLock aCLock = this.eO.eO().a();){
            long l2 = System.currentTimeMillis();
            int n = 0;
            Iterator<INativeMethodDataItem> iterator = this.eO(collection);
            while (iterator.hasNext()) {
                if (this.Qx) {
                    lS.status("Advanced analysis paused", new Object[0]);
                    return;
                }
                WI wI = (WI)iterator.next();
                if (wI.AP()) {
                    ++n;
                    continue;
                }
                if (!this.eO(wI.Le(), n, collection.size())) {
                    lS.status("Advanced analysis interrupted on routine %Xh", wI.getMemoryAddress());
                    return;
                }
                ++n;
            }
            lS.status("Advanced analysis completed (%s)", TimeFormatter.formatTimestampDelta(System.currentTimeMillis() - l2));
            return;
        }
        finally {
            this.Qx = false;
        }
    }

    private boolean eO(xs xs2, int n, int n2) {
        if (xs2 == null || xs2.KQ() == null) {
            return false;
        }
        Integer n3 = xs2.KQ().getAttribute("analysisStatus", Integer.class);
        if (n3 != null) {
            return true;
        }
        if (n >= 0 && n2 > 0) {
            int n4 = n * 100 / n2;
            lS.status("Advanced analysis of routine %d/%d: \"%s\"... (%d%%)", n + 1, n2, xs2.getName(true), n4);
        }
        try {
            xs2.KQ().setAttribute("analysisStatus", 0);
            this.eO(xs2);
        }
        catch (Exception exception) {
            if (xs2.KQ() != null && !xs2.KQ().AP()) {
                xs2.KQ().setAttribute("analysisStatus", -1);
            }
            lS.debug("Advanced analysis failed on method %s", xs2);
            Throwable throwable = exception.getCause();
            if (throwable instanceof UnsupportedConversionException) {
                lS.debug("Cannot convert instruction: %s", throwable.getMessage());
            } else {
                lS.catchingSilent(exception);
            }
            return !(exception instanceof InterruptionException);
        }
        if (xs2.KQ() != null && !xs2.KQ().AP()) {
            xs2.KQ().setAttribute("analysisStatus", 1);
        }
        return true;
    }

    private void eO(xs xs2) {
        NativeDecompilationStage nativeDecompilationStage = this.eO.getCodeAnalyzerExtensionsManager().getPreferredAdvancedAnalysisStage(xs2).getResult();
        if (nativeDecompilationStage != null) {
            this.Le.eO((INativeMethodItem)xs2, true, nativeDecompilationStage, TargetProperties.create().setDiscardable(true).build());
        } else {
            this.Le.eO((INativeMethodItem)xs2, true, NativeDecompilationStage.SIMULATION_COMPLETED, TargetProperties.create().setDiscardable(true).build());
        }
    }

    private Iterator<INativeMethodDataItem> eO(Collection<? extends INativeMethodDataItem> collection) {
        return new kL((Sk)this.eO.getCodeModel(), collection);
    }
}

