/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jebglobal;

import com.pnfsoftware.jeb.core.units.code.AddressableInstruction;
import com.pnfsoftware.jeb.core.units.code.IBasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EUtil;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEJump;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IENop;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.AbstractEOptimizer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.DataChainsUpdatePolicy;
import com.pnfsoftware.jeb.util.logging.StructuredLogger;
import com.pnfsoftware.jebglobal.qT;

public class Qm
extends AbstractEOptimizer {
    private static final StructuredLogger eO = qT.eO(Qm.class);

    public Qm(IERoutineContext iERoutineContext) {
        super(iERoutineContext, DataChainsUpdatePolicy.UPDATE_IF_REQUIRED);
    }

    @Override
    public int perform(boolean bl2) {
        int n = 0;
        boolean bl3 = false;
        for (BasicBlock<IEStatement> basicBlock : this.cfg.getBlocks()) {
            AddressableInstruction addressableInstruction;
            if (basicBlock.outsize() != 1 || basicBlock.irrinsize() != 0 && basicBlock.irroutsize() != 0 || basicBlock == this.cfg.getEntryBlock()) continue;
            boolean bl4 = true;
            for (int j = 0; j < basicBlock.size() - 1; ++j) {
                if (basicBlock.get(j) instanceof IENop) continue;
                bl4 = false;
                break;
            }
            if (!bl4 || basicBlock.isInfiniteLoop() || !(addressableInstruction = basicBlock.getLast2()).getBreakingFlow().isBroken() && !(addressableInstruction.getInstruction() instanceof IENop)) continue;
            eO.i("  -> Trampoline @%08x", basicBlock.getFirstAddress());
            boolean bl5 = true;
            for (BasicBlock basicBlock2 : basicBlock.getInputBlocks()) {
                IEStatement iEStatement = (IEStatement)basicBlock2.getLast();
                if (EUtil.isCondEJump(iEStatement)) {
                    if (!EUtil.containsUndeterminedInvocations(((IEJump)iEStatement).getCondition())) continue;
                    bl5 = false;
                    break;
                }
                if (iEStatement instanceof IEJump) continue;
                bl5 = false;
                break;
            }
            if (!bl5) {
                eO.i("     unpatchable (parents do not all end with EJump)", new Object[0]);
                continue;
            }
            IBasicBlock iBasicBlock = basicBlock.getOutputBlock(0);
            boolean bl6 = true;
            for (BasicBlock basicBlock3 : basicBlock.getInputBlocks()) {
                int n2;
                IEStatement iEStatement = (IEStatement)basicBlock3.getLast();
                if (!(iEStatement instanceof IEJump)) continue;
                if (((IEJump)iEStatement).getCondition() != null) {
                    if (basicBlock3.getOutputBlock(0) == basicBlock) {
                        if (basicBlock3.getOutputBlock(1) == iBasicBlock) {
                            if (!this.cfg.deleteEdge(basicBlock3, basicBlock, true) || !this.cfg.deleteEdge(basicBlock, iBasicBlock, true)) continue;
                            EUtil.makeUncond((IEJump)iEStatement);
                            bl3 = true;
                            eO.i("     Patched branch %s (transform into uncond)", iEStatement);
                            ++n;
                            continue;
                        }
                        eO.i("     Unpatchable (trampoline on FT)", new Object[0]);
                        bl6 = false;
                        break;
                    }
                    n2 = this.eO(basicBlock3, basicBlock, (BasicBlock<IEStatement>)iBasicBlock);
                    if (n2 == 1) {
                        ((IEJump)iEStatement).setBranchAddress((int)((BasicBlock)iBasicBlock).getFirstAddress());
                        eO.i("     Patched branch %s", iEStatement);
                        ++n;
                        continue;
                    }
                    if (n2 == -1) {
                        ((IEJump)iEStatement).setBranchAddress((int)((BasicBlock)iBasicBlock).getFirstAddress());
                        EUtil.makeUncond((IEJump)iEStatement);
                        bl3 = true;
                        eO.i("     Patched branch %s (transform into uncond)", iEStatement);
                        ++n;
                        continue;
                    }
                    if (n2 != 0) continue;
                    bl6 = false;
                    break;
                }
                n2 = this.eO(basicBlock3, basicBlock, (BasicBlock<IEStatement>)iBasicBlock);
                if (n2 == 1) {
                    ((IEJump)iEStatement).setBranchAddress((int)((BasicBlock)iBasicBlock).getFirstAddress());
                    eO.i("     Patched branch %s", iEStatement);
                    ++n;
                    continue;
                }
                if (n2 != 0) continue;
                bl6 = false;
                break;
            }
            if (!bl6) continue;
            this.cfg.removeBlock(basicBlock, true);
        }
        return this.postPerform(bl2, n, bl3);
    }

    private int eO(BasicBlock<IEStatement> basicBlock, BasicBlock<IEStatement> basicBlock2, BasicBlock<IEStatement> basicBlock3) {
        eO.i("     Reconnect from %08x to %08x", basicBlock.getFirstAddress(), basicBlock3.getFirstAddress());
        int n = this.cfg.reconnectEdge(basicBlock, basicBlock2, basicBlock3, true);
        if (n == 0) {
            eO.i("     Reconnect failed (missing edge)", new Object[0]);
        }
        if (n == -1) {
            eO.i("     Reconnect unnecessary (already an edge from parent to child)", new Object[0]);
            this.cfg.deleteEdge(basicBlock, basicBlock2, true);
            this.cfg.deleteEdge(basicBlock2, basicBlock3, true);
        }
        return n;
    }
}

