/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.net;

import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public class NetProxyInfo {
    private static final ILogger logger = GlobalLog.getLogger(NetProxyInfo.class);
    public static final int INDEX_DIRECT = 0;
    public static final int INDEX_HTTP = 1;
    public static final int INDEX_SOCKS = 2;
    public static final String TYPE_DIRECT = "direct";
    public static final String TYPE_HTTP = "http";
    public static final String TYPE_SOCKS = "socks";
    private String typestr;
    private String hostname;
    private int port;
    private String user;
    private String password;
    private String whitelist;
    private Proxy proxy;
    private Authenticator authenticator;
    private List<Pattern> wlpatterns = new ArrayList<Pattern>();

    public static List<String> getProxyTypes() {
        return Arrays.asList(TYPE_DIRECT, TYPE_HTTP, TYPE_SOCKS);
    }

    public static List<String> getProxyTypesWithDescriptions() {
        return Arrays.asList("Direct connection (no proxy)", "HTTP", "SOCKS");
    }

    public static String getProxyTypeFromIndex(int n) {
        if (n == 0) {
            return TYPE_DIRECT;
        }
        if (n == 1) {
            return TYPE_HTTP;
        }
        if (n == 2) {
            return TYPE_SOCKS;
        }
        logger.warn("Illegal proxy type index: %d", n);
        return TYPE_DIRECT;
    }

    public static NetProxyInfo parse(String string) {
        try {
            if (Strings.isBlank(string)) {
                return null;
            }
            String[] stringArray = Strings.splitall(string, "\\|");
            String string2 = stringArray[0].trim();
            String string3 = null;
            int n = 0;
            if (stringArray.length >= 3) {
                string3 = stringArray[1].trim();
                n = Integer.parseInt(stringArray[2].trim());
            }
            String string4 = null;
            String string5 = null;
            if (stringArray.length >= 4) {
                string4 = stringArray[3].trim();
            }
            if (stringArray.length >= 5) {
                string5 = stringArray[4].trim();
            }
            String string6 = null;
            if (stringArray.length >= 6) {
                string6 = stringArray[5].trim();
            }
            return new NetProxyInfo(string2, string3, n, string4, string5, string6);
        }
        catch (Exception exception) {
            logger.catching(exception);
            return null;
        }
    }

    public NetProxyInfo(String string, String string2, int n) {
        this(string, string2, n, null, null, null);
    }

    public NetProxyInfo(String string, String string2, int n, String string3, String string4) {
        this(string, string2, n, string3, string4, null);
    }

    public NetProxyInfo(String string, String string2, int n, String string3, String string4, String string5) {
        Proxy.Type type;
        if (string.equalsIgnoreCase(TYPE_DIRECT)) {
            type = Proxy.Type.DIRECT;
        } else if (string.equalsIgnoreCase(TYPE_HTTP)) {
            type = Proxy.Type.HTTP;
        } else if (string.equalsIgnoreCase(TYPE_SOCKS)) {
            type = Proxy.Type.SOCKS;
        } else {
            throw new IllegalArgumentException("Unsupported proxy type: " + string);
        }
        this.proxy = type == Proxy.Type.DIRECT ? Proxy.NO_PROXY : new Proxy(type, new InetSocketAddress(string2, n));
        this.typestr = string;
        this.hostname = string2;
        this.port = n;
        if (string3 != null && string3.length() > 0 || string4 != null && string4.length() > 0) {
            this.user = Strings.safe(string3);
            this.password = Strings.safe(string4);
        }
        if (string5 != null) {
            this.whitelist = "";
            for (String string6 : string5.trim().split(",")) {
                if ((string6 = string6.trim()).isEmpty()) continue;
                if (string6.contains("|")) {
                    logger.warn("Illegal filter for hostname or IP in proxy whitelist: %s", string6);
                    continue;
                }
                try {
                    String string7 = string6.replace(".", "\\.").replace("*", ".*");
                    Pattern pattern = Pattern.compile(string7, 2);
                    this.wlpatterns.add(pattern);
                    if (this.whitelist.length() > 0) {
                        this.whitelist = this.whitelist + ",";
                    }
                    this.whitelist = this.whitelist + string6;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    logger.warn("Illegal filter for hostname or IP in proxy whitelist: %s", string6);
                }
            }
        }
    }

    public boolean isProxy() {
        return this.proxy.type() != Proxy.Type.DIRECT;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public String getType() {
        switch (this.proxy.type()) {
            case DIRECT: {
                return TYPE_DIRECT;
            }
            case HTTP: {
                return TYPE_HTTP;
            }
            case SOCKS: {
                return TYPE_SOCKS;
            }
        }
        logger.warn("Unsupported proxy type: %s", new Object[]{this.proxy.type()});
        return TYPE_DIRECT;
    }

    public int getTypeIndex() {
        switch (this.getType()) {
            case "direct": {
                return 0;
            }
            case "http": {
                return 1;
            }
            case "socks": {
                return 2;
            }
        }
        throw new RuntimeException();
    }

    public String getHostname() {
        return this.proxy.type() == Proxy.Type.DIRECT ? null : ((InetSocketAddress)this.proxy.address()).getHostString();
    }

    public int getPort() {
        return this.proxy.type() == Proxy.Type.DIRECT ? 0 : ((InetSocketAddress)this.proxy.address()).getPort();
    }

    public String getUser() {
        return this.proxy.type() == Proxy.Type.DIRECT ? null : this.user;
    }

    public String getPassword() {
        return this.proxy.type() == Proxy.Type.DIRECT ? null : this.password;
    }

    public boolean hasCredentials() {
        return this.getUser() != null;
    }

    public Authenticator getAuthenticator() {
        if (this.authenticator == null && this.hasCredentials()) {
            final String string = this.getUser();
            final String string2 = this.getPassword();
            this.authenticator = new Authenticator(){

                public Request authenticate(Route route, Response response) throws IOException {
                    String string3 = Credentials.basic((String)string, (String)string2);
                    logger.i("Proxy auth.: user=\"%s\", password=\"%s\"", string, string2);
                    return response.request().newBuilder().header("Proxy-Authorization", string3).build();
                }
            };
        }
        return this.authenticator;
    }

    public String getWhitelist() {
        return this.proxy.type() == Proxy.Type.DIRECT ? null : this.whitelist;
    }

    public boolean isWhitelisted(String string) {
        if (this.wlpatterns.isEmpty()) {
            return false;
        }
        String string2 = "";
        try {
            URL uRL = new URL(string);
            string2 = uRL.getHost();
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        for (Pattern pattern : this.wlpatterns) {
            if (!pattern.matcher(string2).matches()) continue;
            return true;
        }
        return false;
    }

    public String getRecordedHostname() {
        return this.hostname;
    }

    public int getRecordedPort() {
        return this.port;
    }

    public String getRecordedUser() {
        return this.user;
    }

    public String getRecordedPassword() {
        return this.password;
    }

    public String getRecordedWhitelist() {
        return this.whitelist;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.proxy == null ? 0 : this.proxy.hashCode());
        n2 = 31 * n2 + (this.user == null ? 0 : this.user.hashCode());
        n2 = 31 * n2 + (this.password == null ? 0 : this.password.hashCode());
        n2 = 31 * n2 + (this.whitelist == null ? 0 : this.whitelist.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NetProxyInfo netProxyInfo = (NetProxyInfo)object;
        if (this.proxy == null ? netProxyInfo.proxy != null : !this.proxy.equals(netProxyInfo.proxy)) {
            return false;
        }
        if (this.password == null ? netProxyInfo.password != null : !this.password.equals(netProxyInfo.password)) {
            return false;
        }
        if (this.user == null ? netProxyInfo.user != null : !this.user.equals(netProxyInfo.user)) {
            return false;
        }
        return !(this.whitelist == null ? netProxyInfo.whitelist != null : !this.whitelist.equals(netProxyInfo.whitelist));
    }

    public String toString() {
        try {
            String string = this.typestr;
            if (this.hostname != null) {
                string = string + String.format("|%s|%d", this.hostname, this.port);
            }
            if (this.user != null) {
                if (this.hostname == null) {
                    string = string + "||";
                }
                string = string + String.format("|%s|%s", this.user, Strings.safe(this.password));
            }
            if (this.whitelist != null) {
                if (this.hostname == null) {
                    string = string + "||";
                }
                if (this.user == null) {
                    string = string + "||";
                }
                string = string + String.format("|%s", this.whitelist);
            }
            return string;
        }
        catch (Exception exception) {
            logger.catching(exception);
            return null;
        }
    }
}

