/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.io;

import com.pnfsoftware.jeb.util.encoding.IntegerLEB128;
import com.pnfsoftware.jeb.util.encoding.LongLEB128;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class LEDataOutputStream
extends FilterOutputStream
implements DataOutput {
    public LEDataOutputStream(OutputStream outputStream) {
        super(new DataOutputStream(outputStream));
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public int size() {
        return ((DataOutputStream)this.out).size();
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
    }

    @Override
    public void writeBoolean(boolean bl2) throws IOException {
        ((DataOutputStream)this.out).writeBoolean(bl2);
    }

    @Override
    public void writeByte(int n) throws IOException {
        ((DataOutputStream)this.out).writeByte(n);
    }

    @Override
    @Deprecated
    public void writeBytes(String string) throws IOException {
        ((DataOutputStream)this.out).writeBytes(string);
    }

    @Override
    public void writeUTF(String string) throws IOException {
        ((DataOutputStream)this.out).writeUTF(string);
    }

    @Override
    public void writeChar(int n) throws IOException {
        this.writeShort(n);
    }

    @Override
    public void writeChars(String string) throws IOException {
        for (int j = 0; j < string.length(); ++j) {
            this.writeChar(string.charAt(j));
        }
    }

    @Override
    public void writeInt(int n) throws IOException {
        this.out.write(0xFF & n);
        this.out.write(0xFF & n >> 8);
        this.out.write(0xFF & n >> 16);
        this.out.write(0xFF & n >> 24);
    }

    @Override
    public void writeShort(int n) throws IOException {
        this.out.write(0xFF & n);
        this.out.write(0xFF & n >> 8);
    }

    @Override
    public void writeLong(long l2) throws IOException {
        this.out.write(0xFF & (int)l2);
        this.out.write(0xFF & (int)(l2 >> 8));
        this.out.write(0xFF & (int)(l2 >> 16));
        this.out.write(0xFF & (int)(l2 >> 24));
        this.out.write(0xFF & (int)(l2 >> 32));
        this.out.write(0xFF & (int)(l2 >> 40));
        this.out.write(0xFF & (int)(l2 >> 48));
        this.out.write(0xFF & (int)(l2 >> 56));
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    @Override
    public void writeDouble(double d2) throws IOException {
        this.writeLong(Double.doubleToLongBits(d2));
    }

    public final void writeIntULEB128(int n) throws IOException {
        IntegerLEB128.writeULEB128(this.out, n);
    }

    public final void writeLongULEB128(long l2) throws IOException {
        LongLEB128.writeULEB128(this.out, l2);
    }
}

