/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;

public class ChannelUtil {
    public static ByteBuffer read(SeekableByteChannel seekableByteChannel, long l2, int n, boolean bl2) throws IOException {
        return ChannelUtil.read(seekableByteChannel, l2, n, bl2, null);
    }

    public static ByteBuffer read(SeekableByteChannel seekableByteChannel, long l2, int n, boolean bl2, ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null || byteBuffer.capacity() < n) {
            byteBuffer = ByteBuffer.allocate(n);
        } else {
            byteBuffer.clear();
            byteBuffer.limit(n);
        }
        byteBuffer.order(bl2 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        seekableByteChannel.position(l2);
        int n2 = seekableByteChannel.read(byteBuffer);
        if (n2 != n) {
            throw new IOException(String.format("Read %d bytes at offset %Xh, expected %d", n2, l2, n));
        }
        byteBuffer.rewind();
        return byteBuffer;
    }

    public static ByteBuffer readBestEffort(SeekableByteChannel seekableByteChannel, long l2, int n, boolean bl2, ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null || byteBuffer.capacity() < n) {
            byteBuffer = ByteBuffer.allocate(n);
        } else {
            byteBuffer.clear();
            byteBuffer.limit(n);
        }
        byteBuffer.order(bl2 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        seekableByteChannel.position(l2);
        int n2 = seekableByteChannel.read(byteBuffer);
        if (n2 < n) {
            byteBuffer.limit(Math.max(0, n2));
        }
        byteBuffer.rewind();
        return byteBuffer;
    }

    public static byte[] getAllFrom(SeekableByteChannel seekableByteChannel, long l2) throws IOException {
        seekableByteChannel.position(l2);
        long l3 = seekableByteChannel.size() - l2;
        if (l3 > Integer.MAX_VALUE) {
            throw new IOException("Cannot alocate that many bytes: " + l3);
        }
        byte[] byArray = new byte[(int)l3];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        int n = seekableByteChannel.read(byteBuffer);
        if (n != byArray.length) {
            throw new IOException(String.format("Wanted to read %d bytes, got %d only", byArray.length, n));
        }
        return byArray;
    }

    public static byte get(SeekableByteChannel seekableByteChannel, long l2) throws IOException {
        seekableByteChannel.position(l2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1);
        if (seekableByteChannel.read(byteBuffer) != 1) {
            throw new IOException(String.format("Expected a byte at offset %Xh", l2));
        }
        return byteBuffer.get(0);
    }

    public static byte get(SeekableByteChannel seekableByteChannel) throws IOException {
        return ChannelUtil.get(seekableByteChannel, seekableByteChannel.position());
    }

    public static byte[] getBytes(SeekableByteChannel seekableByteChannel, long l2, int n) throws IOException {
        seekableByteChannel.position(l2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        if (seekableByteChannel.read(byteBuffer) != n) {
            throw new IOException(String.format("Expected %d bytes at offset %Xh", n, l2));
        }
        return byteBuffer.array();
    }

    public static byte[] getBytes(SeekableByteChannel seekableByteChannel, int n) throws IOException {
        return ChannelUtil.getBytes(seekableByteChannel, seekableByteChannel.position(), n);
    }

    public static short getShort(SeekableByteChannel seekableByteChannel, long l2, ByteOrder byteOrder) throws IOException {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            return ChannelUtil.getBEShort(seekableByteChannel, l2);
        }
        return ChannelUtil.getLEShort(seekableByteChannel, l2);
    }

    public static int getInt(SeekableByteChannel seekableByteChannel, long l2, ByteOrder byteOrder) throws IOException {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            return ChannelUtil.getBEInt(seekableByteChannel, l2);
        }
        return ChannelUtil.getLEInt(seekableByteChannel, l2);
    }

    public static long getLong(SeekableByteChannel seekableByteChannel, long l2, ByteOrder byteOrder) throws IOException {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            return ChannelUtil.getBELong(seekableByteChannel, l2);
        }
        return ChannelUtil.getLELong(seekableByteChannel, l2);
    }

    public static short getShort(SeekableByteChannel seekableByteChannel, ByteOrder byteOrder) throws IOException {
        return ChannelUtil.getShort(seekableByteChannel, seekableByteChannel.position(), byteOrder);
    }

    public static int getInt(SeekableByteChannel seekableByteChannel, ByteOrder byteOrder) throws IOException {
        return ChannelUtil.getInt(seekableByteChannel, seekableByteChannel.position(), byteOrder);
    }

    public static long getLong(SeekableByteChannel seekableByteChannel, ByteOrder byteOrder) throws IOException {
        return ChannelUtil.getLong(seekableByteChannel, seekableByteChannel.position(), byteOrder);
    }

    public static short getLEShort(SeekableByteChannel seekableByteChannel, long l2) throws IOException {
        seekableByteChannel.position(l2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
        if (seekableByteChannel.read(byteBuffer) != 2) {
            throw new IOException(String.format("Expected a short at offset %Xh", l2));
        }
        return byteBuffer.getShort(0);
    }

    public static int getLEInt(SeekableByteChannel seekableByteChannel, long l2) throws IOException {
        seekableByteChannel.position(l2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        if (seekableByteChannel.read(byteBuffer) != 4) {
            throw new IOException(String.format("Expected an int at offset %Xh", l2));
        }
        return byteBuffer.getInt(0);
    }

    public static long getLELong(SeekableByteChannel seekableByteChannel, long l2) throws IOException {
        seekableByteChannel.position(l2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        if (seekableByteChannel.read(byteBuffer) != 8) {
            throw new IOException(String.format("Expected a long at offset %Xh", l2));
        }
        return byteBuffer.getLong(0);
    }

    public static short getBEShort(SeekableByteChannel seekableByteChannel, long l2) throws IOException {
        seekableByteChannel.position(l2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2).order(ByteOrder.BIG_ENDIAN);
        if (seekableByteChannel.read(byteBuffer) != 2) {
            throw new IOException(String.format("Expected a short at offset %Xh", l2));
        }
        return byteBuffer.getShort(0);
    }

    public static int getBEInt(SeekableByteChannel seekableByteChannel, long l2) throws IOException {
        seekableByteChannel.position(l2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
        if (seekableByteChannel.read(byteBuffer) != 4) {
            throw new IOException(String.format("Expected an int at offset %Xh", l2));
        }
        return byteBuffer.getInt(0);
    }

    public static long getBELong(SeekableByteChannel seekableByteChannel, long l2) throws IOException {
        seekableByteChannel.position(l2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
        if (seekableByteChannel.read(byteBuffer) != 8) {
            throw new IOException(String.format("Expected a long at offset %Xh", l2));
        }
        return byteBuffer.getLong(0);
    }

    public static short getLEShort(SeekableByteChannel seekableByteChannel) throws IOException {
        return ChannelUtil.getLEShort(seekableByteChannel, seekableByteChannel.position());
    }

    public static int getLEInt(SeekableByteChannel seekableByteChannel) throws IOException {
        return ChannelUtil.getLEInt(seekableByteChannel, seekableByteChannel.position());
    }

    public static long getLELong(SeekableByteChannel seekableByteChannel) throws IOException {
        return ChannelUtil.getLELong(seekableByteChannel, seekableByteChannel.position());
    }

    public static short getBEShort(SeekableByteChannel seekableByteChannel) throws IOException {
        return ChannelUtil.getBEShort(seekableByteChannel, seekableByteChannel.position());
    }

    public static int getBEInt(SeekableByteChannel seekableByteChannel) throws IOException {
        return ChannelUtil.getBEInt(seekableByteChannel, seekableByteChannel.position());
    }

    public static long getBELong(SeekableByteChannel seekableByteChannel) throws IOException {
        return ChannelUtil.getBELong(seekableByteChannel, seekableByteChannel.position());
    }

    public static byte[] getBytesUntil(SeekableByteChannel seekableByteChannel, int n, int n2, boolean bl2) throws IOException {
        int n3;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[256];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        boolean bl3 = false;
        for (int j = n2; j > 0 && !bl3; j -= n3) {
            int n4;
            byteBuffer.position(0);
            if (j < byteBuffer.limit()) {
                byteBuffer.limit(j);
                bl3 = true;
            }
            if ((n4 = seekableByteChannel.read(byteBuffer)) <= 0) {
                if (!bl2) break;
                throw new IOException("Not enough data");
            }
            for (n3 = 0; n3 < n4; ++n3) {
                if (byArray[n3] != n) continue;
                bl3 = true;
                break;
            }
            byteArrayOutputStream.write(byArray, 0, n3);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

