/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.io;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteBufferUtil {
    public static boolean equalsByteArray(ByteBuffer byteBuffer, int n, byte[] byArray, int n2, int n3) {
        for (int j = 0; j < n3; ++j) {
            if (byteBuffer.get(n + j) == byArray[n2 + j]) continue;
            return false;
        }
        return true;
    }

    public static byte[] getBytes(ByteBuffer byteBuffer, int n, int n2) {
        byte[] byArray = new byte[n2];
        for (int j = 0; j < n2; ++j) {
            byArray[j] = byteBuffer.get(n + j);
        }
        return byArray;
    }

    public static byte[] getBytes(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        return byArray;
    }

    public static void skip(ByteBuffer byteBuffer, int n) {
        byteBuffer.position(byteBuffer.position() + n);
    }

    public static int skipAttempt(ByteBuffer byteBuffer, int n) {
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.remaining();
        if (n > n3) {
            n = n3;
        } else if (n < 0 && n + n2 < 0) {
            n = -n2;
        }
        byteBuffer.position(n2 + n);
        return n;
    }

    public static void skipToEnd(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        if (n > 0) {
            byteBuffer.position(byteBuffer.position() + n);
        }
    }

    public static long getUnsignedInt(ByteBuffer byteBuffer) {
        return byteBuffer.getInt() & 0xFFFFFFFF;
    }

    public static long getUnsignedInt(ByteBuffer byteBuffer, int n) {
        return byteBuffer.getInt(n) & 0xFFFFFFFF;
    }

    public static ByteBuffer wrapLE(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer;
    }

    public static ByteBuffer wrapBE(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        return byteBuffer;
    }

    public static ByteBuffer wrapLE(byte[] byArray, int n, int n2) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer;
    }

    public static ByteBuffer wrapBE(byte[] byArray, int n, int n2) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        return byteBuffer;
    }

    public static int align(ByteBuffer byteBuffer, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid alignment: " + n);
        }
        int n2 = byteBuffer.position();
        int n3 = n - n2 % n;
        if (n3 != n) {
            byteBuffer.position(n2 += n3);
        }
        return n2;
    }
}

