/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.interpreter;

import com.pnfsoftware.jeb.util.collect.BytePipe;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class InputToken {
    private String value;
    private boolean needsUnescaping;

    public InputToken(String string, boolean bl2) {
        this.value = string;
        this.needsUnescaping = bl2;
    }

    public InputToken(String string) {
        this(string, false);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        if (this.needsUnespaping()) {
            return String.format("\"%s\"", this.getValue());
        }
        return this.getValue();
    }

    public boolean needsUnespaping() {
        return this.needsUnescaping;
    }

    public byte[] getBytes() throws UnsupportedEncodingException {
        if (!this.needsUnescaping) {
            return this.value.getBytes(Charset.defaultCharset());
        }
        BytePipe bytePipe = new BytePipe(this.value.length());
        for (int j = 0; j < this.value.length(); ++j) {
            char c = this.value.charAt(j);
            if (c > '\u007f') {
                throw new UnsupportedEncodingException("Only characters in the ASCII range are allowed in escaped strings");
            }
            int n = c;
            if (n == 92) {
                if (j + 1 > this.value.length()) {
                    throw new UnsupportedEncodingException("Illegal escape character:");
                }
                c = this.value.charAt(j + 1);
                ++j;
                switch (c) {
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        n = (byte)c;
                        break;
                    }
                    case 't': {
                        n = 9;
                        break;
                    }
                    case 'r': {
                        n = 13;
                        break;
                    }
                    case 'n': {
                        n = 10;
                        break;
                    }
                    case 'b': {
                        n = 8;
                        break;
                    }
                    case 'f': {
                        n = 12;
                        break;
                    }
                    case 'x': {
                        if (j + 2 > this.value.length()) {
                            throw new UnsupportedEncodingException("Missing characters after \\x");
                        }
                        try {
                            n = (byte)Integer.parseInt(this.value.substring(j + 1, j + 3), 16);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new UnsupportedEncodingException("Illegal escaped byte");
                        }
                        j += 2;
                        break;
                    }
                    default: {
                        throw new UnsupportedEncodingException("Illegal escape character");
                    }
                }
            }
            bytePipe.append((byte)n);
        }
        return bytePipe.getAll();
    }
}

