/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.interpreter;

import com.pnfsoftware.jeb.util.format.Strings;

public class ExecutionResult {
    public static final int CODE_SUCCESS = 0;
    public static final int CODE_ERROR = -1;
    public static final int CODE_NOT_SUPPORTED = -2;
    public static final int CODE_NOT_IMPLEMENTED = -3;
    public static final ExecutionResult GENERIC_SUCCESS = new ExecutionResult(0);
    public static final ExecutionResult GENERIC_ERROR = new ExecutionResult(-1);
    public static final ExecutionResult NOT_SUPPORTED = new ExecutionResult(-2);
    public static final ExecutionResult NOT_IMPLEMENTED = new ExecutionResult(-3);
    private int code;
    private String message;

    public static ExecutionResult success(String string) {
        return new ExecutionResult(0, string);
    }

    public static ExecutionResult error(String string) {
        return new ExecutionResult(-1, string);
    }

    public static ExecutionResult error(Throwable throwable) {
        String string = throwable.getMessage();
        if (!Strings.isBlank(string)) {
            return new ExecutionResult(-1, string);
        }
        return new ExecutionResult(-1, throwable.toString());
    }

    public static ExecutionResult failure(String string) {
        return ExecutionResult.error(string);
    }

    public static ExecutionResult fromBoolean(boolean bl2) {
        return bl2 ? GENERIC_SUCCESS : GENERIC_ERROR;
    }

    public static ExecutionResult fromObject(Object object) {
        if (object == null) {
            return GENERIC_ERROR;
        }
        return new ExecutionResult(0, object.toString());
    }

    private ExecutionResult(int n) {
        this(n, null);
    }

    private ExecutionResult(String string) {
        this(0, string);
    }

    private ExecutionResult(int n, String string) {
        this.code = n;
        this.message = Strings.safe(string);
    }

    public int getCode() {
        return this.code;
    }

    public boolean isSuccess() {
        return this.getCode() == 0;
    }

    public boolean isError() {
        return this.getCode() != 0;
    }

    @Deprecated
    public int getType() {
        return this.getCode();
    }

    public String getMessage() {
        return this.message;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + this.code;
        n2 = 31 * n2 + (this.message == null ? 0 : this.message.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ExecutionResult executionResult = (ExecutionResult)object;
        if (this.code != executionResult.code) {
            return false;
        }
        return !(this.message == null ? executionResult.message != null : !this.message.equals(executionResult.message));
    }

    public String toString() {
        return String.format("code=%d,message={%s}", this.getCode(), this.getMessage());
    }
}

