/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.format;

import com.pnfsoftware.jeb.util.format.TextBuilder;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;

public class XmlBuilder
extends TextBuilder {
    Deque<String> eltstack = new ArrayDeque<String>();

    public XmlBuilder() {
    }

    public XmlBuilder(int n) {
        super(n);
    }

    public XmlBuilder(int n, int n2) {
        super(n, n2);
    }

    public void appendStandardHeader() {
        this.appendHeader(1, 0, "UTF-8", false);
    }

    public void appendHeader(int n, int n2, String string, boolean bl2) {
        this.appendLine("<?xml version=\"%d.%d\" encoding=\"%s\" standalone=\"%s\" ?>", n, n2, string, bl2 ? "yes" : "no");
    }

    public void openElement(String string) {
        this.openElement(string, null, false);
    }

    public void openElement(String string, Map<String, String> map) {
        this.openElement(string, map, false);
    }

    public void openElement(String string, Map<String, String> map, boolean bl2) {
        this.append("<%s", string);
        if (map != null) {
            for (String string2 : map.keySet()) {
                this.append(" %s=\"%s\"", string2, map.get(string2));
            }
        }
        if (bl2) {
            this.append(" />");
        } else {
            this.eltstack.push(string);
            this.append(">");
            this.indent();
        }
    }

    public void closeElement() {
        this.closeElement(false);
    }

    public void closeElement(boolean bl2) {
        this.unindent();
        String string = this.eltstack.pop();
        this.append("</%s>", string);
        if (bl2) {
            this.appendLine();
        }
    }

    public static String escapeTextData(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int j = 0; j < string.length(); ++j) {
            char c = string.charAt(j);
            if (c == '<') {
                stringBuilder.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuilder.append("&gt;");
                continue;
            }
            if (c == '&') {
                stringBuilder.append("&amp;");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String escapeAttributeData(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int j = 0; j < string.length(); ++j) {
            char c = string.charAt(j);
            if (c == '<') {
                stringBuilder.append("&lt;");
                continue;
            }
            if (c == '&') {
                stringBuilder.append("&amp;");
                continue;
            }
            if (c == '\"') {
                stringBuilder.append("&quot;");
                continue;
            }
            if (c == '\'') {
                stringBuilder.append("&#39;");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }
}

