/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.format;

import com.pnfsoftware.jeb.util.base.SystemUtil;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.lang.reflect.Field;

public class XercesUpdater {
    private static final ILogger logger = GlobalLog.getLogger(XercesUpdater.class);
    private static final int majorJavaVersion = SystemUtil.getMajorJavaVersion();
    private ClassLoader cl;
    private int modcnt;
    private byte[] array;

    public XercesUpdater() {
        this(ClassLoader.getSystemClassLoader());
    }

    public XercesUpdater(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException();
        }
        this.cl = classLoader;
    }

    public int getModificationCount() {
        return this.modcnt;
    }

    public int update() {
        return this.updateXML10();
    }

    private int updateXML10() {
        E[] eArray = new E[]{new E(0, "com.sun.org.apache.xerces.internal.util.XMLChar", "CHARS"), new E(0, "com.sun.org.apache.xml.internal.utils.XMLChar", "CHARS"), new E(0, "org.apache.xerces.util.XMLChar", "CHARS"), new E(0, "com.sun.xml.internal.fastinfoset.org.apache.xerces.util.XMLChar", "CHARS")};
        int n = 0;
        for (E e2 : eArray) {
            if (!this.updateXML10(e2)) continue;
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateXML10(E e2) {
        if (e2.maxJavaVer != 0 && e2.maxJavaVer < majorJavaVersion) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName(e2.cname, true, this.cl);
            Field field = clazz.getDeclaredField(e2.fname);
            field.setAccessible(true);
            try {
                this.array = (byte[])field.get(null);
                if (this.array.length == 65536) {
                    this.setNameStart(192, 214);
                    this.setNameStart(216, 246);
                    this.setNameStart(248, 767);
                    this.setNameStart(880, 893);
                    this.setNameStart(895, 8191);
                    this.setNameStart(8204, 8205);
                    this.setNameStart(8304, 8591);
                    this.setNameStart(11264, 12271);
                    this.setNameStart(12289, 55295);
                    this.setNameStart(63744, 64975);
                    this.setNameStart(65008, 65533);
                    this.setName(768, 879);
                    this.setName(8255, 8256);
                }
            }
            finally {
                field.setAccessible(false);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void setNameStart(int n, int n2) {
        for (int j = n; j <= n2; ++j) {
            if ((this.array[j] & 0xF) == 13) continue;
            this.array[j] = (byte)(this.array[j] & 0xF0 | 0xD);
            ++this.modcnt;
        }
    }

    private void setName(int n, int n2) {
        for (int j = n; j <= n2; ++j) {
            if ((this.array[j] & 0xF) == 9) continue;
            this.array[j] = (byte)(this.array[j] & 0xF0 | 9);
            ++this.modcnt;
        }
    }

    static class E {
        int maxJavaVer;
        String cname;
        String fname;

        public E(int n, String string, String string2) {
            this.maxJavaVer = n;
            this.cname = string;
            this.fname = string2;
        }
    }
}

