/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding;

import com.pnfsoftware.jeb.core.input.IInput;
import java.nio.ByteBuffer;

public class MimeType {
    public static final String IMAGE_BMP = "image/BMP";
    public static final String IMAGE_CRW = "image/x-canon-crw";
    public static final String IMAGE_GIF = "image/gif";
    public static final String IMAGE_ICO = "image/vnd.microsoft.icon";
    public static final String IMAGE_JPEG = "image/jpeg";
    public static final String IMAGE_PNG = "image/png";
    public static final String IMAGE_PSD = "image/vnd.adobe.photoshop";
    public static final String IMAGE_TIFF = "image/tiff";
    public static final String IMAGE_WEBP = "image/webp";
    public static final String APPLICATION_XML = "application/xml";
    public static final String APPLICATION_ZIP = "application/zip";
    public static final String APPLICATION_7Z = "application/x-7z-compressed";
    public static final String APPLICATION_TAR = "application/x-tar";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_OCTETSTREAM = "application/octet-stream";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_HTML = "text/html";

    public static String determineFromContent(IInput iInput) {
        ByteBuffer byteBuffer = iInput.getHeader();
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        if (MimeType.checkBytes(byArray, 0, 137, 80, 78, 71)) {
            return IMAGE_PNG;
        }
        if (byArray.length >= 4 && MimeType.checkBytes(byArray, 0, 255, 216, 255)) {
            return IMAGE_JPEG;
        }
        if (MimeType.checkBytes(byArray, 0, "GIF87a") || MimeType.checkBytes(byArray, 0, "GIF89a")) {
            return IMAGE_GIF;
        }
        if (MimeType.checkBytes(byArray, 0, "BM") && MimeType.checkBytes(byArray, 6, 0, 0, 0, 0)) {
            return IMAGE_BMP;
        }
        if (MimeType.checkBytes(byArray, 0, 73, 73, 42, 0) || MimeType.checkBytes(byArray, 0, 77, 77, 0, 42)) {
            return IMAGE_TIFF;
        }
        return APPLICATION_OCTETSTREAM;
    }

    private static boolean checkBytes(byte[] byArray, int n, int ... nArray) {
        if (n + nArray.length > byArray.length) {
            return false;
        }
        for (int n2 : nArray) {
            if (byArray[n] != (byte)n2) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean checkBytes(byte[] byArray, int n, char ... cArray) {
        if (n + cArray.length > byArray.length) {
            return false;
        }
        for (char c : cArray) {
            if (byArray[n] != (byte)c) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean checkBytes(byte[] byArray, int n, String string) {
        return MimeType.checkBytes(byArray, n, string.toCharArray());
    }
}

