/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import java.util.Collection;
import java.util.Deque;

@SerDisabled
public class VerifiedDeque<E> {
    private final FailureHandler<E> defaultHandler = new FailureHandler<E>(){

        @Override
        public int notInWhitelist(E e2) {
            return -1;
        }

        @Override
        public int inBlacklist(E e2) {
            return -1;
        }
    };
    Deque<E> deque;
    Collection<E> whitelist;
    Collection<E> blacklist;
    FailureHandler<E> failureHandler;

    public static <E> VerifiedDeque<E> wrap(Deque<E> deque, Collection<E> collection, Collection<E> collection2, FailureHandler<E> failureHandler) {
        return new VerifiedDeque<E>(deque, collection, collection2, failureHandler);
    }

    private VerifiedDeque(Deque<E> deque, Collection<E> collection, Collection<E> collection2, FailureHandler<E> failureHandler) {
        if (deque == null) {
            throw new IllegalArgumentException();
        }
        this.deque = deque;
        this.whitelist = collection;
        this.blacklist = collection2;
        this.failureHandler = failureHandler != null ? failureHandler : this.defaultHandler;
    }

    private boolean check(E e2) {
        int n = 1;
        if (this.whitelist != null && !this.whitelist.contains(e2)) {
            n = this.failureHandler.notInWhitelist(e2);
        } else if (this.blacklist != null && this.blacklist.contains(e2)) {
            n = this.failureHandler.notInWhitelist(e2);
        }
        if (n == 0) {
            return false;
        }
        if (n < 0) {
            throw new IllegalArgumentException("The element cannot be added to the collection");
        }
        return true;
    }

    public boolean push(E e2) {
        if (this.check(e2)) {
            this.deque.push(e2);
            return true;
        }
        return true;
    }

    public static interface FailureHandler<E> {
        public int notInWhitelist(E var1);

        public int inBlacklist(E var1);
    }
}

