/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.collect.ISegment;
import com.pnfsoftware.jeb.util.collect.ISegmentFactory;
import com.pnfsoftware.jeb.util.collect.ISegmentGapVerifier;
import com.pnfsoftware.jeb.util.collect.ISegmentMap;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerConstructor;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;

@Ser
public class SegmentMap<K extends Comparable<K>, V extends ISegment<K>>
extends ConcurrentSkipListMap<K, V>
implements ISegmentMap<K, V> {
    private static final long serialVersionUID = 1L;
    @SerId(value=1)
    boolean removeSegmentsOnOverlap;

    @SerConstructor
    public SegmentMap() {
    }

    protected SegmentMap(Comparator<? super K> comparator) {
        super(comparator);
    }

    public void setRemoveSegmentsOnOverlap(boolean bl2) {
        this.removeSegmentsOnOverlap = bl2;
    }

    public boolean isRemoveSegmentsOnOverlap() {
        return this.removeSegmentsOnOverlap;
    }

    @Override
    public V add(V v2) {
        this.put((K)v2.getBegin(), v2);
        return v2;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put((K)((Comparable)entry.getKey()), (V)((ISegment)entry.getValue()));
        }
    }

    public int compareKeys(K k2, K k3) {
        Comparator comparator = this.comparator();
        return comparator != null ? comparator.compare(k2, k3) : k2.compareTo(k3);
    }

    @Override
    public V put(K k2, V v2) {
        if (!k2.equals(v2.getBegin())) {
            throw new IllegalArgumentException(String.format("The provided key differs from the segment's begin value: %s != %s", k2, v2.getBegin()));
        }
        if (!this.isValidKey(k2)) {
            throw new IllegalArgumentException("Invalid key: " + k2);
        }
        if (!this.isValidKey(v2.getEnd())) {
            throw new IllegalArgumentException("Invalid end key: " + v2.getEnd());
        }
        if (!this.isValidSegment(v2)) {
            throw new IllegalArgumentException("Invalid segment: " + v2);
        }
        Map.Entry entry = this.lowerEntry(v2.getEnd());
        if (entry != null && this.compareKeys(((ISegment)entry.getValue()).getEnd(), k2) > 0) {
            if (!this.removeSegmentsOnOverlap) {
                throw new IllegalArgumentException("Attempt to insert the given segment overlaps existing segment(s)");
            }
            HashSet<K> hashSet = new HashSet<K>(this.getOverlappingSegmentsMap(k2, true, v2.getEnd(), true).keySet());
            for (Comparable comparable : hashSet) {
                this.remove(comparable);
            }
        }
        return (V)((ISegment)super.put(k2, v2));
    }

    public boolean isValidKey(K k2) {
        return true;
    }

    public boolean isValidSegment(V v2) {
        return this.compareKeys(v2.getBegin(), v2.getEnd()) < 0;
    }

    @Override
    public V getSegmentContaining(K k2) {
        Map.Entry entry = this.floorEntry(k2);
        if (entry == null) {
            return null;
        }
        ISegment iSegment = (ISegment)entry.getValue();
        if (this.compareKeys(k2, iSegment.getEnd()) < 0) {
            return (V)iSegment;
        }
        return null;
    }

    @Override
    public V getSegmentAfter(K k2) {
        Map.Entry entry = this.higherEntry(k2);
        if (entry == null) {
            return null;
        }
        return (V)((ISegment)entry.getValue());
    }

    @Override
    public V getSegmentBefore(K k2) {
        Map.Entry entry;
        V v2 = this.getSegmentContaining(k2);
        if (v2 != null) {
            k2 = v2.getBegin();
        }
        if ((entry = this.lowerEntry(k2)) == null) {
            return null;
        }
        return (V)((ISegment)entry.getValue());
    }

    @Override
    public SortedMap<K, V> getOverlappingSegmentsMap(K k2, boolean bl2, K k3, boolean bl3) {
        Object object;
        TreeMap treeMap = new TreeMap();
        boolean bl4 = true;
        if (bl2) {
            object = this.getSegmentContaining(k2);
            if (object != null) {
                treeMap.put(object.getBegin(), object);
            }
            bl4 = false;
        }
        object = this.subMap((Object)k2, bl4, (Object)k3, false);
        treeMap.putAll(object);
        Map.Entry entry = object.lastEntry();
        if (entry != null && !bl3 && this.compareKeys(((ISegment)entry.getValue()).getEnd(), k3) > 0) {
            object.remove(entry.getKey());
        }
        return treeMap;
    }

    @Override
    public boolean isEmptyRange(K k2, K k3) {
        return this.getOverlappingSegmentsMap(k2, true, k3, true).isEmpty();
    }

    @Override
    public SortedMap<K, V> contiguousSubMap(K k2, K k3, ISegmentFactory<K, V> iSegmentFactory) {
        List<V> list = this.generateGapItems(k2, true, k3, true, iSegmentFactory, false);
        TreeMap treeMap = new TreeMap(this.subMap((Object)k2, (Object)k3));
        for (ISegment iSegment : list) {
            treeMap.put(iSegment.getBegin(), iSegment);
        }
        return treeMap;
    }

    @Override
    public List<V> fillGaps(K k2, K k3, ISegmentFactory<K, V> iSegmentFactory) {
        return this.generateGapItems(k2, true, k3, true, iSegmentFactory, true);
    }

    @Override
    public List<V> generateGapItems(K k2, boolean bl2, K k3, boolean bl3, ISegmentFactory<K, V> iSegmentFactory, boolean bl4) {
        int n;
        ArrayList<ISegment<Object>> arrayList = new ArrayList<ISegment<Object>>();
        Object object = this.getSegmentContaining(k2);
        if (object == null) {
            object = this.getSegmentAfter(k2);
            if (object == null || this.compareKeys(object.getBegin(), k3) > 0) {
                if (bl2 && bl3) {
                    arrayList.add(this.add((ISegment)iSegmentFactory.create((Iterator<Object>)k2, (Iterator<Object>)k3)));
                }
                return arrayList;
            }
            if (bl2) {
                arrayList.add((ISegment<Object>)iSegmentFactory.create((Iterator<Object>)k2, (Iterator<Object>)object.getBegin()));
            }
        }
        NavigableMap navigableMap = this.subMap(object.getBegin(), false, (Object)k3, false);
        Iterator<Object> iterator = navigableMap.keySet().iterator();
        while (iterator.hasNext()) {
            Comparable comparable = (Comparable)iterator.next();
            ISegment iSegment = (ISegment)navigableMap.get(comparable);
            Object k4 = object.getEnd();
            int n2 = this.compareKeys(iSegment.getBegin(), k4);
            if (n2 > 0) {
                arrayList.add((ISegment<Object>)iSegmentFactory.create((Iterator<Object>)k4, (Iterator<Object>)iSegment.getBegin()));
            }
            object = iSegment;
        }
        if (bl3 && (n = this.compareKeys(k3, iterator = object.getEnd())) > 0) {
            arrayList.add((ISegment<Object>)iSegmentFactory.create(iterator, (Iterator<Object>)k3));
        }
        if (bl4) {
            for (ISegment iSegment : arrayList) {
                this.put((K)iSegment.getBegin(), (V)iSegment);
            }
        }
        return arrayList;
    }

    private boolean verify(ISegmentGapVerifier<K> iSegmentGapVerifier, K k2, K k3, List<Couple<K, K>> list) {
        ISegmentGapVerifier.VerificationCode verificationCode = iSegmentGapVerifier == null ? ISegmentGapVerifier.VerificationCode.INCLUDE_AND_CONTINUE : iSegmentGapVerifier.verify(k2, k3);
        switch (verificationCode) {
            case INCLUDE_AND_CONTINUE: {
                list.add(new Couple<K, K>(k2, k3));
                return true;
            }
            case INCLUDE_AND_EXIT: {
                list.add(new Couple<K, K>(k2, k3));
                return false;
            }
            case SKIP_AND_CONTINUE: {
                return true;
            }
            case SKIP_AND_EXIT: {
                return false;
            }
        }
        throw new RuntimeException();
    }

    @Override
    public List<Couple<K, K>> generateGaps(K k2, boolean bl2, K k3, boolean bl3, ISegmentGapVerifier<K> iSegmentGapVerifier) {
        int n;
        ArrayList<Couple<K, K>> arrayList = new ArrayList<Couple<K, K>>();
        Object object = this.getSegmentContaining(k2);
        if (object == null) {
            object = this.getSegmentAfter(k2);
            if (object == null || this.compareKeys(object.getBegin(), k3) > 0) {
                if (bl2 && bl3 && !this.verify(iSegmentGapVerifier, k2, k3, arrayList)) {
                    return arrayList;
                }
                return arrayList;
            }
            if (bl2 && !this.verify(iSegmentGapVerifier, k2, object.getBegin(), arrayList)) {
                return arrayList;
            }
        }
        NavigableMap navigableMap = this.subMap(object.getBegin(), false, (Object)k3, false);
        Iterator iterator = navigableMap.keySet().iterator();
        while (iterator.hasNext()) {
            Comparable comparable = (Comparable)iterator.next();
            ISegment iSegment = (ISegment)navigableMap.get(comparable);
            Object k4 = object.getEnd();
            int n2 = this.compareKeys(iSegment.getBegin(), k4);
            if (n2 > 0 && !this.verify(iSegmentGapVerifier, k4, iSegment.getBegin(), arrayList)) {
                return arrayList;
            }
            object = iSegment;
        }
        if (bl3 && (n = this.compareKeys(k3, iterator = object.getEnd())) > 0 && !this.verify(iSegmentGapVerifier, iterator, k3, arrayList)) {
            return arrayList;
        }
        return arrayList;
    }

    @Override
    public List<Couple<K, K>> generateGaps(K k2, boolean bl2, K k3, boolean bl3) {
        return this.generateGaps(k2, bl2, k3, bl3, null);
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + (this.removeSegmentsOnOverlap ? 1231 : 1237);
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SegmentMap segmentMap = (SegmentMap)object;
        return this.removeSegmentsOnOverlap == segmentMap.removeSegmentsOnOverlap;
    }

    @Override
    public String toString() {
        return String.format("smap:%d[%s]", this.size(), super.toString());
    }
}

