/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ItemHistory<T> {
    private static final ILogger logger = GlobalLog.getLogger(ItemHistory.class, Integer.MAX_VALUE);
    int capacity;
    boolean cleanHistoryAfterIndex;
    private List<T> history = new ArrayList<T>();
    private int index = 0;

    public ItemHistory() {
        this(100, true);
    }

    public ItemHistory(int n, boolean bl2) {
        this.capacity(n);
        this.cleanHistoryAfterIndex = bl2;
    }

    public void reset() {
        this.history.clear();
        this.index = 0;
    }

    public int size() {
        return this.history.size();
    }

    public int capacity() {
        return this.capacity;
    }

    public void capacity(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid capacity: " + n);
        }
        this.capacity = n;
        this.trim();
    }

    private void trim() {
        if (this.history.size() <= this.capacity) {
            return;
        }
        int n = 0;
        while (this.history.size() > this.capacity) {
            this.history.remove(0);
            ++n;
        }
        this.index = Math.max(0, this.index - n);
    }

    public int position() {
        return this.index;
    }

    public void add(T t) {
        if (this.cleanHistoryAfterIndex) {
            while (this.index < this.history.size()) {
                this.history.remove(this.index);
            }
        }
        this.history.add(t);
        this.index = this.history.size();
        this.trim();
    }

    public void addAll(Collection<T> collection) {
        if (this.cleanHistoryAfterIndex) {
            while (this.index < this.history.size()) {
                this.history.remove(this.index);
            }
        }
        this.history.addAll(collection);
        this.index = this.history.size();
        this.trim();
    }

    public boolean remove(T t) {
        for (int j = this.history.size() - 1; j >= 0; --j) {
            if (!this.history.get(j).equals(t)) continue;
            this.history.remove(j);
            if (j < this.index) {
                --this.index;
            }
            return true;
        }
        return false;
    }

    public T getMostRecent() {
        if (this.history.isEmpty()) {
            return null;
        }
        return this.history.get(this.history.size() - 1);
    }

    public List<T> get() {
        return new ArrayList<T>(this.history);
    }

    public T getPrevious() {
        return this.getPrevious(null);
    }

    public T getPrevious(T t) {
        if (this.index == 0) {
            return null;
        }
        --this.index;
        T t2 = this.history.get(this.index);
        if (t != null) {
            this.history.set(this.index, t);
        }
        return t2;
    }

    public T getNext() {
        return this.getNext(null);
    }

    public T getNext(T t) {
        if (this.index == this.history.size()) {
            return null;
        }
        T t2 = this.history.get(this.index);
        if (t != null) {
            this.history.set(this.index, t);
        }
        ++this.index;
        return t2;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.history.size();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int j = 0; j < this.history.size(); ++j) {
            String string = j == this.position() ? "->" : "  ";
            stringBuilder.append(String.format("%s %s\n", string, this.history.get(j)));
        }
        if (this.position() == this.history.size()) {
            stringBuilder.append("->\n");
        }
        return stringBuilder.toString();
    }
}

