/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.collect.KeyOrder;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

@Ser
public class BiMap<K, V> {
    @SerId(value=1)
    private Map<K, V> map;
    @SerId(value=2)
    private Map<V, K> rmap;

    public BiMap() {
        this(KeyOrder.NONE);
    }

    public BiMap(KeyOrder keyOrder) {
        if (keyOrder == null) {
            throw new NullPointerException("Illegal key order");
        }
        switch (keyOrder) {
            case NONE: {
                this.map = new HashMap();
                this.rmap = new HashMap<V, K>();
                break;
            }
            case INSERTION: {
                this.map = new LinkedHashMap();
                this.rmap = new LinkedHashMap<V, K>();
                break;
            }
            case NATURAL: {
                this.map = new TreeMap();
                this.rmap = new TreeMap<V, K>();
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public void clear() {
        this.map.clear();
        this.rmap.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        int n = this.map.size();
        if (this.rmap.size() != n) {
            throw new IllegalStateException();
        }
        return n;
    }

    public V put(K k2, V v2) {
        K k3;
        if (k2 == null) {
            throw new IllegalArgumentException("Illegal null key");
        }
        if (v2 == null) {
            throw new IllegalArgumentException("Illegal null key");
        }
        V v3 = this.map.put(k2, v2);
        if (v3 != null) {
            this.rmap.remove(v3);
        }
        if ((k3 = this.rmap.put(v2, k2)) != null) {
            this.map.remove(k3);
        }
        return v3;
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean containsKey(K k2) {
        return this.map.containsKey(k2);
    }

    public boolean containsValue(V v2) {
        return this.rmap.containsKey(v2);
    }

    public V get(K k2) {
        return this.map.get(k2);
    }

    public K getKeyForValue(V v2) {
        return this.rmap.get(v2);
    }

    public V remove(K k2) {
        V v2 = this.map.remove(k2);
        if (v2 != null) {
            this.rmap.remove(v2);
        }
        return v2;
    }

    public K removeValue(V v2) {
        K k2 = this.rmap.remove(v2);
        if (k2 != null) {
            this.map.remove(k2);
        }
        return k2;
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public Set<V> values() {
        return this.rmap.keySet();
    }

    public String toString() {
        return this.map.toString();
    }
}

