/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.collect.ConcurrentHashSet;
import com.pnfsoftware.jeb.util.math.MathUtil;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerConstructor;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
public class AddressHashSet
extends ConcurrentHashSet<Long> {
    @SerId(value=1)
    private long invmask;

    @SerConstructor
    private AddressHashSet() {
        this(1);
    }

    public AddressHashSet(int n) {
        if (n <= 0 || n > 64) {
            throw new IllegalArgumentException();
        }
        this.invmask = MathUtil.makeInverseMask(n);
    }

    @Override
    public boolean add(Long l2) {
        if ((l2 & this.invmask) != 0L) {
            throw new IllegalArgumentException(String.format("Illegal address: 0x%X", l2));
        }
        return super.add(l2);
    }
}

