/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.base;

import java.io.PrintWriter;
import java.io.StringWriter;

public class Throwables {
    public static String formatStacktrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return ((Object)stringWriter).toString();
    }

    public static String formatStacktraceShort(Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder("EXCEPTION: ");
        while (true) {
            stringBuilder.append(throwable.toString());
            if (throwable.getStackTrace().length > 0) {
                stringBuilder.append(" in " + throwable.getStackTrace()[0]);
            }
            if ((throwable = throwable.getCause()) == null) break;
            stringBuilder.append(" / caused by: ");
        }
        return stringBuilder.toString();
    }

    public static void rethrowUnchecked(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new RuntimeException(throwable);
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable throwable2;
        while ((throwable2 = throwable.getCause()) != null) {
            throwable = throwable2;
        }
        return throwable;
    }
}

