/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.base;

public enum OSType {
    UNKNOWN,
    LINUX32,
    LINUX64,
    OSX32,
    OSX64,
    WIN32,
    WIN64;


    public static OSType determine() {
        String string = System.getProperty("os.arch", "");
        String string2 = System.getProperty("os.name", "");
        boolean bl2 = string.contains("64");
        if (string2.startsWith("Windows")) {
            return bl2 ? WIN64 : WIN32;
        }
        if (string2.startsWith("Mac")) {
            return bl2 ? OSX64 : OSX32;
        }
        if (string2.startsWith("Linux")) {
            return bl2 ? LINUX64 : LINUX32;
        }
        return UNKNOWN;
    }

    public boolean isWindows() {
        return this == WIN32 || this == WIN64;
    }

    public boolean isMac() {
        return this == OSX32 || this == OSX64;
    }

    public boolean isLinux() {
        return this == LINUX32 || this == LINUX64;
    }

    public boolean is32bit() {
        return this == WIN32 || this == OSX32 || this == LINUX32;
    }

    public boolean is64bit() {
        return this == WIN64 || this == OSX64 || this == LINUX64;
    }
}

