/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.base;

import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class JavaUtil {
    private static final HashSet<String> keywords = new HashSet();
    private static HashMap<String, String> primToWrapper;
    private static HashMap<String, String> wrapperToPrim;
    private static HashMap<String, String> primToLetter;
    private static HashMap<String, String> letterToPrim;

    public static boolean isKeyword(String string) {
        return keywords.contains(string);
    }

    public static boolean isReservedLiteral(String string) {
        return JavaUtil.isKeyword(string) || string.equals("null") || string.equals("true") || string.equals("false");
    }

    public static boolean isValidIdentifierName(String string) {
        if (string.length() == 0 || JavaUtil.isReservedLiteral(string)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int j = 1; j < string.length(); ++j) {
            if (Character.isJavaIdentifierPart(string.charAt(j))) continue;
            return false;
        }
        return true;
    }

    public static String extractSimpleName(String string, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!JavaUtil.isInternalClassname(string, bl2, arrayList)) {
            return null;
        }
        return (String)arrayList.get(arrayList.size() - 1);
    }

    public static String extractFullName(String string, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!JavaUtil.isInternalClassname(string, bl2, arrayList)) {
            return null;
        }
        return Strings.join(".", arrayList);
    }

    public static boolean isInternalClassname(String string, boolean bl2, List<String> list) {
        if (string.length() < 3 || !string.startsWith("L") || !string.endsWith(";")) {
            return false;
        }
        String[] stringArray = string.substring(1, string.length() - 1).split("/", -1);
        if (stringArray.length == 0) {
            return false;
        }
        if (bl2) {
            for (String string2 : stringArray) {
                if (JavaUtil.isValidIdentifierName(string2)) continue;
                return false;
            }
        }
        if (list != null) {
            list.clear();
            for (String string2 : stringArray) {
                list.add(string2);
            }
        }
        return true;
    }

    public static boolean isValidInternalClassname(String string, List<String> list) {
        return JavaUtil.isInternalClassname(string, true, list);
    }

    public static boolean isValidInternalClassname(String string) {
        return JavaUtil.isValidInternalClassname(string, null);
    }

    public static boolean isClassname(String string, boolean bl2, List<String> list) {
        String[] stringArray = string.split("\\.", -1);
        if (stringArray.length == 0) {
            return false;
        }
        if (bl2) {
            for (String string2 : stringArray) {
                if (JavaUtil.isValidIdentifierName(string2)) continue;
                return false;
            }
        }
        if (list != null) {
            list.clear();
            for (String string2 : stringArray) {
                list.add(string2);
            }
        }
        return true;
    }

    public static boolean isValidClassname(String string, List<String> list) {
        return JavaUtil.isClassname(string, true, list);
    }

    public static boolean isValidClassname(String string) {
        return JavaUtil.isValidClassname(string, null);
    }

    public static String primitiveToWrapper(String string) {
        return primToWrapper.get(string);
    }

    public static String wrapperToPrimitive(String string) {
        return wrapperToPrim.get(string);
    }

    public static String primitiveToLetter(String string) {
        return primToLetter.get(string);
    }

    public static String letterToPrimitive(String string) {
        return letterToPrim.get(string);
    }

    public static boolean isReservedMethodName(String string) {
        return Strings.isContainedIn(string, "<init>", "<clinit>");
    }

    static {
        for (JavaKeyword javaKeyword : JavaKeyword.values()) {
            keywords.add(javaKeyword.toString().toLowerCase());
        }
        primToWrapper = new HashMap();
        primToWrapper.put("boolean", "Ljava/lang/Boolean;");
        primToWrapper.put("byte", "Ljava/lang/Byte;");
        primToWrapper.put("char", "Ljava/lang/Character;");
        primToWrapper.put("short", "Ljava/lang/Short;");
        primToWrapper.put("int", "Ljava/lang/Integer;");
        primToWrapper.put("long", "Ljava/lang/Long;");
        primToWrapper.put("float", "Ljava/lang/Float;");
        primToWrapper.put("double", "Ljava/lang/Double;");
        wrapperToPrim = new HashMap();
        wrapperToPrim.put("Ljava/lang/Boolean;", "boolean");
        wrapperToPrim.put("Ljava/lang/Byte;", "byte");
        wrapperToPrim.put("Ljava/lang/Character;", "char");
        wrapperToPrim.put("Ljava/lang/Short;", "short");
        wrapperToPrim.put("Ljava/lang/Integer;", "int");
        wrapperToPrim.put("Ljava/lang/Long;", "long");
        wrapperToPrim.put("Ljava/lang/Float;", "float");
        wrapperToPrim.put("Ljava/lang/Double;", "double");
        primToLetter = new HashMap();
        primToLetter.put("boolean", "Z");
        primToLetter.put("byte", "B");
        primToLetter.put("char", "C");
        primToLetter.put("short", "S");
        primToLetter.put("int", "I");
        primToLetter.put("long", "J");
        primToLetter.put("float", "F");
        primToLetter.put("double", "D");
        letterToPrim = new HashMap();
        letterToPrim.put("Z", "boolean");
        letterToPrim.put("B", "byte");
        letterToPrim.put("C", "char");
        letterToPrim.put("S", "short");
        letterToPrim.put("I", "int");
        letterToPrim.put("J", "long");
        letterToPrim.put("F", "float");
        letterToPrim.put("D", "double");
    }

    private static enum JavaKeyword {
        ABSTRACT,
        ASSERT,
        BOOLEAN,
        BREAK,
        BYTE,
        CASE,
        CATCH,
        CHAR,
        CLASS,
        CONST,
        CONTINUE,
        DEFAULT,
        DO,
        DOUBLE,
        ELSE,
        ENUM,
        EXTENDS,
        FINAL,
        FINALLY,
        FLOAT,
        FOR,
        GOTO,
        IF,
        IMPLEMENTS,
        IMPORT,
        INSTANCEOF,
        INT,
        INTERFACE,
        LONG,
        NATIVE,
        NEW,
        PACKAGE,
        PRIVATE,
        PROTECTED,
        PUBLIC,
        RETURN,
        SHORT,
        STATIC,
        STRICTFP,
        SUPER,
        SWITCH,
        SYNCHRONIZED,
        THIS,
        THROW,
        THROWS,
        TRANSIENT,
        TRY,
        VOID,
        VOLATILE,
        WHILE;

    }
}

