/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.base;

import com.pnfsoftware.jeb.util.base.Throwables;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;

public class Enums {
    public static <T extends Enum<T>> int getValue(Enum<T> enum_) {
        try {
            int n = 0;
            for (Field field : enum_.getClass().getDeclaredFields()) {
                if (!field.isEnumConstant()) continue;
                if (enum_.ordinal() == n) {
                    Value value = field.getAnnotation(Value.class);
                    if (value == null) {
                        throw new IllegalArgumentException("Enum-constant does not specify a value");
                    }
                    return value.value();
                }
                ++n;
            }
        }
        catch (Exception exception) {
            Throwables.rethrowUnchecked(exception);
        }
        throw new RuntimeException();
    }

    public static <T extends Enum<T>> T fromValue(Class<? extends Enum<T>> clazz, int n) {
        try {
            int n2 = 0;
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.isEnumConstant()) continue;
                Value value = field.getAnnotation(Value.class);
                if (value != null && value.value() == n) {
                    return (T)clazz.getEnumConstants()[n2];
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            Throwables.rethrowUnchecked(exception);
        }
        throw new IllegalArgumentException(String.format("Cannot find enum-constant having value %d in enum %s", n, clazz.getName()));
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Value {
        public int value();
    }
}

