/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.jar;

import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.JebCoreService;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.AbstractBinaryUnit;
import com.pnfsoftware.jeb.core.units.IArchiveUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.impl.DataContainerUnit;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveInputStream;

@Ser
public class OI
extends AbstractBinaryUnit
implements IArchiveUnit {
    private static final ILogger eO = GlobalLog.getLogger(OI.class);

    public OI(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, IPropertyDefinitionManager iPropertyDefinitionManager) {
        super("application/zip", iInput, "jar", string, iUnitProcessor, iUnitCreator, iPropertyDefinitionManager);
    }

    @Override
    protected boolean processInternal() {
        TreeMap<String, DataContainerUnit.Entry> treeMap;
        block26: {
            treeMap = new TreeMap<String, DataContainerUnit.Entry>();
            try {
                JarArchiveInputStream jarArchiveInputStream = new JarArchiveInputStream(this.getInput().getStream());
                Throwable throwable = null;
                block14: while (true) {
                    try {
                        while (true) {
                            JarArchiveEntry jarArchiveEntry = null;
                            try {
                                DataContainerUnit.Entry entry;
                                int n;
                                int n2;
                                byte[] byArray;
                                jarArchiveEntry = jarArchiveInputStream.getNextJarEntry();
                                if (jarArchiveEntry == null) {
                                    break block26;
                                }
                                String string = jarArchiveEntry.getName();
                                if (!jarArchiveInputStream.canReadEntryData((ArchiveEntry)jarArchiveEntry)) {
                                    byArray = new byte[]{};
                                    n2 = 0;
                                    this.logError(true, "The JAR entry \"%s\" cannot be read; it is either encrypted or is using an unsupported compression scheme", jarArchiveEntry.getName());
                                } else {
                                    byArray = IO.readInputStream((InputStream)jarArchiveInputStream);
                                    n2 = byArray.length;
                                    eO.i("JAR entry: name=%s compressed=%d uncomp=%d (read=%d) dir=%b", string, jarArchiveEntry.getCompressedSize(), jarArchiveEntry.getSize(), n2, jarArchiveEntry.isDirectory());
                                }
                                Map<Object, Object> map = treeMap;
                                List<String> list = IO.parsePathElements(string);
                                if (list.isEmpty()) {
                                    this.logWarn(true, "Illegal jar entry name: \"%s\"", string);
                                    continue;
                                }
                                for (n = 0; n < list.size() - 1; ++n) {
                                    entry = (DataContainerUnit.Entry)map.get(list.get(n));
                                    if (entry == null) {
                                        entry = DataContainerUnit.Entry.createFolder(list.get(n));
                                        map.put(list.get(n), entry);
                                    }
                                    map = entry.getChildren();
                                }
                                entry = jarArchiveEntry.isDirectory() ? DataContainerUnit.Entry.createFolder(list.get(n)) : DataContainerUnit.Entry.create(list.get(n), byArray);
                                map.put(list.get(n), entry);
                                continue block14;
                            }
                            catch (IOException iOException) {
                                if (jarArchiveEntry == null) {
                                    eO.catching(iOException);
                                    break block26;
                                }
                                this.logError(true, "Entry \"%s\" is corrupted", jarArchiveEntry.getName());
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    if (jarArchiveInputStream != null) {
                        if (throwable != null) {
                            try {
                                jarArchiveInputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            jarArchiveInputStream.close();
                        }
                    }
                }
            }
            catch (ZipException zipException) {
                eO.catching(zipException);
                JebCoreService.notifySilentExceptionToClient(zipException);
            }
            catch (IOException iOException) {
                eO.catching(iOException);
                return false;
            }
        }
        DataContainerUnit.register(this, treeMap.values());
        return true;
    }
}

