/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.asm.type.tlgen;

import com.pnfsoftware.jeb.core.units.code.asm.type.TypeLibraryMetadata;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeLibraryService;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypelibException;
import com.pnfsoftware.jeb.core.units.codeobject.CompilerType;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.core.units.codeobject.SubsystemType;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class OI {
    private static final ILogger KQ = GlobalLog.getLogger(OI.class);
    public boolean eO;
    public File Le;
    public File Qx;
    public File lS;
    public TypeLibraryMetadata ae;
    public File TI;
    public Map<String, Integer> vT = new HashMap<String, Integer>();

    public OI(File file, File file2, File file3, TypeLibraryMetadata typeLibraryMetadata) {
        this.eO = true;
        this.Le = file;
        this.Qx = file2;
        this.lS = file3;
        this.ae = typeLibraryMetadata;
    }

    public OI(boolean bl2, String string, String string2, String string3, String string4, boolean bl3, TypeLibraryMetadata typeLibraryMetadata) {
        Object object;
        this.eO = bl2;
        File file = new File(string, "jeb3-core");
        if (string2 != null) {
            if (!(string2.endsWith(".h") || string2.endsWith(".c") || string2.endsWith(".i"))) {
                throw new IllegalArgumentException("Expecting a header file terminated by '.h'");
            }
            this.Le = new File(string2);
            if (!this.Le.isAbsolute()) {
                this.Le = new File(file, string2);
            }
            if (!this.Le.exists()) {
                throw new IllegalArgumentException("Input header file does not exist: " + this.Le);
            }
        }
        if (string3 != null) {
            if (!string3.endsWith(".txt")) {
                throw new IllegalArgumentException("Expecting a constants file terminated by '.txt'");
            }
            this.Qx = new File(file, string3);
            if (!this.Qx.exists()) {
                throw new IllegalArgumentException("Input constants file does not exist: " + this.Qx);
            }
        }
        if (string4 != null) {
            if (string4.endsWith("/")) {
                object = Strings.substring(this.Le.getName(), 0, -2);
                this.lS = new File(new File(file, string4), (String)object + ".typelib");
            } else {
                if (string4.contains(".")) {
                    throw new IllegalArgumentException("Output name should be extension-less");
                }
                this.lS = new File(file, string4 + ".typelib");
            }
        }
        if (bl3) {
            object = new File(string, "jeb3-rcpclient");
            this.TI = new File(new File((File)object, "typelibs"), this.lS.getName());
        }
        this.ae = typeLibraryMetadata;
    }

    public String toString() {
        return String.format("%s -> %s [%s]", this.Le, this.lS, this.ae);
    }

    public static OI eO(File file) throws TypelibException {
        try {
            return OI.eO(Strings.decodeLocal(IO.readFile(file)));
        }
        catch (IOException iOException) {
            throw new TypelibException(iOException);
        }
    }

    public static OI eO(String string) throws TypelibException {
        File file = null;
        File file2 = null;
        File file3 = null;
        ProcessorType processorType = null;
        SubsystemType subsystemType = null;
        CompilerType compilerType = null;
        int n = 0;
        double d2 = 0.0;
        int n2 = 0;
        int n3 = 0;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n4 = 0;
        for (String string5 : Strings.splitLines(string)) {
            String[] stringArray;
            ++n4;
            if ((string5 = Strings.trim(string5)).isEmpty() || string5.startsWith(";") || (stringArray = string5.split("=")).length != 2) continue;
            String string6 = stringArray[0].trim();
            String string7 = stringArray[1].trim();
            if (string7.isEmpty()) continue;
            try {
                switch (string6) {
                    case "hdrsrc": {
                        file = new File(string7);
                        break;
                    }
                    case "cstsrc": {
                        file2 = new File(string7);
                        break;
                    }
                    case "output": {
                        if (!string7.endsWith(".typelib")) {
                            string7 = string7 + ".typelib";
                        }
                        file3 = new File(string7);
                        break;
                    }
                    case "processor": {
                        processorType = ProcessorType.valueOf(string7.toUpperCase());
                        break;
                    }
                    case "subsystem": {
                        subsystemType = SubsystemType.valueOf(string7.toUpperCase());
                        break;
                    }
                    case "compiler": {
                        compilerType = CompilerType.valueOf(string7.toUpperCase());
                        break;
                    }
                    case "groupid": {
                        try {
                            n = Integer.parseInt(string7);
                        }
                        catch (NumberFormatException numberFormatException) {
                            Field field = TypeLibraryService.class.getField(string7);
                            n = field.getInt(null);
                        }
                        break;
                    }
                    case "priority": {
                        d2 = Double.parseDouble(string7);
                        break;
                    }
                    case "uuid": {
                        n2 = Integer.parseInt(string7);
                        break;
                    }
                    case "version": {
                        n3 = Integer.parseInt(string7);
                        break;
                    }
                    case "name": {
                        string2 = string7;
                        break;
                    }
                    case "description": {
                        string3 = string7;
                        break;
                    }
                    case "author": {
                        string4 = string7;
                        break;
                    }
                    default: {
                        KQ.warn("Line %d: Skipping unknown entry: %s", n4, string6);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                throw new TypelibException(String.format("Line %d: Invalid entry: %s: %s", n4, string6, string7), exception);
            }
        }
        if (file != null && !file.isFile()) {
            throw new TypelibException("Missing hdrsrc file: " + file);
        }
        if (file2 != null && !file2.isFile()) {
            throw new TypelibException("Missing cstsrc file: " + file2);
        }
        if (file == null && file2 == null) {
            throw new TypelibException("Specify at least one of the hdrsrc or cstsrc entries");
        }
        if (processorType == null) {
            throw new TypelibException("Missing entry: processor");
        }
        TypeLibraryMetadata typeLibraryMetadata = TypeLibraryMetadata.create(processorType, subsystemType, compilerType, n, d2, n2, n3, string2, string3, string4);
        return new OI(file, file2, file3, typeLibraryMetadata);
    }
}

