/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.art;

import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.AbstractBinaryUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.code.android.DexUtil;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.nio.ByteBuffer;
import java.text.ParseException;

@Ser
public class OI
extends AbstractBinaryUnit {
    private static final ILogger eO = GlobalLog.getLogger(OI.class);
    @SerId(value=1)
    private Integer Le;

    protected OI(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, IPropertyDefinitionManager iPropertyDefinitionManager) {
        super(null, iInput, "art", string, iUnitProcessor, iUnitCreator, iPropertyDefinitionManager);
    }

    @Override
    protected boolean processInternal() {
        ByteBuffer byteBuffer = this.getInput().getHeader();
        if (byteBuffer.remaining() < 8) {
            return false;
        }
        try {
            this.Le = DexUtil.getVersion(this);
        }
        catch (ParseException parseException) {
            eO.catching(parseException);
        }
        return true;
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder(super.getDescription());
        stringBuilder.append("\n");
        stringBuilder.append(String.format("Android ART file, version %s:\n", this.Le == null ? "?" : this.Le.toString()));
        stringBuilder.append(String.format("\n", new Object[0]));
        stringBuilder.append(String.format("!! JEB does not provide support for parsing ART files !!\n", new Object[0]));
        stringBuilder.append(String.format("\n", new Object[0]));
        stringBuilder.append(String.format("Please use a third-party tool to extract relevant data, and process them with JEB.\n", new Object[0]));
        return stringBuilder.toString();
    }
}

